/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.util.Shell;

public class ShellBasedUnixGroupsMapping
implements GroupMappingServiceProvider {
    Map<String, List<String>> userGroups = new ConcurrentHashMap<String, List<String>>();
    private static final Log LOG = LogFactory.getLog(ShellBasedUnixGroupsMapping.class);

    @Override
    public List<String> getGroups(String user) throws IOException {
        List<String> groups = this.userGroups.get(user);
        if (groups == null) {
            groups = ShellBasedUnixGroupsMapping.getUnixGroups(user);
            this.userGroups.put(user, groups);
        }
        return groups;
    }

    private static List<String> getUnixGroups(String user) throws IOException {
        String result = "";
        try {
            result = Shell.execCommand(Shell.getGroupsForUserCommand(user));
        }
        catch (Shell.ExitCodeException e) {
            LOG.warn((Object)("got exception trying to get groups for user " + user), (Throwable)e);
        }
        StringTokenizer tokenizer = new StringTokenizer(result);
        LinkedList<String> groups = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
        return groups;
    }
}

