/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.security.UserGroupInformation;

public class AccessControlList {
    public static final String WILDCARD_ACL_VALUE = "*";
    private Set<String> users = new TreeSet<String>();
    private Set<String> groups = new TreeSet<String>();
    private boolean allAllowed;

    public AccessControlList(String aclString) {
        if (aclString.contains(WILDCARD_ACL_VALUE) && aclString.trim().equals(WILDCARD_ACL_VALUE)) {
            this.allAllowed = true;
        } else {
            String[] groupsStr;
            String[] usersStr;
            String[] userGroupStrings = aclString.split(" ", 2);
            if (userGroupStrings.length >= 1 && (usersStr = userGroupStrings[0].split(",")).length >= 1) {
                AccessControlList.addToSet(this.users, usersStr);
            }
            if (userGroupStrings.length == 2 && (groupsStr = userGroupStrings[1].split(",")).length >= 1) {
                AccessControlList.addToSet(this.groups, groupsStr);
            }
        }
    }

    public boolean isAllAllowed() {
        return this.allAllowed;
    }

    Set<String> getUsers() {
        return this.users;
    }

    Set<String> getGroups() {
        return this.groups;
    }

    public boolean isUserAllowed(UserGroupInformation ugi) {
        if (this.allAllowed || this.users.contains(ugi.getShortUserName())) {
            return true;
        }
        for (String group : ugi.getGroupNames()) {
            if (!this.groups.contains(group)) continue;
            return true;
        }
        return false;
    }

    private static final void addToSet(Set<String> set, String[] strings) {
        for (String s : strings) {
            if ((s = s.trim()).length() <= 0) continue;
            set.add(s);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String user : this.users) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(user);
        }
        if (!this.groups.isEmpty()) {
            sb.append(" ");
        }
        first = true;
        for (String group : this.groups) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(group);
        }
        return sb.toString();
    }
}

