/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

class INodeDirectory
extends INode {
    protected static final int DEFAULT_FILES_PER_DIRECTORY = 5;
    static final String ROOT_NAME = "";
    private List<INode> children;

    INodeDirectory(String name, PermissionStatus permissions) {
        super(name, permissions);
        this.children = null;
    }

    public INodeDirectory(PermissionStatus permissions, long mTime) {
        super(permissions, mTime, 0L);
        this.children = null;
    }

    INodeDirectory(byte[] localName, PermissionStatus permissions, long mTime) {
        this(permissions, mTime);
        this.name = localName;
    }

    INodeDirectory(INodeDirectory other) {
        super(other);
        this.children = other.getChildren();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    INode removeChild(INode node) {
        assert (this.children != null);
        int low = Collections.binarySearch(this.children, node.name);
        if (low >= 0) {
            return this.children.remove(low);
        }
        return null;
    }

    void replaceChild(INode newChild) {
        if (this.children == null) {
            throw new IllegalArgumentException("The directory is empty");
        }
        int low = Collections.binarySearch(this.children, newChild.name);
        if (low < 0) {
            throw new IllegalArgumentException("No child exists to be replaced");
        }
        this.children.set(low, newChild);
    }

    INode getChild(String name) {
        return this.getChildINode(DFSUtil.string2Bytes(name));
    }

    private INode getChildINode(byte[] name) {
        if (this.children == null) {
            return null;
        }
        int low = Collections.binarySearch(this.children, name);
        if (low >= 0) {
            return this.children.get(low);
        }
        return null;
    }

    private INode getNode(byte[][] components, boolean resolveLink) throws UnresolvedLinkException {
        INode[] inode = new INode[1];
        this.getExistingPathINodes(components, inode, resolveLink);
        return inode[0];
    }

    INode getNode(String path, boolean resolveLink) throws UnresolvedLinkException {
        return this.getNode(INodeDirectory.getPathComponents(path), resolveLink);
    }

    int getExistingPathINodes(byte[][] components, INode[] existing, boolean resolveLink) throws UnresolvedLinkException {
        assert (INodeDirectory.compareBytes(this.name, components[0]) == 0) : "Incorrect name " + this.getLocalName() + " expected " + DFSUtil.bytes2String(components[0]);
        INode curNode = this;
        int count = 0;
        int index = existing.length - components.length;
        if (index > 0) {
            index = 0;
        }
        while (count < components.length && curNode != null) {
            boolean lastComp;
            boolean bl = lastComp = count == components.length - 1;
            if (index >= 0) {
                existing[index] = curNode;
            }
            if (curNode.isLink() && (!lastComp || lastComp && resolveLink)) {
                NameNode.stateChangeLog.debug((Object)("UnresolvedPathException  count: " + count + " componenent: " + DFSUtil.bytes2String(components[count]) + " full path: " + INodeDirectory.constructPath(components, 0) + " remaining path: " + INodeDirectory.constructPath(components, count + 1) + " symlink: " + ((INodeSymlink)curNode).getLinkValue()));
                String linkTarget = ((INodeSymlink)curNode).getLinkValue();
                throw new UnresolvedPathException(INodeDirectory.constructPath(components, 0), INodeDirectory.constructPath(components, count + 1), linkTarget);
            }
            if (lastComp || !((INode)curNode).isDirectory()) break;
            INodeDirectory parentDir = curNode;
            curNode = parentDir.getChildINode(components[count + 1]);
            ++count;
            ++index;
        }
        return count;
    }

    INode[] getExistingPathINodes(String path, boolean resolveLink) throws UnresolvedLinkException {
        byte[][] components = INodeDirectory.getPathComponents(path);
        INode[] inodes = new INode[components.length];
        this.getExistingPathINodes(components, inodes, resolveLink);
        return inodes;
    }

    int nextChild(byte[] name) {
        if (name.length == 0) {
            return 0;
        }
        int nextPos = Collections.binarySearch(this.children, name) + 1;
        if (nextPos >= 0) {
            return nextPos;
        }
        return -nextPos;
    }

    <T extends INode> T addChild(T node, boolean inheritPermission) {
        int low;
        if (inheritPermission) {
            FsPermission p = this.getFsPermission();
            if (!p.getUserAction().implies(FsAction.WRITE_EXECUTE)) {
                p = new FsPermission(p.getUserAction().or(FsAction.WRITE_EXECUTE), p.getGroupAction(), p.getOtherAction());
            }
            node.setPermission(p);
        }
        if (this.children == null) {
            this.children = new ArrayList<INode>(5);
        }
        if ((low = Collections.binarySearch(this.children, node.name)) >= 0) {
            return null;
        }
        node.parent = this;
        this.children.add(-low - 1, node);
        this.setModificationTime(node.getModificationTime());
        if (node.getGroupName() == null) {
            node.setGroup(this.getGroupName());
        }
        return node;
    }

    <T extends INode> T addNode(String path, T newNode) throws FileNotFoundException, UnresolvedLinkException {
        return this.addNode(path, newNode, false);
    }

    <T extends INode> T addNode(String path, T newNode, boolean inheritPermission) throws FileNotFoundException, UnresolvedLinkException {
        if (this.addToParent(path, newNode, null, inheritPermission) == null) {
            return null;
        }
        return newNode;
    }

    <T extends INode> INodeDirectory addToParent(String path, T newNode, INodeDirectory parent, boolean inheritPermission) throws FileNotFoundException, UnresolvedLinkException {
        byte[][] pathComponents = INodeDirectory.getPathComponents(path);
        assert (pathComponents != null) : "Incorrect path " + path;
        int pathLen = pathComponents.length;
        if (pathLen < 2) {
            return null;
        }
        if (parent == null) {
            INode[] inodes = new INode[2];
            this.getExistingPathINodes(pathComponents, inodes, false);
            INode inode = inodes[0];
            if (inode == null) {
                throw new FileNotFoundException("Parent path does not exist: " + path);
            }
            if (!inode.isDirectory()) {
                throw new FileNotFoundException("Parent path is not a directory: " + path);
            }
            parent = (INodeDirectory)inode;
        }
        newNode.name = pathComponents[pathLen - 1];
        if (parent.addChild(newNode, inheritPermission) == null) {
            return null;
        }
        return parent;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) {
        ++counts.nsCount;
        if (this.children != null) {
            for (INode child : this.children) {
                child.spaceConsumedInTree(counts);
            }
        }
        return counts;
    }

    @Override
    long[] computeContentSummary(long[] summary) {
        if (this.children != null) {
            for (INode child : this.children) {
                child.computeContentSummary(summary);
            }
        }
        if (this instanceof INodeDirectoryWithQuota) {
            INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)this;
            long space = node.diskspaceConsumed();
            if (-1L != node.getDsQuota() && space != summary[3]) {
                NameNode.LOG.warn((Object)("Inconsistent diskspace for directory " + this.getLocalName() + ". Cached: " + space + " Computed: " + summary[3]));
            }
        }
        summary[2] = summary[2] + 1L;
        return summary;
    }

    List<INode> getChildren() {
        return this.children == null ? new ArrayList() : this.children;
    }

    List<INode> getChildrenRaw() {
        return this.children;
    }

    @Override
    int collectSubtreeBlocksAndClear(List<Block> v) {
        int total = 1;
        if (this.children == null) {
            return total;
        }
        for (INode child : this.children) {
            total += child.collectSubtreeBlocksAndClear(v);
        }
        this.parent = null;
        this.children = null;
        return total;
    }
}

