/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.security.UserGroupInformation;
import org.mortbay.jetty.InclusiveByteRange;

@InterfaceAudience.Private
public class StreamFile
extends DfsServlet {
    private static final long serialVersionUID = 1L;
    static InetSocketAddress nameNodeAddr;
    static DataNode datanode;

    protected DFSClient getDFSClient(HttpServletRequest request) throws IOException, InterruptedException {
        final Configuration conf = (Configuration)this.getServletContext().getAttribute("name.conf");
        UserGroupInformation ugi = this.getUGI(request, conf);
        DFSClient client = (DFSClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DFSClient>(){

            @Override
            public DFSClient run() throws IOException {
                return new DFSClient(nameNodeAddr, conf);
            }
        });
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DFSClient dfs;
        String filename = JspHelper.validatePath(request.getParameter("filename"));
        if (filename == null) {
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.print("Invalid input");
            return;
        }
        Enumeration reqRanges = request.getHeaders("Range");
        if (reqRanges != null && !reqRanges.hasMoreElements()) {
            reqRanges = null;
        }
        try {
            dfs = this.getDFSClient(request);
        }
        catch (InterruptedException e) {
            response.sendError(400, e.getMessage());
            return;
        }
        long fileLen = dfs.getFileInfo(filename).getLen();
        DFSInputStream in = dfs.open(filename);
        ServletOutputStream os = response.getOutputStream();
        try {
            if (reqRanges != null) {
                List ranges = InclusiveByteRange.satisfiableRanges((Enumeration)reqRanges, (long)fileLen);
                StreamFile.sendPartialData(in, (OutputStream)os, response, fileLen, ranges);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                response.setContentType("application/octet-stream");
                StreamFile.writeTo(in, (OutputStream)os, 0L, fileLen);
            }
        }
        finally {
            in.close();
            os.close();
            dfs.close();
        }
    }

    static void sendPartialData(FSInputStream in, OutputStream os, HttpServletResponse response, long contentLength, List ranges) throws IOException {
        if (ranges == null || ranges.size() != 1) {
            response.setContentLength(0);
            int status = 416;
            response.setStatus(status);
            response.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString((long)contentLength));
        } else {
            InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
            long singleLength = singleSatisfiableRange.getSize(contentLength);
            response.setStatus(206);
            response.setHeader("Content-Range", singleSatisfiableRange.toHeaderRangeString(contentLength));
            System.out.println("first: " + singleSatisfiableRange.getFirst(contentLength));
            System.out.println("singleLength: " + singleLength);
            StreamFile.writeTo(in, os, singleSatisfiableRange.getFirst(contentLength), singleLength);
        }
    }

    static void writeTo(FSInputStream in, OutputStream os, long start, long count) throws IOException {
        int bytesToRead;
        int bytesRead;
        byte[] buf = new byte[4096];
        long bytesRemaining = count;
        in.seek(start);
        while ((bytesRead = in.read(buf, 0, bytesToRead = (int)(bytesRemaining < (long)buf.length ? bytesRemaining : (long)buf.length))) != -1) {
            os.write(buf, 0, bytesRead);
            if ((bytesRemaining -= (long)bytesRead) > 0L) continue;
            break;
        }
    }

    static {
        datanode = null;
        datanode = DataNode.getDataNode();
        if (datanode != null) {
            nameNodeAddr = datanode.getNameNodeAddr();
        }
    }
}

