/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;

public class BlockPoolTokenSecretManager
extends SecretManager<BlockTokenIdentifier> {
    private final Map<String, BlockTokenSecretManager> map = new HashMap<String, BlockTokenSecretManager>();

    public synchronized void addBlockPool(String bpid, BlockTokenSecretManager secretMgr) {
        this.map.put(bpid, secretMgr);
    }

    synchronized BlockTokenSecretManager get(String bpid) {
        BlockTokenSecretManager secretMgr = this.map.get(bpid);
        if (secretMgr == null) {
            throw new IllegalArgumentException("Block pool " + bpid + " is not found");
        }
        return secretMgr;
    }

    public synchronized boolean isBlockPoolRegistered(String bpid) {
        return this.map.containsKey(bpid);
    }

    public BlockTokenIdentifier createIdentifier() {
        return new BlockTokenIdentifier();
    }

    public byte[] createPassword(BlockTokenIdentifier identifier) {
        return this.get(identifier.getBlockPoolId()).createPassword(identifier);
    }

    public byte[] retrievePassword(BlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        return this.get(identifier.getBlockPoolId()).retrievePassword(identifier);
    }

    public void checkAccess(BlockTokenIdentifier id, String userId, ExtendedBlock block, BlockTokenSecretManager.AccessMode mode) throws SecretManager.InvalidToken {
        this.get(block.getBlockPoolId()).checkAccess(id, userId, block, mode);
    }

    public void checkAccess(Token<BlockTokenIdentifier> token, String userId, ExtendedBlock block, BlockTokenSecretManager.AccessMode mode) throws SecretManager.InvalidToken {
        this.get(block.getBlockPoolId()).checkAccess(token, userId, block, mode);
    }

    public void setKeys(String bpid, ExportedBlockKeys exportedKeys) throws IOException {
        this.get(bpid).setKeys(exportedKeys);
    }

    public Token<BlockTokenIdentifier> generateToken(ExtendedBlock b, EnumSet<BlockTokenSecretManager.AccessMode> of) throws IOException {
        return this.get(b.getBlockPoolId()).generateToken(b, of);
    }
}

