/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;

@InterfaceAudience.Private
public interface FSDatasetInterface
extends FSDatasetMBean {
    public long getMetaDataLength(ExtendedBlock var1) throws IOException;

    public MetaDataInputStream getMetaDataInputStream(ExtendedBlock var1) throws IOException;

    public boolean metaFileExists(ExtendedBlock var1) throws IOException;

    public long getLength(ExtendedBlock var1) throws IOException;

    @Deprecated
    public Replica getReplica(String var1, long var2);

    public String getReplicaString(String var1, long var2);

    public Block getStoredBlock(String var1, long var2) throws IOException;

    public InputStream getBlockInputStream(ExtendedBlock var1) throws IOException;

    public InputStream getBlockInputStream(ExtendedBlock var1, long var2) throws IOException;

    public BlockInputStreams getTmpInputStreams(ExtendedBlock var1, long var2, long var4) throws IOException;

    public ReplicaInPipelineInterface createTemporary(ExtendedBlock var1) throws IOException;

    public ReplicaInPipelineInterface createRbw(ExtendedBlock var1) throws IOException;

    public ReplicaInPipelineInterface recoverRbw(ExtendedBlock var1, long var2, long var4, long var6) throws IOException;

    public ReplicaInPipelineInterface convertTemporaryToRbw(ExtendedBlock var1) throws IOException;

    public ReplicaInPipelineInterface append(ExtendedBlock var1, long var2, long var4) throws IOException;

    public ReplicaInPipelineInterface recoverAppend(ExtendedBlock var1, long var2, long var4) throws IOException;

    public void recoverClose(ExtendedBlock var1, long var2, long var4) throws IOException;

    public void finalizeBlock(ExtendedBlock var1) throws IOException;

    public void unfinalizeBlock(ExtendedBlock var1) throws IOException;

    public BlockListAsLongs getBlockReport(String var1);

    public boolean isValidBlock(ExtendedBlock var1);

    public boolean isValidRbw(ExtendedBlock var1);

    public void invalidate(String var1, Block[] var2) throws IOException;

    public void checkDataDir() throws DiskChecker.DiskErrorException;

    public String toString();

    public void shutdown();

    public void adjustCrcChannelPosition(ExtendedBlock var1, BlockWriteStreams var2, int var3) throws IOException;

    public boolean hasEnoughResource();

    public long getReplicaVisibleLength(ExtendedBlock var1) throws IOException;

    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock var1) throws IOException;

    public ReplicaInfo updateReplicaUnderRecovery(ExtendedBlock var1, long var2, long var4) throws IOException;

    public void addBlockPool(String var1, Configuration var2) throws IOException;

    public void shutdownBlockPool(String var1);

    public void deleteBlockPool(String var1, boolean var2) throws IOException;

    public static class BlockInputStreams
    implements Closeable {
        final InputStream dataIn;
        final InputStream checksumIn;

        BlockInputStreams(InputStream dataIn, InputStream checksumIn) {
            this.dataIn = dataIn;
            this.checksumIn = checksumIn;
        }

        @Override
        public void close() {
            IOUtils.closeStream((Closeable)this.dataIn);
            IOUtils.closeStream((Closeable)this.checksumIn);
        }
    }

    public static class BlockWriteStreams {
        OutputStream dataOut;
        OutputStream checksumOut;
        DataChecksum checksum;

        BlockWriteStreams(OutputStream dOut, OutputStream cOut, DataChecksum checksum) {
            this.dataOut = dOut;
            this.checksumOut = cOut;
            this.checksum = checksum;
        }

        void close() throws IOException {
            IOUtils.closeStream((Closeable)this.dataOut);
            IOUtils.closeStream((Closeable)this.checksumOut);
        }

        DataChecksum getChecksum() {
            return this.checksum;
        }
    }

    public static class MetaDataInputStream
    extends FilterInputStream {
        private long length;

        MetaDataInputStream(InputStream stream, long len) {
            super(stream);
            this.length = len;
        }

        public long getLength() {
            return this.length;
        }
    }
}

