/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.server.datanode.BlockVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.util.DiskChecker;

public class RoundRobinVolumesPolicy
implements BlockVolumeChoosingPolicy {
    private int curVolume = 0;

    @Override
    public synchronized FSDataset.FSVolume chooseVolume(List<FSDataset.FSVolume> volumes, long blockSize) throws IOException {
        if (volumes.size() < 1) {
            throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
        }
        if (this.curVolume >= volumes.size()) {
            this.curVolume = 0;
        }
        int startVolume = this.curVolume;
        long maxAvailable = 0L;
        do {
            FSDataset.FSVolume volume = volumes.get(this.curVolume);
            this.curVolume = (this.curVolume + 1) % volumes.size();
            long availableVolumeSize = volume.getAvailable();
            if (availableVolumeSize > blockSize) {
                return volume;
            }
            if (availableVolumeSize <= maxAvailable) continue;
            maxAvailable = availableVolumeSize;
        } while (this.curVolume != startVolume);
        throw new DiskChecker.DiskOutOfSpaceException("Insufficient space for an additional block. Volume with the most available space has " + maxAvailable + " bytes free, configured block size is " + blockSize);
    }
}

