/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@Metrics(about="DataNode metrics", context="dfs")
@InterfaceAudience.Private
public class DataNodeMetrics {
    @Metric
    MutableCounterLong bytesWritten;
    @Metric
    MutableCounterLong bytesRead;
    @Metric
    MutableCounterLong blocksWritten;
    @Metric
    MutableCounterLong blocksRead;
    @Metric
    MutableCounterLong blocksReplicated;
    @Metric
    MutableCounterLong blocksRemoved;
    @Metric
    MutableCounterLong blocksVerified;
    @Metric
    MutableCounterLong blockVerificationFailures;
    @Metric
    MutableCounterLong readsFromLocalClient;
    @Metric
    MutableCounterLong readsFromRemoteClient;
    @Metric
    MutableCounterLong writesFromLocalClient;
    @Metric
    MutableCounterLong writesFromRemoteClient;
    @Metric
    MutableCounterLong volumeFailures;
    @Metric
    MutableRate readBlockOp;
    @Metric
    MutableRate writeBlockOp;
    @Metric
    MutableRate blockChecksumOp;
    @Metric
    MutableRate copyBlockOp;
    @Metric
    MutableRate replaceBlockOp;
    @Metric
    MutableRate heartbeats;
    @Metric
    MutableRate blockReports;
    final MetricsRegistry registry = new MetricsRegistry("datanode");
    final String name;

    public DataNodeMetrics(String name, String sessionId) {
        this.name = name;
        this.registry.tag((MetricsInfo)MsInfo.SessionId, sessionId);
    }

    public static DataNodeMetrics create(Configuration conf, String dnName) {
        String sessionId = conf.get("dfs.metrics.session-id");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        JvmMetrics.create((String)"DataNode", (String)sessionId, (MetricsSystem)ms);
        String name = "DataNodeActivity-" + (dnName.isEmpty() ? "UndefinedDataNodeName" + DFSUtil.getRandom().nextInt() : dnName.replace(':', '-'));
        return (DataNodeMetrics)ms.register(name, null, (Object)new DataNodeMetrics(name, sessionId));
    }

    public String name() {
        return this.name;
    }

    public void addHeartbeat(long latency) {
        this.heartbeats.add(latency);
    }

    public void addBlockReport(long latency) {
        this.blockReports.add(latency);
    }

    public void incrBlocksReplicated(int delta) {
        this.blocksReplicated.incr((long)delta);
    }

    public void incrBlocksWritten() {
        this.blocksWritten.incr();
    }

    public void incrBlocksRemoved(int delta) {
        this.blocksRemoved.incr((long)delta);
    }

    public void incrBytesWritten(int delta) {
        this.bytesWritten.incr((long)delta);
    }

    public void incrBlockVerificationFailures() {
        this.blockVerificationFailures.incr();
    }

    public void incrBlocksVerified() {
        this.blocksVerified.incr();
    }

    public void addReadBlockOp(long latency) {
        this.readBlockOp.add(latency);
    }

    public void addWriteBlockOp(long latency) {
        this.writeBlockOp.add(latency);
    }

    public void addReplaceBlockOp(long latency) {
        this.replaceBlockOp.add(latency);
    }

    public void addCopyBlockOp(long latency) {
        this.copyBlockOp.add(latency);
    }

    public void addBlockChecksumOp(long latency) {
        this.blockChecksumOp.add(latency);
    }

    public void incrBytesRead(int delta) {
        this.bytesRead.incr((long)delta);
    }

    public void incrBlocksRead() {
        this.blocksRead.incr();
    }

    public void shutdown() {
        DefaultMetricsSystem.shutdown();
    }

    public void incrWritesFromClient(boolean local) {
        (local ? this.writesFromLocalClient : this.writesFromRemoteClient).incr();
    }

    public void incrReadsFromClient(boolean local) {
        (local ? this.readsFromLocalClient : this.readsFromRemoteClient).incr();
    }

    public void incrVolumeFailures() {
        this.volumeFailures.incr();
    }
}

