/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.BackupImage;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.Checkpointer;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.JournalProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class BackupNode
extends NameNode {
    private static final String BN_ADDRESS_NAME_KEY = "dfs.namenode.backup.address";
    private static final String BN_ADDRESS_DEFAULT = "localhost:50100";
    private static final String BN_HTTP_ADDRESS_NAME_KEY = "dfs.namenode.backup.http-address";
    private static final String BN_HTTP_ADDRESS_DEFAULT = "0.0.0.0:50105";
    private static final String BN_SERVICE_RPC_ADDRESS_KEY = "dfs.namenode.backup.dnrpc-address";
    NamenodeProtocol namenode;
    String nnRpcAddress;
    String nnHttpAddress;
    Checkpointer checkpointManager;
    String clusterId;
    String blockPoolId;

    BackupNode(Configuration conf, HdfsServerConstants.NamenodeRole role) throws IOException {
        super(conf, role);
    }

    @Override
    protected InetSocketAddress getRpcServerAddress(Configuration conf) throws IOException {
        String addr = conf.get(BN_ADDRESS_NAME_KEY, BN_ADDRESS_DEFAULT);
        return NetUtils.createSocketAddr((String)addr);
    }

    @Override
    protected InetSocketAddress getServiceRpcServerAddress(Configuration conf) throws IOException {
        String addr = conf.get(BN_SERVICE_RPC_ADDRESS_KEY);
        if (addr == null || addr.isEmpty()) {
            return null;
        }
        return NetUtils.createSocketAddr((String)addr);
    }

    @Override
    protected void setRpcServerAddress(Configuration conf, InetSocketAddress addr) {
        conf.set(BN_ADDRESS_NAME_KEY, BackupNode.getHostPortString(addr));
    }

    @Override
    protected void setRpcServiceServerAddress(Configuration conf, InetSocketAddress addr) {
        conf.set(BN_SERVICE_RPC_ADDRESS_KEY, BackupNode.getHostPortString(addr));
    }

    @Override
    protected InetSocketAddress getHttpServerAddress(Configuration conf) {
        assert (this.getNameNodeAddress() != null) : "rpcAddress should be calculated first";
        String addr = conf.get(BN_HTTP_ADDRESS_NAME_KEY, BN_HTTP_ADDRESS_DEFAULT);
        return NetUtils.createSocketAddr((String)addr);
    }

    @Override
    protected void setHttpServerAddress(Configuration conf) {
        conf.set(BN_HTTP_ADDRESS_NAME_KEY, BackupNode.getHostPortString(this.getHttpAddress()));
    }

    @Override
    protected void loadNamesystem(Configuration conf) throws IOException {
        BackupImage bnImage = new BackupImage(conf);
        this.namesystem = new FSNamesystem(conf, bnImage);
        bnImage.recoverCreateRead();
    }

    @Override
    protected void initialize(Configuration conf) throws IOException {
        conf.setLong("fs.trash.interval", 0L);
        NamespaceInfo nsInfo = this.handshake(conf);
        super.initialize(conf);
        this.namesystem.leaseManager.setLeasePeriod(60000L, Long.MAX_VALUE);
        this.clusterId = nsInfo.getClusterID();
        this.blockPoolId = nsInfo.getBlockPoolID();
        this.registerWith(nsInfo);
        this.runCheckpointDaemon(conf);
    }

    @Override
    protected NameNodeRpcServer createRpcServer(Configuration conf) throws IOException {
        return new BackupNodeRpcServer(conf, this);
    }

    @Override
    public void stop() {
        if (this.checkpointManager != null) {
            this.checkpointManager.shouldRun = false;
        }
        if (this.namenode != null && this.getRegistration() != null) {
            try {
                this.namenode.errorReport(this.getRegistration(), 1, "Shutting down.");
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to report to name-node.", (Throwable)e);
            }
        }
        RPC.stopProxy((Object)this.namenode);
        this.namenode = null;
        if (this.checkpointManager != null) {
            this.checkpointManager.interrupt();
            this.checkpointManager = null;
        }
        super.stop();
    }

    boolean shouldCheckpointAtStartup() {
        FSImage fsImage = this.getFSImage();
        if (this.isRole(HdfsServerConstants.NamenodeRole.CHECKPOINT)) {
            assert (fsImage.getStorage().getNumStorageDirs() > 0);
            return !fsImage.getStorage().getStorageDir(0).getVersionFile().exists();
        }
        return true;
    }

    private NamespaceInfo handshake(Configuration conf) throws IOException {
        InetSocketAddress nnAddress = NameNode.getServiceAddress(conf, true);
        this.namenode = (NamenodeProtocol)RPC.waitForProxy(NamenodeProtocol.class, (long)6L, (InetSocketAddress)nnAddress, (Configuration)conf);
        this.nnRpcAddress = BackupNode.getHostPortString(nnAddress);
        this.nnHttpAddress = BackupNode.getHostPortString(super.getHttpServerAddress(conf));
        NamespaceInfo nsInfo = null;
        while (!this.isStopRequested()) {
            try {
                nsInfo = BackupNode.handshake(this.namenode);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + nnAddress));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        return nsInfo;
    }

    private void runCheckpointDaemon(Configuration conf) throws IOException {
        this.checkpointManager = new Checkpointer(conf, this);
        this.checkpointManager.start();
    }

    void doCheckpoint() throws IOException {
        this.checkpointManager.doCheckpoint();
    }

    private void registerWith(NamespaceInfo nsInfo) throws IOException {
        BackupImage bnImage = (BackupImage)this.getFSImage();
        NNStorage storage = bnImage.getStorage();
        if (storage.getNamespaceID() == 0) {
            storage.setStorageInfo(nsInfo);
            storage.setBlockPoolID(nsInfo.getBlockPoolID());
            storage.setClusterID(nsInfo.getClusterID());
        } else {
            nsInfo.validateStorage(storage);
        }
        this.setRegistration();
        NamenodeRegistration nnReg = null;
        while (!this.isStopRequested()) {
            try {
                nnReg = this.namenode.register(this.getRegistration());
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to name-node: " + this.nnRpcAddress));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        String msg = null;
        if (nnReg == null) {
            msg = "Registration rejected by " + this.nnRpcAddress;
        } else if (!nnReg.isRole(HdfsServerConstants.NamenodeRole.NAMENODE)) {
            msg = "Name-node " + this.nnRpcAddress + " is not active";
        }
        if (msg != null) {
            msg = msg + ". Shutting down.";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        this.nnRpcAddress = nnReg.getAddress();
    }

    private static NamespaceInfo handshake(NamenodeProtocol namenode) throws IOException, SocketTimeoutException {
        NamespaceInfo nsInfo = namenode.versionRequest();
        String errorMsg = null;
        if (!nsInfo.getBuildVersion().equals(Storage.getBuildVersion())) {
            errorMsg = "Incompatible build versions: active name-node BV = " + nsInfo.getBuildVersion() + "; backup node BV = " + Storage.getBuildVersion();
            LOG.fatal((Object)errorMsg);
            throw new IOException(errorMsg);
        }
        assert (HdfsConstants.LAYOUT_VERSION == nsInfo.getLayoutVersion()) : "Active and backup node layout versions must be the same. Expected: " + HdfsConstants.LAYOUT_VERSION + " actual " + nsInfo.getLayoutVersion();
        return nsInfo;
    }

    String getBlockPoolId() {
        return this.blockPoolId;
    }

    String getClusterId() {
        return this.clusterId;
    }

    @Override
    protected String getNameServiceId(Configuration conf) {
        return DFSUtil.getBackupNameServiceId(conf);
    }

    static class BackupNodeRpcServer
    extends NameNodeRpcServer
    implements JournalProtocol {
        private final String nnRpcAddress;

        private BackupNodeRpcServer(Configuration conf, BackupNode nn) throws IOException {
            super(conf, nn);
            this.nnRpcAddress = nn.nnRpcAddress;
        }

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            if (protocol.equals(JournalProtocol.class.getName())) {
                return 1L;
            }
            return super.getProtocolVersion(protocol, clientVersion);
        }

        @Override
        public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
            throw new UnsupportedActionException("getBlocks");
        }

        @Override
        public NamenodeRegistration register(NamenodeRegistration registration) throws IOException {
            throw new UnsupportedActionException("register");
        }

        @Override
        public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
            throw new UnsupportedActionException("startCheckpoint");
        }

        @Override
        public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
            throw new UnsupportedActionException("endCheckpoint");
        }

        @Override
        public void journal(NamenodeRegistration nnReg, long firstTxId, int numTxns, byte[] records) throws IOException {
            this.verifyRequest(nnReg);
            if (!this.nnRpcAddress.equals(nnReg.getAddress())) {
                throw new IOException("Journal request from unexpected name-node: " + nnReg.getAddress() + " expecting " + this.rpcAddress);
            }
            this.getBNImage().journal(firstTxId, numTxns, records);
        }

        @Override
        public void startLogSegment(NamenodeRegistration registration, long txid) throws IOException {
            this.verifyRequest(registration);
            this.getBNImage().namenodeStartedLogSegment(txid);
        }

        private BackupImage getBNImage() {
            return (BackupImage)this.nn.getFSImage();
        }
    }
}

