/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.CancelDelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryServlet;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FileChecksumServlets;
import org.apache.hadoop.hdfs.server.namenode.FileDataServlet;
import org.apache.hadoop.hdfs.server.namenode.FsckServlet;
import org.apache.hadoop.hdfs.server.namenode.GetDelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.ListPathsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.RenewDelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.AuthFilter;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.mortbay.jetty.servlet.Context;

@InterfaceAudience.Private
public class NameNodeHttpServer {
    private HttpServer httpServer;
    private final Configuration conf;
    private final NameNode nn;
    private final Log LOG = NameNode.LOG;
    private InetSocketAddress httpAddress;
    private InetSocketAddress bindAddress;
    public static final String NAMENODE_ADDRESS_ATTRIBUTE_KEY = "name.node.address";
    public static final String FSIMAGE_ATTRIBUTE_KEY = "name.system.image";
    protected static final String NAMENODE_ATTRIBUTE_KEY = "name.node";

    public NameNodeHttpServer(Configuration conf, NameNode nn, InetSocketAddress bindAddress) {
        this.conf = conf;
        this.nn = nn;
        this.bindAddress = bindAddress;
    }

    private String getDefaultServerPrincipal() throws IOException {
        return SecurityUtil.getServerPrincipal((String)this.conf.get("dfs.namenode.kerberos.principal"), (String)this.nn.getNameNodeAddress().getHostName());
    }

    public void start() throws IOException {
        final String infoHost = this.bindAddress.getHostName();
        if (UserGroupInformation.isSecurityEnabled()) {
            String httpsUser = SecurityUtil.getServerPrincipal((String)this.conf.get("dfs.namenode.kerberos.https.principal"), (String)infoHost);
            if (httpsUser == null) {
                this.LOG.warn((Object)("dfs.namenode.kerberos.https.principal not defined in config. Starting http server as " + this.getDefaultServerPrincipal() + ": Kerberized SSL may be not function correctly."));
            } else {
                this.LOG.info((Object)("Logging in as " + httpsUser + " to start http server."));
                SecurityUtil.login((Configuration)this.conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.https.principal", (String)infoHost);
            }
        }
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        try {
            this.httpServer = (HttpServer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<HttpServer>(){

                @Override
                public HttpServer run() throws IOException, InterruptedException {
                    int infoPort;
                    NameNodeHttpServer.this.httpServer = new HttpServer("hdfs", infoHost, infoPort, (infoPort = NameNodeHttpServer.this.bindAddress.getPort()) == 0, NameNodeHttpServer.this.conf, new AccessControlList(NameNodeHttpServer.this.conf.get("dfs.cluster.administrators", " "))){
                        {
                            if (NameNodeHttpServer.this.conf.getBoolean("dfs.webhdfs.enabled", false)) {
                                String name = "SPNEGO";
                                String classname = AuthFilter.class.getName();
                                String pathSpec = "/webhdfs/v1/*";
                                Map<String, String> params = this.getAuthFilterParams(NameNodeHttpServer.this.conf);
                                this.defineFilter((Context)this.webAppContext, "SPNEGO", classname, params, new String[]{"/webhdfs/v1/*"});
                                LOG.info((Object)("Added filter 'SPNEGO' (class=" + classname + ")"));
                                this.addJerseyResourcePackage(NamenodeWebHdfsMethods.class.getPackage().getName() + ";" + Param.class.getPackage().getName(), "/webhdfs/v1/*");
                            }
                        }

                        private Map<String, String> getAuthFilterParams(Configuration conf) throws IOException {
                            String httpKeytab;
                            HashMap<String, String> params = new HashMap<String, String>();
                            String principalInConf = conf.get("dfs.web.authentication.kerberos.principal");
                            if (principalInConf != null && !principalInConf.isEmpty()) {
                                params.put("dfs.web.authentication.kerberos.principal", SecurityUtil.getServerPrincipal((String)principalInConf, (String)infoHost));
                            }
                            if ((httpKeytab = conf.get("dfs.web.authentication.kerberos.keytab")) != null && !httpKeytab.isEmpty()) {
                                params.put("dfs.web.authentication.kerberos.keytab", httpKeytab);
                            }
                            return params;
                        }
                    };
                    boolean certSSL = NameNodeHttpServer.this.conf.getBoolean("dfs.https.enable", false);
                    boolean useKrb = UserGroupInformation.isSecurityEnabled();
                    if (certSSL || useKrb) {
                        boolean needClientAuth = NameNodeHttpServer.this.conf.getBoolean("dfs.client.https.need-auth", false);
                        InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr((String)NameNodeHttpServer.this.conf.get("dfs.namenode.https-address", "0.0.0.0:50470"));
                        HdfsConfiguration sslConf = new HdfsConfiguration(false);
                        if (certSSL) {
                            sslConf.addResource(NameNodeHttpServer.this.conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
                        }
                        NameNodeHttpServer.this.httpServer.addSslListener(secInfoSocAddr, (Configuration)sslConf, needClientAuth, useKrb);
                        InetSocketAddress datanodeSslPort = NetUtils.createSocketAddr((String)NameNodeHttpServer.this.conf.get("dfs.datanode.https.address", infoHost + ":" + 50475));
                        NameNodeHttpServer.this.httpServer.setAttribute("datanode.https.port", (Object)datanodeSslPort.getPort());
                    }
                    NameNodeHttpServer.this.httpServer.setAttribute(NameNodeHttpServer.NAMENODE_ATTRIBUTE_KEY, (Object)NameNodeHttpServer.this.nn);
                    NameNodeHttpServer.this.httpServer.setAttribute(NameNodeHttpServer.NAMENODE_ADDRESS_ATTRIBUTE_KEY, (Object)NameNodeHttpServer.this.nn.getNameNodeAddress());
                    NameNodeHttpServer.this.httpServer.setAttribute(NameNodeHttpServer.FSIMAGE_ATTRIBUTE_KEY, (Object)NameNodeHttpServer.this.nn.getFSImage());
                    NameNodeHttpServer.this.httpServer.setAttribute("current.conf", (Object)NameNodeHttpServer.this.conf);
                    NameNodeHttpServer.setupServlets(NameNodeHttpServer.this.httpServer, NameNodeHttpServer.this.conf);
                    NameNodeHttpServer.this.httpServer.start();
                    infoPort = NameNodeHttpServer.this.httpServer.getPort();
                    NameNodeHttpServer.this.httpAddress = new InetSocketAddress(infoHost, infoPort);
                    NameNodeHttpServer.this.LOG.info((Object)((Object)((Object)NameNodeHttpServer.this.nn.getRole()) + " Web-server up at: " + NameNodeHttpServer.this.httpAddress));
                    return NameNodeHttpServer.this.httpServer;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            if (UserGroupInformation.isSecurityEnabled() && this.conf.get("dfs.namenode.kerberos.https.principal") != null) {
                this.LOG.info((Object)"Logging back in as NameNode user following http server start");
                this.nn.loginAsNameNodeUser(this.conf);
            }
        }
    }

    public void stop() throws Exception {
        this.httpServer.stop();
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    private static void setupServlets(HttpServer httpServer, Configuration conf) {
        httpServer.addInternalServlet("getDelegationToken", "/getDelegationToken", GetDelegationTokenServlet.class, true);
        httpServer.addInternalServlet("renewDelegationToken", "/renewDelegationToken", RenewDelegationTokenServlet.class, true);
        httpServer.addInternalServlet("cancelDelegationToken", "/cancelDelegationToken", CancelDelegationTokenServlet.class, true);
        httpServer.addInternalServlet("fsck", "/fsck", FsckServlet.class, true);
        httpServer.addInternalServlet("getimage", "/getimage", GetImageServlet.class, true);
        httpServer.addInternalServlet("listPaths", "/listPaths/*", ListPathsServlet.class, false);
        httpServer.addInternalServlet("data", "/data/*", FileDataServlet.class, false);
        httpServer.addInternalServlet("checksum", "/fileChecksum/*", FileChecksumServlets.RedirectServlet.class, false);
        httpServer.addInternalServlet("contentSummary", "/contentSummary/*", ContentSummaryServlet.class, false);
    }

    public static FSImage getFsImageFromContext(ServletContext context) {
        return (FSImage)context.getAttribute(FSIMAGE_ATTRIBUTE_KEY);
    }

    public static NameNode getNameNodeFromContext(ServletContext context) {
        return (NameNode)context.getAttribute(NAMENODE_ATTRIBUTE_KEY);
    }

    public static Configuration getConfFromContext(ServletContext context) {
        return (Configuration)context.getAttribute("current.conf");
    }

    public static InetSocketAddress getNameNodeAddressFromContext(ServletContext context) {
        return (InetSocketAddress)context.getAttribute(NAMENODE_ADDRESS_ATTRIBUTE_KEY);
    }
}

