/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;

class TransferFsImage {
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String MD5_HEADER = "X-MD5-Digest";
    private static final Log LOG = LogFactory.getLog(TransferFsImage.class);

    TransferFsImage() {
    }

    static MD5Hash downloadImageToStorage(String fsName, long imageTxId, NNStorage dstStorage, boolean needDigest) throws IOException {
        String fileid = GetImageServlet.getParamStringForImage(imageTxId, dstStorage);
        String fileName = NNStorage.getCheckpointImageFileName(imageTxId);
        List<File> dstFiles = dstStorage.getFiles(NNStorage.NameNodeDirType.IMAGE, fileName);
        if (dstFiles.isEmpty()) {
            throw new IOException("No targets in destination storage!");
        }
        MD5Hash hash = TransferFsImage.getFileClient(fsName, fileid, dstFiles, dstStorage, needDigest);
        LOG.info((Object)("Downloaded file " + dstFiles.get(0).getName() + " size " + dstFiles.get(0).length() + " bytes."));
        return hash;
    }

    static void downloadEditsToStorage(String fsName, RemoteEditLog log, NNStorage dstStorage) throws IOException {
        assert (log.getStartTxId() > 0L && log.getEndTxId() > 0L) : "bad log: " + log;
        String fileid = GetImageServlet.getParamStringForLog(log, dstStorage);
        String fileName = NNStorage.getFinalizedEditsFileName(log.getStartTxId(), log.getEndTxId());
        List<File> dstFiles = dstStorage.getFiles(NNStorage.NameNodeDirType.EDITS, fileName);
        assert (!dstFiles.isEmpty()) : "No checkpoint targets.";
        for (File f : dstFiles) {
            if (f.exists() && f.canRead()) {
                LOG.info((Object)("Skipping download of remote edit log " + log + " since it already is stored locally at " + f));
                return;
            }
            LOG.debug((Object)("Dest file: " + f));
        }
        TransferFsImage.getFileClient(fsName, fileid, dstFiles, dstStorage, false);
        LOG.info((Object)("Downloaded file " + dstFiles.get(0).getName() + " size " + dstFiles.get(0).length() + " bytes."));
    }

    static void uploadImageFromStorage(String fsName, InetSocketAddress imageListenAddress, NNStorage storage, long txid) throws IOException {
        String fileid = GetImageServlet.getParamStringToPutImage(txid, imageListenAddress, storage);
        TransferFsImage.getFileClient(fsName, fileid, null, null, false);
        LOG.info((Object)("Uploaded image with txid " + txid + " to namenode at " + fsName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getFileServer(OutputStream outstream, File localfile, DataTransferThrottler throttler) throws IOException {
        byte[] buf = new byte[HdfsConstants.IO_FILE_BUFFER_SIZE];
        FileInputStream infile = null;
        try {
            infile = new FileInputStream(localfile);
            if (DFSUtil.ErrorSimulator.getErrorSimulation(2) && localfile.getAbsolutePath().contains("secondary")) {
                throw new IOException("If this exception is not caught by the name-node fs image will be truncated.");
            }
            if (DFSUtil.ErrorSimulator.getErrorSimulation(3) && localfile.getAbsolutePath().contains("fsimage")) {
                long len = localfile.length();
                buf = new byte[(int)Math.min(len / 2L, (long)HdfsConstants.IO_FILE_BUFFER_SIZE)];
                infile.read(buf);
            }
            int num = 1;
            while (num > 0) {
                num = infile.read(buf);
                if (num <= 0) {
                    break;
                }
                if (DFSUtil.ErrorSimulator.getErrorSimulation(4)) {
                    LOG.warn((Object)"SIMULATING A CORRUPT BYTE IN IMAGE TRANSFER!");
                    buf[0] = (byte)(buf[0] + 1);
                }
                outstream.write(buf, 0, num);
                if (throttler == null) continue;
                throttler.throttle(num);
            }
        }
        finally {
            if (infile != null) {
                infile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MD5Hash getFileClient(String nnHostPort, String queryString, List<File> localPaths, NNStorage dstStorage, boolean getChecksum) throws IOException {
        byte[] buf = new byte[HdfsConstants.IO_FILE_BUFFER_SIZE];
        String proto = UserGroupInformation.isSecurityEnabled() ? "https://" : "http://";
        StringBuilder str = new StringBuilder(proto + nnHostPort + "/getimage?");
        str.append(queryString);
        URL url = new URL(str.toString());
        SecurityUtil.fetchServiceTicket((URL)url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection.getResponseCode() != 200) {
            throw new IOException("Image transfer servlet at " + url + " failed with status code " + connection.getResponseCode() + "\nResponse message:\n" + connection.getResponseMessage());
        }
        String contentLength = connection.getHeaderField(CONTENT_LENGTH);
        if (contentLength == null) {
            throw new IOException("Content-Length header is not provided by the namenode when trying to fetch " + str);
        }
        long advertisedSize = Long.parseLong(contentLength);
        MD5Hash advertisedDigest = TransferFsImage.parseMD5Header(connection);
        long received = 0L;
        InputStream stream = connection.getInputStream();
        MessageDigest digester = null;
        if (getChecksum) {
            digester = MD5Hash.getDigester();
            stream = new DigestInputStream(stream, digester);
        }
        boolean finishedReceiving = false;
        ArrayList outputStreams = Lists.newArrayList();
        try {
            if (localPaths != null) {
                for (File f : localPaths) {
                    try {
                        if (f.exists()) {
                            LOG.warn((Object)("Overwriting existing file " + f + " with file downloaded from " + str));
                        }
                        outputStreams.add(new FileOutputStream(f));
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Unable to download file " + f), (Throwable)ioe);
                        dstStorage.reportErrorOnFile(f);
                    }
                }
                if (outputStreams.isEmpty()) {
                    throw new IOException("Unable to download to any storage directory");
                }
            }
            int num = 1;
            while (num > 0) {
                num = stream.read(buf);
                if (num <= 0) continue;
                received += (long)num;
                for (FileOutputStream fos : outputStreams) {
                    fos.write(buf, 0, num);
                }
            }
            finishedReceiving = true;
        }
        finally {
            stream.close();
            for (FileOutputStream fos : outputStreams) {
                fos.getChannel().force(true);
                fos.close();
            }
            if (finishedReceiving && received != advertisedSize) {
                throw new IOException("File " + str + " received length " + received + " is not of the advertised size " + advertisedSize);
            }
        }
        if (digester != null) {
            MD5Hash computedDigest = new MD5Hash(digester.digest());
            if (advertisedDigest != null && !computedDigest.equals((Object)advertisedDigest)) {
                throw new IOException("File " + str + " computed digest " + computedDigest + " does not match advertised digest " + advertisedDigest);
            }
            return computedDigest;
        }
        return null;
    }

    private static MD5Hash parseMD5Header(HttpURLConnection connection) {
        String header = connection.getHeaderField(MD5_HEADER);
        return header != null ? new MD5Hash(header) : null;
    }
}

