/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.BinaryEditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.StatisticsEditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.Tokenizer;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.XmlEditsVisitor;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class EditsVisitorFactory {
    public static EditsVisitor getEditsVisitor(String filename, String processor, Tokenizer tokenizer, boolean printToScreen) throws IOException {
        if (processor.toLowerCase().equals("xml")) {
            return new XmlEditsVisitor(filename, tokenizer, printToScreen);
        }
        if (processor.toLowerCase().equals("stats")) {
            return new StatisticsEditsVisitor(filename, tokenizer, printToScreen);
        }
        if (processor.toLowerCase().equals("binary")) {
            return new BinaryEditsVisitor(filename, tokenizer, printToScreen);
        }
        throw new IOException("Unknown proccesor " + processor + " (valid processors: xml, binary, stats)");
    }
}

