/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsLoader;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsVisitorFactory;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.TokenizerFactory;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OfflineEditsViewer
extends Configured
implements Tool {
    private EditsLoader editsLoader;
    private static final String defaultProcessor = "xml";

    private void setEditsLoader(EditsLoader editsLoader) {
        this.editsLoader = editsLoader;
    }

    public void go(EditsVisitor visitor) throws IOException {
        this.setEditsLoader(EditsLoader.LoaderFactory.getLoader(visitor));
        this.editsLoader.loadEdits();
    }

    private void printHelp() {
        String summary = "Usage: bin/hdfs oev [OPTIONS] -i INPUT_FILE -o OUTPUT_FILE\nOffline edits viewer\nParse a Hadoop edits log file INPUT_FILE and save results\nin OUTPUT_FILE.\nRequired command line arguments:\n-i,--inputFile <arg>   edits file to process, xml (case\n                       insensitive) extension means XML format,\n                       any other filename means binary format\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten,\n                       format of the file is determined\n                       by -p option\n\nOptional command line arguments:\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file, currently supported\n                       processors are: binary (native binary format\n                       that Hadoop uses), xml (default, XML\n                       format), stats (prints statistics about\n                       edits file)\n-h,--help              Display usage information and exit\n-v,--verbose           More verbose output, prints the input and\n                       output filenames, for processors that write\n                       to a file, also output to screen. On large\n                       image files this will dramatically increase\n                       processing time (default is false).\n";
        System.out.println(summary);
        System.out.println();
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    public static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"outputFilename");
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"inputFilename");
        options.addOption(OptionBuilder.create((String)"i"));
        options.addOption("p", "processor", true, "");
        options.addOption("v", "verbose", false, "");
        options.addOption("h", "help", false, "");
        return options;
    }

    public int run(String[] argv) throws Exception {
        CommandLine cmd;
        int exitCode = 0;
        Options options = OfflineEditsViewer.buildOptions();
        if (argv.length == 0) {
            this.printHelp();
            return -1;
        }
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, argv);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: " + e.getMessage());
            this.printHelp();
            return -1;
        }
        if (cmd.hasOption("h")) {
            this.printHelp();
            return -1;
        }
        boolean printToScreen = false;
        String inputFilenameArg = cmd.getOptionValue("i");
        String outputFilenameArg = cmd.getOptionValue("o");
        String processor = cmd.getOptionValue("p");
        if (processor == null) {
            processor = defaultProcessor;
        }
        if (cmd.hasOption("v")) {
            printToScreen = true;
            System.out.println("input  [" + inputFilenameArg + "]");
            System.out.println("output [" + outputFilenameArg + "]");
        }
        try {
            this.go(EditsVisitorFactory.getEditsVisitor(outputFilenameArg, processor, TokenizerFactory.getTokenizer(inputFilenameArg), printToScreen));
        }
        catch (EOFException e) {
            System.err.println("Input file ended unexpectedly. Exiting");
        }
        catch (IOException e) {
            System.err.println("Encountered exception. Exiting: " + e.getMessage());
        }
        return exitCode;
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new OfflineEditsViewer(), (String[])argv);
        System.exit(res);
    }
}

