/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockRecoveryCommand
extends DatanodeCommand {
    Collection<RecoveringBlock> recoveringBlocks;

    public BlockRecoveryCommand() {
        this(0);
    }

    public BlockRecoveryCommand(int capacity) {
        super(6);
        this.recoveringBlocks = new ArrayList<RecoveringBlock>(capacity);
    }

    public Collection<RecoveringBlock> getRecoveringBlocks() {
        return this.recoveringBlocks;
    }

    public void add(RecoveringBlock block) {
        this.recoveringBlocks.add(block);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.recoveringBlocks.size());
        for (RecoveringBlock block : this.recoveringBlocks) {
            block.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int numBlocks = in.readInt();
        this.recoveringBlocks = new ArrayList<RecoveringBlock>(numBlocks);
        for (int i = 0; i < numBlocks; ++i) {
            RecoveringBlock b = new RecoveringBlock();
            b.readFields(in);
            this.add(b);
        }
    }

    static {
        WritableFactories.setFactory(BlockRecoveryCommand.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new BlockRecoveryCommand();
            }
        });
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class RecoveringBlock
    extends LocatedBlock {
        private long newGenerationStamp;

        public RecoveringBlock() {
            this.newGenerationStamp = -1L;
        }

        public RecoveringBlock(ExtendedBlock b, DatanodeInfo[] locs, long newGS) {
            super(b, locs, -1L, false);
            this.newGenerationStamp = newGS;
        }

        public long getNewGenerationStamp() {
            return this.newGenerationStamp;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            super.write(out);
            out.writeLong(this.newGenerationStamp);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.newGenerationStamp = in.readLong();
        }

        static {
            WritableFactories.setFactory(RecoveringBlock.class, (WritableFactory)new WritableFactory(){

                public Writable newInstance() {
                    return new RecoveringBlock();
                }
            });
        }
    }
}

