/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeInfo
extends DatanodeID
implements Node {
    protected long capacity;
    protected long dfsUsed;
    protected long remaining;
    protected long blockPoolUsed;
    protected long lastUpdate;
    protected int xceiverCount;
    protected String location = "/default-rack";
    protected String hostName = null;
    protected AdminStates adminState;
    private transient int level;
    private transient Node parent;

    public DatanodeInfo() {
        this.adminState = null;
    }

    public DatanodeInfo(DatanodeInfo from) {
        super(from);
        this.capacity = from.getCapacity();
        this.dfsUsed = from.getDfsUsed();
        this.remaining = from.getRemaining();
        this.blockPoolUsed = from.getBlockPoolUsed();
        this.lastUpdate = from.getLastUpdate();
        this.xceiverCount = from.getXceiverCount();
        this.location = from.getNetworkLocation();
        this.adminState = from.adminState;
        this.hostName = from.hostName;
    }

    public DatanodeInfo(DatanodeID nodeID) {
        super(nodeID);
        this.capacity = 0L;
        this.dfsUsed = 0L;
        this.remaining = 0L;
        this.blockPoolUsed = 0L;
        this.lastUpdate = 0L;
        this.xceiverCount = 0;
        this.adminState = null;
    }

    public DatanodeInfo(DatanodeID nodeID, String location, String hostName) {
        this(nodeID);
        this.location = location;
        this.hostName = hostName;
    }

    public DatanodeInfo(DatanodeID nodeID, String location, String hostName, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long lastUpdate, int xceiverCount, AdminStates adminState) {
        this(nodeID.getName(), nodeID.getStorageID(), nodeID.getInfoPort(), nodeID.getIpcPort(), capacity, dfsUsed, remaining, blockPoolUsed, lastUpdate, xceiverCount, location, hostName, adminState);
    }

    public DatanodeInfo(String name, String storageID, int infoPort, int ipcPort, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long lastUpdate, int xceiverCount, String networkLocation, String hostName, AdminStates adminState) {
        super(name, storageID, infoPort, ipcPort);
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
        this.blockPoolUsed = blockPoolUsed;
        this.lastUpdate = lastUpdate;
        this.xceiverCount = xceiverCount;
        this.location = networkLocation;
        this.hostName = hostName;
        this.adminState = adminState;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getDfsUsed() {
        return this.dfsUsed;
    }

    public long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    public long getNonDfsUsed() {
        long nonDFSUsed = this.capacity - this.dfsUsed - this.remaining;
        return nonDFSUsed < 0L ? 0L : nonDFSUsed;
    }

    public float getDfsUsedPercent() {
        return DFSUtil.getPercentUsed(this.dfsUsed, this.capacity);
    }

    public long getRemaining() {
        return this.remaining;
    }

    public float getBlockPoolUsedPercent() {
        return DFSUtil.getPercentUsed(this.blockPoolUsed, this.capacity);
    }

    public float getRemainingPercent() {
        return DFSUtil.getPercentRemaining(this.remaining, this.capacity);
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public int getXceiverCount() {
        return this.xceiverCount;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public void setDfsUsed(long dfsUsed) {
        this.dfsUsed = dfsUsed;
    }

    public void setRemaining(long remaining) {
        this.remaining = remaining;
    }

    public void setBlockPoolUsed(long bpUsed) {
        this.blockPoolUsed = bpUsed;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setXceiverCount(int xceiverCount) {
        this.xceiverCount = xceiverCount;
    }

    public synchronized String getNetworkLocation() {
        return this.location;
    }

    public synchronized void setNetworkLocation(String location) {
        this.location = NodeBase.normalize((String)location);
    }

    public String getHostName() {
        return this.hostName == null || this.hostName.length() == 0 ? this.getHost() : this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public String getDatanodeReport() {
        StringBuilder buffer = new StringBuilder();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = this.getDfsUsed();
        long nonDFSUsed = this.getNonDfsUsed();
        float usedPercent = this.getDfsUsedPercent();
        float remainingPercent = this.getRemainingPercent();
        String hostName = NetUtils.getHostNameOfIP((String)this.name);
        buffer.append("Name: " + this.name);
        if (hostName != null) {
            buffer.append(" (" + hostName + ")");
        }
        buffer.append("\n");
        if (!"/default-rack".equals(this.location)) {
            buffer.append("Rack: " + this.location + "\n");
        }
        buffer.append("Decommission Status : ");
        if (this.isDecommissioned()) {
            buffer.append("Decommissioned\n");
        } else if (this.isDecommissionInProgress()) {
            buffer.append("Decommission in progress\n");
        } else {
            buffer.append("Normal\n");
        }
        buffer.append("Configured Capacity: " + c + " (" + StringUtils.byteDesc((long)c) + ")" + "\n");
        buffer.append("DFS Used: " + u + " (" + StringUtils.byteDesc((long)u) + ")" + "\n");
        buffer.append("Non DFS Used: " + nonDFSUsed + " (" + StringUtils.byteDesc((long)nonDFSUsed) + ")" + "\n");
        buffer.append("DFS Remaining: " + r + " (" + StringUtils.byteDesc((long)r) + ")" + "\n");
        buffer.append("DFS Used%: " + StringUtils.limitDecimalTo2((double)usedPercent) + "%\n");
        buffer.append("DFS Remaining%: " + StringUtils.limitDecimalTo2((double)remainingPercent) + "%\n");
        buffer.append("Last contact: " + new Date(this.lastUpdate) + "\n");
        return buffer.toString();
    }

    public String dumpDatanode() {
        StringBuilder buffer = new StringBuilder();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = this.getDfsUsed();
        buffer.append(this.name);
        if (!"/default-rack".equals(this.location)) {
            buffer.append(" " + this.location);
        }
        if (this.isDecommissioned()) {
            buffer.append(" DD");
        } else if (this.isDecommissionInProgress()) {
            buffer.append(" DP");
        } else {
            buffer.append(" IN");
        }
        buffer.append(" " + c + "(" + StringUtils.byteDesc((long)c) + ")");
        buffer.append(" " + u + "(" + StringUtils.byteDesc((long)u) + ")");
        buffer.append(" " + StringUtils.limitDecimalTo2((double)(1.0 * (double)u / (double)c * 100.0)) + "%");
        buffer.append(" " + r + "(" + StringUtils.byteDesc((long)r) + ")");
        buffer.append(" " + new Date(this.lastUpdate));
        return buffer.toString();
    }

    public void startDecommission() {
        this.adminState = AdminStates.DECOMMISSION_INPROGRESS;
    }

    public void stopDecommission() {
        this.adminState = null;
    }

    public boolean isDecommissionInProgress() {
        return this.adminState == AdminStates.DECOMMISSION_INPROGRESS;
    }

    public boolean isDecommissioned() {
        return this.adminState == AdminStates.DECOMMISSIONED;
    }

    public void setDecommissioned() {
        this.adminState = AdminStates.DECOMMISSIONED;
    }

    public AdminStates getAdminState() {
        if (this.adminState == null) {
            return AdminStates.NORMAL;
        }
        return this.adminState;
    }

    protected void setAdminState(AdminStates newState) {
        this.adminState = newState == AdminStates.NORMAL ? null : newState;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.ipcPort);
        out.writeLong(this.capacity);
        out.writeLong(this.dfsUsed);
        out.writeLong(this.remaining);
        out.writeLong(this.blockPoolUsed);
        out.writeLong(this.lastUpdate);
        out.writeInt(this.xceiverCount);
        Text.writeString((DataOutput)out, (String)this.location);
        Text.writeString((DataOutput)out, (String)(this.hostName == null ? "" : this.hostName));
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.getAdminState());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.ipcPort = in.readShort() & 0xFFFF;
        this.capacity = in.readLong();
        this.dfsUsed = in.readLong();
        this.remaining = in.readLong();
        this.blockPoolUsed = in.readLong();
        this.lastUpdate = in.readLong();
        this.xceiverCount = in.readInt();
        this.location = Text.readString((DataInput)in);
        this.hostName = Text.readString((DataInput)in);
        this.setAdminState((AdminStates)WritableUtils.readEnum((DataInput)in, AdminStates.class));
    }

    public static DatanodeInfo read(DataInput in) throws IOException {
        DatanodeInfo d = new DatanodeInfo();
        d.readFields(in);
        return d;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    static {
        WritableFactories.setFactory(DatanodeInfo.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new DatanodeInfo();
            }
        });
    }

    public static enum AdminStates {
        NORMAL("In Service"),
        DECOMMISSION_INPROGRESS("Decommission In Progress"),
        DECOMMISSIONED("Decommissioned");

        final String value;

        private AdminStates(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }

        public static AdminStates fromValue(String value) {
            for (AdminStates as : AdminStates.values()) {
                if (!as.value.equals(value)) continue;
                return as;
            }
            return NORMAL;
        }
    }
}

