/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolR23Compatible;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.ipc.ProtocolSignature;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProtocolSignatureWritable
implements Writable {
    private long version;
    private int[] methods = null;

    public static ProtocolSignature convert(ProtocolSignatureWritable ps) {
        if (ps == null) {
            return null;
        }
        return new ProtocolSignature(ps.getVersion(), ps.getMethods());
    }

    public static ProtocolSignatureWritable convert(ProtocolSignature ps) {
        if (ps == null) {
            return null;
        }
        return new ProtocolSignatureWritable(ps.getVersion(), ps.getMethods());
    }

    public ProtocolSignatureWritable() {
    }

    public ProtocolSignatureWritable(long version, int[] methodHashcodes) {
        this.version = version;
        this.methods = methodHashcodes;
    }

    public long getVersion() {
        return this.version;
    }

    public int[] getMethods() {
        return this.methods;
    }

    public void readFields(DataInput in) throws IOException {
        this.version = in.readLong();
        boolean hasMethods = in.readBoolean();
        if (hasMethods) {
            int numMethods = in.readInt();
            this.methods = new int[numMethods];
            for (int i = 0; i < numMethods; ++i) {
                this.methods[i] = in.readInt();
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.version);
        if (this.methods == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.methods.length);
            for (int method : this.methods) {
                out.writeInt(method);
            }
        }
    }

    static {
        WritableFactories.setFactory(ProtocolSignatureWritable.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new ProtocolSignatureWritable();
            }
        });
    }
}

