/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;

class FSDatasetAsyncDiskService {
    final FSDataset dataset;
    public static final Log LOG = LogFactory.getLog(FSDatasetAsyncDiskService.class);
    private static final int CORE_THREADS_PER_VOLUME = 1;
    private static final int MAXIMUM_THREADS_PER_VOLUME = 4;
    private static final long THREADS_KEEP_ALIVE_SECONDS = 60L;
    private final ThreadGroup threadGroup = new ThreadGroup("async disk service");
    private HashMap<File, ThreadPoolExecutor> executors = new HashMap();

    FSDatasetAsyncDiskService(FSDataset dataset, File[] volumes) {
        this.dataset = dataset;
        for (int v = 0; v < volumes.length; ++v) {
            final File vol = volumes[v];
            ThreadFactory threadFactory = new ThreadFactory(){
                int counter = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Thread newThread(Runnable r) {
                    int thisIndex;
                    1 var3_2 = this;
                    synchronized (var3_2) {
                        thisIndex = this.counter++;
                    }
                    Thread t = new Thread(FSDatasetAsyncDiskService.this.threadGroup, r);
                    t.setName("Async disk worker #" + thisIndex + " for volume " + vol);
                    return t;
                }
            };
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            executor.allowCoreThreadTimeOut(true);
            this.executors.put(vol, executor);
        }
    }

    synchronized long countPendingDeletions() {
        long count = 0L;
        for (ThreadPoolExecutor exec : this.executors.values()) {
            count += exec.getTaskCount() - exec.getCompletedTaskCount();
        }
        return count;
    }

    synchronized void execute(File root, Runnable task) {
        if (this.executors == null) {
            throw new RuntimeException("AsyncDiskService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(root);
        if (executor == null) {
            throw new RuntimeException("Cannot find root " + root + " for execution of task " + task);
        }
        executor.execute(task);
    }

    synchronized void shutdown() {
        if (this.executors == null) {
            LOG.warn((Object)"AsyncDiskService has already shut down.");
        } else {
            LOG.info((Object)"Shutting down all async disk service threads...");
            for (Map.Entry<File, ThreadPoolExecutor> e : this.executors.entrySet()) {
                e.getValue().shutdown();
            }
            this.executors = null;
            LOG.info((Object)"All async disk service threads have been shut down.");
        }
    }

    void deleteAsync(FSDataset.FSVolume volume, File blockFile, File metaFile, ExtendedBlock block) {
        DataNode.LOG.info((Object)("Scheduling block " + block.getLocalBlock().toString() + " file " + blockFile + " for deletion"));
        ReplicaFileDeleteTask deletionTask = new ReplicaFileDeleteTask(this.dataset, volume, blockFile, metaFile, block);
        this.execute(volume.getCurrentDir(), deletionTask);
    }

    static class ReplicaFileDeleteTask
    implements Runnable {
        final FSDataset dataset;
        final FSDataset.FSVolume volume;
        final File blockFile;
        final File metaFile;
        final ExtendedBlock block;

        ReplicaFileDeleteTask(FSDataset dataset, FSDataset.FSVolume volume, File blockFile, File metaFile, ExtendedBlock block) {
            this.dataset = dataset;
            this.volume = volume;
            this.blockFile = blockFile;
            this.metaFile = metaFile;
            this.block = block;
        }

        FSDataset.FSVolume getVolume() {
            return this.volume;
        }

        public String toString() {
            return "deletion of block " + this.block.getBlockPoolId() + " " + this.block.getLocalBlock().toString() + " with block file " + this.blockFile + " and meta file " + this.metaFile + " from volume " + this.volume;
        }

        @Override
        public void run() {
            long dfsBytes = this.blockFile.length() + this.metaFile.length();
            if (!this.blockFile.delete() || !this.metaFile.delete() && this.metaFile.exists()) {
                DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + this.block.getBlockPoolId() + " " + this.block.getLocalBlock().toString() + " at file " + this.blockFile + ". Ignored."));
            } else {
                if (this.block.getLocalBlock().getNumBytes() != Long.MAX_VALUE) {
                    this.dataset.notifyNamenodeDeletedBlock(this.block);
                }
                this.volume.decDfsUsed(this.block.getBlockPoolId(), dfsBytes);
                DataNode.LOG.info((Object)("Deleted block " + this.block.getBlockPoolId() + " " + this.block.getLocalBlock().toString() + " at file " + this.blockFile));
            }
        }
    }
}

