/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.UpgradeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.UpgradeObjectDatanode;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.util.Daemon;

class UpgradeManagerDatanode
extends UpgradeManager {
    DataNode dataNode = null;
    Daemon upgradeDaemon = null;
    String bpid = null;

    UpgradeManagerDatanode(DataNode dataNode, String bpid) {
        this.dataNode = dataNode;
        this.bpid = bpid;
    }

    @Override
    public HdfsServerConstants.NodeType getType() {
        return HdfsServerConstants.NodeType.DATA_NODE;
    }

    synchronized void initializeUpgrade(NamespaceInfo nsInfo) throws IOException {
        if (!super.initializeUpgrade()) {
            return;
        }
        DataNode.LOG.info((Object)("\n   Distributed upgrade for DataNode " + this.dataNode.getMachineName() + " version " + this.getUpgradeVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " is initialized."));
        UpgradeObjectDatanode curUO = (UpgradeObjectDatanode)this.currentUpgrades.first();
        curUO.setDatanode(this.dataNode, this.bpid);
        this.upgradeState = curUO.preUpgradeAction(nsInfo);
    }

    @Override
    public synchronized boolean startUpgrade() throws IOException {
        if (this.upgradeState) {
            assert (this.currentUpgrades != null) : "UpgradeManagerDatanode.currentUpgrades is null.";
            UpgradeObjectDatanode curUO = (UpgradeObjectDatanode)this.currentUpgrades.first();
            curUO.startUpgrade();
            return true;
        }
        if (this.broadcastCommand != null) {
            if (this.broadcastCommand.getVersion() > this.getUpgradeVersion()) {
                this.broadcastCommand = null;
            } else {
                assert (this.currentUpgrades == null) : "UpgradeManagerDatanode.currentUpgrades is not null.";
                assert (this.upgradeDaemon == null) : "UpgradeManagerDatanode.upgradeDaemon is not null.";
                DatanodeProtocolClientSideTranslatorPB nn = this.dataNode.getActiveNamenodeForBP(this.bpid);
                nn.processUpgradeCommand(this.broadcastCommand);
                return true;
            }
        }
        if (this.currentUpgrades == null) {
            this.currentUpgrades = this.getDistributedUpgrades();
        }
        if (this.currentUpgrades == null) {
            DataNode.LOG.info((Object)("\n   Distributed upgrade for DataNode version " + this.getUpgradeVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " cannot be started. " + "The upgrade object is not defined."));
            return false;
        }
        this.upgradeState = true;
        UpgradeObjectDatanode curUO = (UpgradeObjectDatanode)this.currentUpgrades.first();
        curUO.setDatanode(this.dataNode, this.bpid);
        curUO.startUpgrade();
        this.upgradeDaemon = new Daemon((Runnable)curUO);
        this.upgradeDaemon.start();
        DataNode.LOG.info((Object)("\n   Distributed upgrade for DataNode " + this.dataNode.getMachineName() + " version " + this.getUpgradeVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " is started."));
        return true;
    }

    synchronized void processUpgradeCommand(UpgradeCommand command) throws IOException {
        assert (command.getAction() == 101) : "Only start upgrade action can be processed at this time.";
        this.upgradeVersion = command.getVersion();
        if (this.startUpgrade()) {
            return;
        }
        throw new IOException("Distributed upgrade for DataNode " + this.dataNode.getMachineName() + " version " + this.getUpgradeVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " cannot be started. " + "The upgrade object is not defined.");
    }

    @Override
    public synchronized void completeUpgrade() throws IOException {
        assert (this.currentUpgrades != null) : "UpgradeManagerDatanode.currentUpgrades is null.";
        UpgradeObjectDatanode curUO = (UpgradeObjectDatanode)this.currentUpgrades.first();
        this.broadcastCommand = curUO.completeUpgrade();
        this.upgradeState = false;
        this.currentUpgrades = null;
        this.upgradeDaemon = null;
        DataNode.LOG.info((Object)("\n   Distributed upgrade for DataNode " + this.dataNode.getMachineName() + " version " + this.getUpgradeVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " is complete."));
    }

    synchronized void shutdownUpgrade() {
        if (this.upgradeDaemon != null) {
            this.upgradeDaemon.interrupt();
        }
    }
}

