/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.PureJavaCrc32;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class FSEditLogOp {
    final FSEditLogOpCodes opCode;
    long txid;
    private static ThreadLocal<EnumMap<FSEditLogOpCodes, FSEditLogOp>> opInstances = new ThreadLocal<EnumMap<FSEditLogOpCodes, FSEditLogOp>>(){

        @Override
        protected EnumMap<FSEditLogOpCodes, FSEditLogOp> initialValue() {
            EnumMap<FSEditLogOpCodes, FSEditLogOp> instances = new EnumMap<FSEditLogOpCodes, FSEditLogOp>(FSEditLogOpCodes.class);
            instances.put(FSEditLogOpCodes.OP_ADD, new AddOp());
            instances.put(FSEditLogOpCodes.OP_CLOSE, new CloseOp());
            instances.put(FSEditLogOpCodes.OP_SET_REPLICATION, new SetReplicationOp());
            instances.put(FSEditLogOpCodes.OP_CONCAT_DELETE, new ConcatDeleteOp());
            instances.put(FSEditLogOpCodes.OP_RENAME_OLD, new RenameOldOp());
            instances.put(FSEditLogOpCodes.OP_DELETE, new DeleteOp());
            instances.put(FSEditLogOpCodes.OP_MKDIR, new MkdirOp());
            instances.put(FSEditLogOpCodes.OP_SET_GENSTAMP, new SetGenstampOp());
            instances.put(FSEditLogOpCodes.OP_DATANODE_ADD, new DatanodeAddOp());
            instances.put(FSEditLogOpCodes.OP_DATANODE_REMOVE, new DatanodeRemoveOp());
            instances.put(FSEditLogOpCodes.OP_SET_PERMISSIONS, new SetPermissionsOp());
            instances.put(FSEditLogOpCodes.OP_SET_OWNER, new SetOwnerOp());
            instances.put(FSEditLogOpCodes.OP_SET_NS_QUOTA, new SetNSQuotaOp());
            instances.put(FSEditLogOpCodes.OP_CLEAR_NS_QUOTA, new ClearNSQuotaOp());
            instances.put(FSEditLogOpCodes.OP_SET_QUOTA, new SetQuotaOp());
            instances.put(FSEditLogOpCodes.OP_TIMES, new TimesOp());
            instances.put(FSEditLogOpCodes.OP_SYMLINK, new SymlinkOp());
            instances.put(FSEditLogOpCodes.OP_RENAME, new RenameOp());
            instances.put(FSEditLogOpCodes.OP_REASSIGN_LEASE, new ReassignLeaseOp());
            instances.put(FSEditLogOpCodes.OP_GET_DELEGATION_TOKEN, new GetDelegationTokenOp());
            instances.put(FSEditLogOpCodes.OP_RENEW_DELEGATION_TOKEN, new RenewDelegationTokenOp());
            instances.put(FSEditLogOpCodes.OP_CANCEL_DELEGATION_TOKEN, new CancelDelegationTokenOp());
            instances.put(FSEditLogOpCodes.OP_UPDATE_MASTER_KEY, new UpdateMasterKeyOp());
            instances.put(FSEditLogOpCodes.OP_START_LOG_SEGMENT, new LogSegmentOp(FSEditLogOpCodes.OP_START_LOG_SEGMENT));
            instances.put(FSEditLogOpCodes.OP_END_LOG_SEGMENT, new LogSegmentOp(FSEditLogOpCodes.OP_END_LOG_SEGMENT));
            instances.put(FSEditLogOpCodes.OP_UPDATE_BLOCKS, new UpdateBlocksOp());
            return instances;
        }
    };

    private FSEditLogOp(FSEditLogOpCodes opCode) {
        this.opCode = opCode;
        this.txid = 0L;
    }

    public long getTransactionId() {
        return this.txid;
    }

    public void setTransactionId(long txid) {
        this.txid = txid;
    }

    abstract void readFields(DataInputStream var1, int var2) throws IOException;

    abstract void writeFields(DataOutputStream var1) throws IOException;

    private static short readShort(DataInputStream in) throws IOException {
        return Short.parseShort(FSImageSerialization.readString(in));
    }

    private static long readLong(DataInputStream in) throws IOException {
        return Long.parseLong(FSImageSerialization.readString(in));
    }

    public static class Reader {
        private final DataInputStream in;
        private final int logVersion;
        private final Checksum checksum;

        public Reader(DataInputStream in, int logVersion) {
            this.logVersion = logVersion;
            this.checksum = LayoutVersion.supports(LayoutVersion.Feature.EDITS_CHESKUM, logVersion) ? new PureJavaCrc32() : null;
            this.in = this.checksum != null ? new DataInputStream(new CheckedInputStream(in, this.checksum)) : in;
        }

        public FSEditLogOp readOp() throws IOException {
            byte opCodeByte;
            if (this.checksum != null) {
                this.checksum.reset();
            }
            this.in.mark(1);
            try {
                opCodeByte = this.in.readByte();
            }
            catch (EOFException eof) {
                return null;
            }
            FSEditLogOpCodes opCode = FSEditLogOpCodes.fromByte(opCodeByte);
            if (opCode == FSEditLogOpCodes.OP_INVALID) {
                this.in.reset();
                return null;
            }
            FSEditLogOp op = (FSEditLogOp)((EnumMap)opInstances.get()).get((Object)opCode);
            if (op == null) {
                throw new IOException("Read invalid opcode " + (Object)((Object)opCode));
            }
            if (LayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, this.logVersion)) {
                op.setTransactionId(this.in.readLong());
            }
            op.readFields(this.in, this.logVersion);
            this.validateChecksum(this.in, this.checksum, op.txid);
            return op;
        }

        private void validateChecksum(DataInputStream in, Checksum checksum, long txid) throws IOException {
            if (checksum != null) {
                int calculatedChecksum = (int)checksum.getValue();
                int readChecksum = in.readInt();
                if (readChecksum != calculatedChecksum) {
                    throw new ChecksumException("Transaction is corrupt. Calculated checksum is " + calculatedChecksum + " but read checksum " + readChecksum, txid);
                }
            }
        }
    }

    public static class Writer {
        private final DataOutputBuffer buf;
        private final Checksum checksum;

        public Writer(DataOutputBuffer out) {
            this.buf = out;
            this.checksum = new PureJavaCrc32();
        }

        public void writeOp(FSEditLogOp op) throws IOException {
            int start = this.buf.getLength();
            this.buf.writeByte((int)op.opCode.getOpCode());
            this.buf.writeLong(op.txid);
            op.writeFields((DataOutputStream)this.buf);
            int end = this.buf.getLength();
            this.checksum.reset();
            this.checksum.update(this.buf.getData(), start, end - start);
            int sum = (int)this.checksum.getValue();
            this.buf.writeInt(sum);
        }
    }

    static class BlockTwo
    implements Writable {
        long blkid = 0L;
        long len = 0L;

        BlockTwo() {
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.blkid);
            out.writeLong(this.len);
        }

        public void readFields(DataInput in) throws IOException {
            this.blkid = in.readLong();
            this.len = in.readLong();
        }

        static {
            WritableFactories.setFactory(BlockTwo.class, (WritableFactory)new WritableFactory(){

                public Writable newInstance() {
                    return new BlockTwo();
                }
            });
        }
    }

    static class InvalidOp
    extends FSEditLogOp {
        private InvalidOp() {
            super(FSEditLogOpCodes.OP_INVALID);
        }

        static InvalidOp getInstance() {
            return (InvalidOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_INVALID);
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("InvalidOp [opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class LogSegmentOp
    extends FSEditLogOp {
        private LogSegmentOp(FSEditLogOpCodes code) {
            super(code);
            assert (code == FSEditLogOpCodes.OP_START_LOG_SEGMENT || code == FSEditLogOpCodes.OP_END_LOG_SEGMENT) : "Bad op: " + (Object)((Object)code);
        }

        static LogSegmentOp getInstance(FSEditLogOpCodes code) {
            return (LogSegmentOp)((EnumMap)opInstances.get()).get((Object)code);
        }

        @Override
        public void readFields(DataInputStream in, int logVersion) throws IOException {
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LogSegmentOp [opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class UpdateMasterKeyOp
    extends FSEditLogOp {
        DelegationKey key;

        private UpdateMasterKeyOp() {
            super(FSEditLogOpCodes.OP_UPDATE_MASTER_KEY);
        }

        static UpdateMasterKeyOp getInstance() {
            return (UpdateMasterKeyOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_UPDATE_MASTER_KEY);
        }

        UpdateMasterKeyOp setDelegationKey(DelegationKey key) {
            this.key = key;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            this.key.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.key = new DelegationKey();
            this.key.readFields((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UpdateMasterKeyOp [key=");
            builder.append(this.key);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class CancelDelegationTokenOp
    extends FSEditLogOp {
        DelegationTokenIdentifier token;

        private CancelDelegationTokenOp() {
            super(FSEditLogOpCodes.OP_CANCEL_DELEGATION_TOKEN);
        }

        static CancelDelegationTokenOp getInstance() {
            return (CancelDelegationTokenOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_CANCEL_DELEGATION_TOKEN);
        }

        CancelDelegationTokenOp setDelegationTokenIdentifier(DelegationTokenIdentifier token) {
            this.token = token;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            this.token.write(out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.token = new DelegationTokenIdentifier();
            this.token.readFields(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CancelDelegationTokenOp [token=");
            builder.append((Object)this.token);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class RenewDelegationTokenOp
    extends FSEditLogOp {
        DelegationTokenIdentifier token;
        long expiryTime;

        private RenewDelegationTokenOp() {
            super(FSEditLogOpCodes.OP_RENEW_DELEGATION_TOKEN);
        }

        static RenewDelegationTokenOp getInstance() {
            return (RenewDelegationTokenOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_RENEW_DELEGATION_TOKEN);
        }

        RenewDelegationTokenOp setDelegationTokenIdentifier(DelegationTokenIdentifier token) {
            this.token = token;
            return this;
        }

        RenewDelegationTokenOp setExpiryTime(long expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            this.token.write(out);
            FSImageSerialization.writeLong(this.expiryTime, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.token = new DelegationTokenIdentifier();
            this.token.readFields(in);
            this.expiryTime = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenewDelegationTokenOp [token=");
            builder.append((Object)this.token);
            builder.append(", expiryTime=");
            builder.append(this.expiryTime);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class GetDelegationTokenOp
    extends FSEditLogOp {
        DelegationTokenIdentifier token;
        long expiryTime;

        private GetDelegationTokenOp() {
            super(FSEditLogOpCodes.OP_GET_DELEGATION_TOKEN);
        }

        static GetDelegationTokenOp getInstance() {
            return (GetDelegationTokenOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_GET_DELEGATION_TOKEN);
        }

        GetDelegationTokenOp setDelegationTokenIdentifier(DelegationTokenIdentifier token) {
            this.token = token;
            return this;
        }

        GetDelegationTokenOp setExpiryTime(long expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            this.token.write(out);
            FSImageSerialization.writeLong(this.expiryTime, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.token = new DelegationTokenIdentifier();
            this.token.readFields(in);
            this.expiryTime = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GetDelegationTokenOp [token=");
            builder.append((Object)this.token);
            builder.append(", expiryTime=");
            builder.append(this.expiryTime);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class ReassignLeaseOp
    extends FSEditLogOp {
        String leaseHolder;
        String path;
        String newHolder;

        private ReassignLeaseOp() {
            super(FSEditLogOpCodes.OP_REASSIGN_LEASE);
        }

        static ReassignLeaseOp getInstance() {
            return (ReassignLeaseOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_REASSIGN_LEASE);
        }

        ReassignLeaseOp setLeaseHolder(String leaseHolder) {
            this.leaseHolder = leaseHolder;
            return this;
        }

        ReassignLeaseOp setPath(String path) {
            this.path = path;
            return this;
        }

        ReassignLeaseOp setNewHolder(String newHolder) {
            this.newHolder = newHolder;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.leaseHolder, out);
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeString(this.newHolder, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.leaseHolder = FSImageSerialization.readString(in);
            this.path = FSImageSerialization.readString(in);
            this.newHolder = FSImageSerialization.readString(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ReassignLeaseOp [leaseHolder=");
            builder.append(this.leaseHolder);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", newHolder=");
            builder.append(this.newHolder);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class RenameOp
    extends FSEditLogOp {
        int length;
        String src;
        String dst;
        long timestamp;
        Options.Rename[] options;

        private RenameOp() {
            super(FSEditLogOpCodes.OP_RENAME);
        }

        static RenameOp getInstance() {
            return (RenameOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_RENAME);
        }

        RenameOp setSource(String src) {
            this.src = src;
            return this;
        }

        RenameOp setDestination(String dst) {
            this.dst = dst;
            return this;
        }

        RenameOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        RenameOp setOptions(Options.Rename[] options) {
            this.options = options;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.dst, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            RenameOp.toBytesWritable(this.options).write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 3) {
                    throw new IOException("Incorrect data format. Rename operation.");
                }
            }
            this.src = FSImageSerialization.readString(in);
            this.dst = FSImageSerialization.readString(in);
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            this.options = RenameOp.readRenameOptions(in);
        }

        private static Options.Rename[] readRenameOptions(DataInputStream in) throws IOException {
            BytesWritable writable = new BytesWritable();
            writable.readFields((DataInput)in);
            byte[] bytes = writable.getBytes();
            Options.Rename[] options = new Options.Rename[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                options[i] = Options.Rename.valueOf((byte)bytes[i]);
            }
            return options;
        }

        static BytesWritable toBytesWritable(Options.Rename ... options) {
            byte[] bytes = new byte[options.length];
            for (int i = 0; i < options.length; ++i) {
                bytes[i] = options[i].value();
            }
            return new BytesWritable(bytes);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenameOp [length=");
            builder.append(this.length);
            builder.append(", src=");
            builder.append(this.src);
            builder.append(", dst=");
            builder.append(this.dst);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", options=");
            builder.append(Arrays.toString(this.options));
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class SymlinkOp
    extends FSEditLogOp {
        int length;
        String path;
        String value;
        long mtime;
        long atime;
        PermissionStatus permissionStatus;

        private SymlinkOp() {
            super(FSEditLogOpCodes.OP_SYMLINK);
        }

        static SymlinkOp getInstance() {
            return (SymlinkOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_SYMLINK);
        }

        SymlinkOp setPath(String path) {
            this.path = path;
            return this;
        }

        SymlinkOp setValue(String value) {
            this.value = value;
            return this;
        }

        SymlinkOp setModificationTime(long mtime) {
            this.mtime = mtime;
            return this;
        }

        SymlinkOp setAccessTime(long atime) {
            this.atime = atime;
            return this;
        }

        SymlinkOp setPermissionStatus(PermissionStatus permissionStatus) {
            this.permissionStatus = permissionStatus;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeString(this.value, out);
            FSImageSerialization.writeLong(this.mtime, out);
            FSImageSerialization.writeLong(this.atime, out);
            this.permissionStatus.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 4) {
                    throw new IOException("Incorrect data format. symlink operation.");
                }
            }
            this.path = FSImageSerialization.readString(in);
            this.value = FSImageSerialization.readString(in);
            if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.mtime = FSImageSerialization.readLong(in);
                this.atime = FSImageSerialization.readLong(in);
            } else {
                this.mtime = FSEditLogOp.readLong(in);
                this.atime = FSEditLogOp.readLong(in);
            }
            this.permissionStatus = PermissionStatus.read((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SymlinkOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", value=");
            builder.append(this.value);
            builder.append(", mtime=");
            builder.append(this.mtime);
            builder.append(", atime=");
            builder.append(this.atime);
            builder.append(", permissionStatus=");
            builder.append(this.permissionStatus);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class TimesOp
    extends FSEditLogOp {
        int length;
        String path;
        long mtime;
        long atime;

        private TimesOp() {
            super(FSEditLogOpCodes.OP_TIMES);
        }

        static TimesOp getInstance() {
            return (TimesOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_TIMES);
        }

        TimesOp setPath(String path) {
            this.path = path;
            return this;
        }

        TimesOp setModificationTime(long mtime) {
            this.mtime = mtime;
            return this;
        }

        TimesOp setAccessTime(long atime) {
            this.atime = atime;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeLong(this.mtime, out);
            FSImageSerialization.writeLong(this.atime, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 3) {
                    throw new IOException("Incorrect data format. times operation.");
                }
            }
            this.path = FSImageSerialization.readString(in);
            if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.mtime = FSImageSerialization.readLong(in);
                this.atime = FSImageSerialization.readLong(in);
            } else {
                this.mtime = FSEditLogOp.readLong(in);
                this.atime = FSEditLogOp.readLong(in);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TimesOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", mtime=");
            builder.append(this.mtime);
            builder.append(", atime=");
            builder.append(this.atime);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class SetQuotaOp
    extends FSEditLogOp {
        String src;
        long nsQuota;
        long dsQuota;

        private SetQuotaOp() {
            super(FSEditLogOpCodes.OP_SET_QUOTA);
        }

        static SetQuotaOp getInstance() {
            return (SetQuotaOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_SET_QUOTA);
        }

        SetQuotaOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetQuotaOp setNSQuota(long nsQuota) {
            this.nsQuota = nsQuota;
            return this;
        }

        SetQuotaOp setDSQuota(long dsQuota) {
            this.dsQuota = dsQuota;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeLong(this.nsQuota, out);
            FSImageSerialization.writeLong(this.dsQuota, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.nsQuota = FSImageSerialization.readLong(in);
            this.dsQuota = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetQuotaOp [src=");
            builder.append(this.src);
            builder.append(", nsQuota=");
            builder.append(this.nsQuota);
            builder.append(", dsQuota=");
            builder.append(this.dsQuota);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class ClearNSQuotaOp
    extends FSEditLogOp {
        String src;

        private ClearNSQuotaOp() {
            super(FSEditLogOpCodes.OP_CLEAR_NS_QUOTA);
        }

        static ClearNSQuotaOp getInstance() {
            return (ClearNSQuotaOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_CLEAR_NS_QUOTA);
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            throw new IOException("Deprecated");
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ClearNSQuotaOp [src=");
            builder.append(this.src);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class SetNSQuotaOp
    extends FSEditLogOp {
        String src;
        long nsQuota;

        private SetNSQuotaOp() {
            super(FSEditLogOpCodes.OP_SET_NS_QUOTA);
        }

        static SetNSQuotaOp getInstance() {
            return (SetNSQuotaOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_SET_NS_QUOTA);
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            throw new IOException("Deprecated");
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.nsQuota = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetNSQuotaOp [src=");
            builder.append(this.src);
            builder.append(", nsQuota=");
            builder.append(this.nsQuota);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class SetOwnerOp
    extends FSEditLogOp {
        String src;
        String username;
        String groupname;

        private SetOwnerOp() {
            super(FSEditLogOpCodes.OP_SET_OWNER);
        }

        static SetOwnerOp getInstance() {
            return (SetOwnerOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_SET_OWNER);
        }

        SetOwnerOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetOwnerOp setUser(String username) {
            this.username = username;
            return this;
        }

        SetOwnerOp setGroup(String groupname) {
            this.groupname = groupname;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.username == null ? "" : this.username, out);
            FSImageSerialization.writeString(this.groupname == null ? "" : this.groupname, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.username = FSImageSerialization.readString_EmptyAsNull(in);
            this.groupname = FSImageSerialization.readString_EmptyAsNull(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetOwnerOp [src=");
            builder.append(this.src);
            builder.append(", username=");
            builder.append(this.username);
            builder.append(", groupname=");
            builder.append(this.groupname);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class SetPermissionsOp
    extends FSEditLogOp {
        String src;
        FsPermission permissions;

        private SetPermissionsOp() {
            super(FSEditLogOpCodes.OP_SET_PERMISSIONS);
        }

        static SetPermissionsOp getInstance() {
            return (SetPermissionsOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_SET_PERMISSIONS);
        }

        SetPermissionsOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetPermissionsOp setPermissions(FsPermission permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            this.permissions.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.permissions = FsPermission.read((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetPermissionsOp [src=");
            builder.append(this.src);
            builder.append(", permissions=");
            builder.append(this.permissions);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class DatanodeRemoveOp
    extends FSEditLogOp {
        private DatanodeRemoveOp() {
            super(FSEditLogOpCodes.OP_DATANODE_REMOVE);
        }

        static DatanodeRemoveOp getInstance() {
            return (DatanodeRemoveOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_DATANODE_REMOVE);
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            throw new IOException("Deprecated, should not write");
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            DatanodeID nodeID = new DatanodeID();
            nodeID.readFields(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DatanodeRemoveOp [opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class DatanodeAddOp
    extends FSEditLogOp {
        private DatanodeAddOp() {
            super(FSEditLogOpCodes.OP_DATANODE_ADD);
        }

        static DatanodeAddOp getInstance() {
            return (DatanodeAddOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_DATANODE_ADD);
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            throw new IOException("Deprecated, should not write");
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            FSImageSerialization.DatanodeImage.skipOne(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DatanodeAddOp [opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class SetGenstampOp
    extends FSEditLogOp {
        long genStamp;

        private SetGenstampOp() {
            super(FSEditLogOpCodes.OP_SET_GENSTAMP);
        }

        static SetGenstampOp getInstance() {
            return (SetGenstampOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_SET_GENSTAMP);
        }

        SetGenstampOp setGenerationStamp(long genStamp) {
            this.genStamp = genStamp;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.genStamp, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.genStamp = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetGenstampOp [genStamp=");
            builder.append(this.genStamp);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class MkdirOp
    extends FSEditLogOp {
        int length;
        String path;
        long timestamp;
        PermissionStatus permissions;

        private MkdirOp() {
            super(FSEditLogOpCodes.OP_MKDIR);
        }

        static MkdirOp getInstance() {
            return (MkdirOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_MKDIR);
        }

        MkdirOp setPath(String path) {
            this.path = path;
            return this;
        }

        MkdirOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        MkdirOp setPermissionStatus(PermissionStatus permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            this.permissions.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
            }
            if (-17 < logVersion && this.length != 2 || logVersion <= -17 && this.length != 3 && !LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                throw new IOException("Incorrect data format. Mkdir operation.");
            }
            this.path = FSImageSerialization.readString(in);
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            if (LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, logVersion)) {
                if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                    FSImageSerialization.readLong(in);
                } else {
                    FSEditLogOp.readLong(in);
                }
            }
            this.permissions = logVersion <= -11 ? PermissionStatus.read((DataInput)in) : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MkdirOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", permissions=");
            builder.append(this.permissions);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class DeleteOp
    extends FSEditLogOp {
        int length;
        String path;
        long timestamp;

        private DeleteOp() {
            super(FSEditLogOpCodes.OP_DELETE);
        }

        static DeleteOp getInstance() {
            return (DeleteOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_DELETE);
        }

        DeleteOp setPath(String path) {
            this.path = path;
            return this;
        }

        DeleteOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeLong(this.timestamp, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 2) {
                    throw new IOException("Incorrect data format. delete operation.");
                }
            }
            this.path = FSImageSerialization.readString(in);
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DeleteOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class RenameOldOp
    extends FSEditLogOp {
        int length;
        String src;
        String dst;
        long timestamp;

        private RenameOldOp() {
            super(FSEditLogOpCodes.OP_RENAME_OLD);
        }

        static RenameOldOp getInstance() {
            return (RenameOldOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_RENAME_OLD);
        }

        RenameOldOp setSource(String src) {
            this.src = src;
            return this;
        }

        RenameOldOp setDestination(String dst) {
            this.dst = dst;
            return this;
        }

        RenameOldOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.dst, out);
            FSImageSerialization.writeLong(this.timestamp, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 3) {
                    throw new IOException("Incorrect data format. Old rename operation.");
                }
            }
            this.src = FSImageSerialization.readString(in);
            this.dst = FSImageSerialization.readString(in);
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenameOldOp [length=");
            builder.append(this.length);
            builder.append(", src=");
            builder.append(this.src);
            builder.append(", dst=");
            builder.append(this.dst);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class ConcatDeleteOp
    extends FSEditLogOp {
        int length;
        String trg;
        String[] srcs;
        long timestamp;

        private ConcatDeleteOp() {
            super(FSEditLogOpCodes.OP_CONCAT_DELETE);
        }

        static ConcatDeleteOp getInstance() {
            return (ConcatDeleteOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_CONCAT_DELETE);
        }

        ConcatDeleteOp setTarget(String trg) {
            this.trg = trg;
            return this;
        }

        ConcatDeleteOp setSources(String[] srcs) {
            this.srcs = srcs;
            return this;
        }

        ConcatDeleteOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.trg, out);
            DeprecatedUTF8[] info = new DeprecatedUTF8[this.srcs.length];
            int idx = 0;
            for (int i = 0; i < this.srcs.length; ++i) {
                info[idx++] = new DeprecatedUTF8(this.srcs[i]);
            }
            new ArrayWritable(DeprecatedUTF8.class, (Writable[])info).write((DataOutput)out);
            FSImageSerialization.writeLong(this.timestamp, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length < 3) {
                    throw new IOException("Incorrect data format. Concat delete operation.");
                }
            }
            this.trg = FSImageSerialization.readString(in);
            int srcSize = 0;
            srcSize = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? in.readInt() : this.length - 1 - 1;
            this.srcs = new String[srcSize];
            for (int i = 0; i < srcSize; ++i) {
                this.srcs[i] = FSImageSerialization.readString(in);
            }
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ConcatDeleteOp [length=");
            builder.append(this.length);
            builder.append(", trg=");
            builder.append(this.trg);
            builder.append(", srcs=");
            builder.append(Arrays.toString(this.srcs));
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class SetReplicationOp
    extends FSEditLogOp {
        String path;
        short replication;

        private SetReplicationOp() {
            super(FSEditLogOpCodes.OP_SET_REPLICATION);
        }

        static SetReplicationOp getInstance() {
            return (SetReplicationOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_SET_REPLICATION);
        }

        SetReplicationOp setPath(String path) {
            this.path = path;
            return this;
        }

        SetReplicationOp setReplication(short replication) {
            this.replication = replication;
            return this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeShort(this.replication, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.path = FSImageSerialization.readString(in);
            this.replication = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readShort(in) : FSEditLogOp.readShort(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetReplicationOp [path=");
            builder.append(this.path);
            builder.append(", replication=");
            builder.append(this.replication);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static class UpdateBlocksOp
    extends FSEditLogOp
    implements BlockListUpdatingOp {
        String path;
        Block[] blocks;

        private UpdateBlocksOp() {
            super(FSEditLogOpCodes.OP_UPDATE_BLOCKS);
        }

        static UpdateBlocksOp getInstance() {
            return (UpdateBlocksOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_UPDATE_BLOCKS);
        }

        UpdateBlocksOp setPath(String path) {
            this.path = path;
            return this;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        UpdateBlocksOp setBlocks(Block[] blocks) {
            this.blocks = blocks;
            return this;
        }

        @Override
        public Block[] getBlocks() {
            return this.blocks;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeCompactBlockArray(this.blocks, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.path = FSImageSerialization.readString(in);
            this.blocks = FSImageSerialization.readCompactBlockArray(in, logVersion);
        }

        @Override
        public boolean shouldCompleteLastBlock() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UpdateBlocksOp [path=").append(this.path).append(", blocks=").append(Arrays.toString(this.blocks)).append("]");
            return sb.toString();
        }
    }

    static class CloseOp
    extends AddCloseOp {
        private CloseOp() {
            super(FSEditLogOpCodes.OP_CLOSE);
        }

        static CloseOp getInstance() {
            return (CloseOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_CLOSE);
        }

        @Override
        public boolean shouldCompleteLastBlock() {
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CloseOp ");
            builder.append(this.stringifyMembers());
            return builder.toString();
        }
    }

    static class AddOp
    extends AddCloseOp {
        private AddOp() {
            super(FSEditLogOpCodes.OP_ADD);
        }

        static AddOp getInstance() {
            return (AddOp)((EnumMap)opInstances.get()).get((Object)FSEditLogOpCodes.OP_ADD);
        }

        @Override
        public boolean shouldCompleteLastBlock() {
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AddOp ");
            builder.append(this.stringifyMembers());
            return builder.toString();
        }
    }

    static abstract class AddCloseOp
    extends FSEditLogOp
    implements BlockListUpdatingOp {
        int length;
        String path;
        short replication;
        long mtime;
        long atime;
        long blockSize;
        Block[] blocks;
        PermissionStatus permissions;
        String clientName;
        String clientMachine;

        private AddCloseOp(FSEditLogOpCodes opCode) {
            super(opCode);
            assert (opCode == FSEditLogOpCodes.OP_ADD || opCode == FSEditLogOpCodes.OP_CLOSE);
        }

        <T extends AddCloseOp> T setPath(String path) {
            this.path = path;
            return (T)this;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        <T extends AddCloseOp> T setReplication(short replication) {
            this.replication = replication;
            return (T)this;
        }

        <T extends AddCloseOp> T setModificationTime(long mtime) {
            this.mtime = mtime;
            return (T)this;
        }

        <T extends AddCloseOp> T setAccessTime(long atime) {
            this.atime = atime;
            return (T)this;
        }

        <T extends AddCloseOp> T setBlockSize(long blockSize) {
            this.blockSize = blockSize;
            return (T)this;
        }

        <T extends AddCloseOp> T setBlocks(Block[] blocks) {
            this.blocks = blocks;
            return (T)this;
        }

        @Override
        public Block[] getBlocks() {
            return this.blocks;
        }

        <T extends AddCloseOp> T setPermissionStatus(PermissionStatus permissions) {
            this.permissions = permissions;
            return (T)this;
        }

        <T extends AddCloseOp> T setClientName(String clientName) {
            this.clientName = clientName;
            return (T)this;
        }

        <T extends AddCloseOp> T setClientMachine(String clientMachine) {
            this.clientMachine = clientMachine;
            return (T)this;
        }

        @Override
        void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeShort(this.replication, out);
            FSImageSerialization.writeLong(this.mtime, out);
            FSImageSerialization.writeLong(this.atime, out);
            FSImageSerialization.writeLong(this.blockSize, out);
            new ArrayWritable(Block.class, (Writable[])this.blocks).write((DataOutput)out);
            this.permissions.write((DataOutput)out);
            if (this.opCode == FSEditLogOpCodes.OP_ADD) {
                FSImageSerialization.writeString(this.clientName, out);
                FSImageSerialization.writeString(this.clientMachine, out);
            }
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
            }
            if (-7 == logVersion && this.length != 3 || -17 < logVersion && logVersion < -7 && this.length != 4 || logVersion <= -17 && this.length != 5 && !LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                throw new IOException("Incorrect data format. logVersion is " + logVersion + " but writables.length is " + this.length + ". ");
            }
            this.path = FSImageSerialization.readString(in);
            if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.replication = FSImageSerialization.readShort(in);
                this.mtime = FSImageSerialization.readLong(in);
            } else {
                this.replication = FSEditLogOp.readShort(in);
                this.mtime = FSEditLogOp.readLong(in);
            }
            this.atime = LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, logVersion) ? (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in)) : 0L;
            this.blockSize = logVersion < -7 ? (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in)) : 0L;
            this.blocks = AddCloseOp.readBlocks(in, logVersion);
            this.permissions = logVersion <= -11 ? PermissionStatus.read((DataInput)in) : null;
            if (this.opCode == FSEditLogOpCodes.OP_ADD && logVersion <= -12) {
                this.clientName = FSImageSerialization.readString(in);
                this.clientMachine = FSImageSerialization.readString(in);
                if (-13 <= logVersion) {
                    AddCloseOp.readDatanodeDescriptorArray(in);
                }
            } else {
                this.clientName = "";
                this.clientMachine = "";
            }
        }

        private static DatanodeDescriptor[] readDatanodeDescriptorArray(DataInput in) throws IOException {
            DatanodeDescriptor[] locations = new DatanodeDescriptor[in.readInt()];
            for (int i = 0; i < locations.length; ++i) {
                locations[i] = new DatanodeDescriptor();
                locations[i].readFieldsFromFSEditLog(in);
            }
            return locations;
        }

        private static Block[] readBlocks(DataInputStream in, int logVersion) throws IOException {
            int numBlocks = in.readInt();
            Block[] blocks = new Block[numBlocks];
            for (int i = 0; i < numBlocks; ++i) {
                Block blk = new Block();
                if (logVersion <= -14) {
                    blk.readFields(in);
                } else {
                    BlockTwo oldblk = new BlockTwo();
                    oldblk.readFields(in);
                    blk.set(oldblk.blkid, oldblk.len, 0L);
                }
                blocks[i] = blk;
            }
            return blocks;
        }

        public String stringifyMembers() {
            StringBuilder builder = new StringBuilder();
            builder.append("[length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", replication=");
            builder.append(this.replication);
            builder.append(", mtime=");
            builder.append(this.mtime);
            builder.append(", atime=");
            builder.append(this.atime);
            builder.append(", blockSize=");
            builder.append(this.blockSize);
            builder.append(", blocks=");
            builder.append(Arrays.toString(this.blocks));
            builder.append(", permissions=");
            builder.append(this.permissions);
            builder.append(", clientName=");
            builder.append(this.clientName);
            builder.append(", clientMachine=");
            builder.append(this.clientMachine);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }
    }

    static interface BlockListUpdatingOp {
        public Block[] getBlocks();

        public String getPath();

        public boolean shouldCompleteLastBlock();
    }
}

