/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.znerd.xmlenc.XMLOutputter;

class NamenodeJspHelper {
    NamenodeJspHelper() {
    }

    static String getSafeModeText(FSNamesystem fsn) {
        if (!fsn.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. <em>" + fsn.getSafeModeTip() + "</em><br>";
    }

    static String getSecurityModeText() {
        if (UserGroupInformation.isSecurityEnabled()) {
            return "Security is <em>ON</em> <br>";
        }
        return "Security is <em>OFF</em> <br>";
    }

    static String getInodeLimitText(FSNamesystem fsn) {
        long inodes = fsn.dir.totalInodes();
        long blocks = fsn.getBlocksTotal();
        long maxobjects = fsn.getMaxObjects();
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = mem.getHeapMemoryUsage();
        long totalMemory = heap.getUsed();
        long maxMemory = heap.getMax();
        long commitedMemory = heap.getCommitted();
        MemoryUsage nonHeap = mem.getNonHeapMemoryUsage();
        long totalNonHeap = nonHeap.getUsed();
        long maxNonHeap = nonHeap.getMax();
        long commitedNonHeap = nonHeap.getCommitted();
        long used = totalMemory * 100L / commitedMemory;
        long usedNonHeap = totalNonHeap * 100L / commitedNonHeap;
        String str = inodes + " files and directories, " + blocks + " blocks = " + (inodes + blocks) + " total";
        if (maxobjects != 0L) {
            long pct = (inodes + blocks) * 100L / maxobjects;
            str = str + " / " + maxobjects + " (" + pct + "%)";
        }
        str = str + ".<br>";
        str = str + "Heap Memory used " + StringUtils.byteDesc((long)totalMemory) + " is " + " " + used + "% of Commited Heap Memory " + StringUtils.byteDesc((long)commitedMemory) + ". Max Heap Memory is " + StringUtils.byteDesc((long)maxMemory) + ". <br>";
        str = str + "Non Heap Memory used " + StringUtils.byteDesc((long)totalNonHeap) + " is" + " " + usedNonHeap + "% of " + " Commited Non Heap Memory " + StringUtils.byteDesc((long)commitedNonHeap) + ". Max Non Heap Memory is " + StringUtils.byteDesc((long)maxNonHeap) + ".<br>";
        return str;
    }

    static String getUpgradeStatusText(FSNamesystem fsn) {
        String statusText = "";
        try {
            UpgradeStatusReport status = fsn.distributedUpgradeProgress(HdfsConstants.UpgradeAction.GET_STATUS);
            statusText = status == null ? "There are no upgrades in progress." : status.getStatusText(false);
        }
        catch (IOException e) {
            statusText = "Upgrade status unknown.";
        }
        return statusText;
    }

    static String getVersionTable(FSNamesystem fsn) {
        return "<div id='dfstable'><table>\n  <tr><td id='col1'>Started:</td><td>" + fsn.getStartTime() + "</td></tr>\n" + "\n  <tr><td id='col1'>Version:</td><td>" + VersionInfo.getVersion() + ", " + VersionInfo.getRevision() + "\n  <tr><td id='col1'>Compiled:</td><td>" + VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch() + "\n  <tr><td id='col1'>Upgrades:</td><td>" + NamenodeJspHelper.getUpgradeStatusText(fsn) + "\n  <tr><td id='col1'>Cluster ID:</td><td>" + fsn.getClusterId() + "</td></tr>\n" + "\n  <tr><td id='col1'>Block Pool ID:</td><td>" + fsn.getBlockPoolId() + "</td></tr>\n" + "\n</table></div>";
    }

    static String getCorruptFilesWarning(FSNamesystem fsn) {
        long missingBlocks = fsn.getMissingBlocksCount();
        if (missingBlocks > 0L) {
            StringBuilder result = new StringBuilder();
            result.append("<br/><a class=\"warning\" href=\"/corrupt_files.jsp\" title=\"List corrupt files\">\n");
            result.append("<b>WARNING : There are " + missingBlocks + " missing blocks. Please check the logs or run fsck in order to identify the missing blocks.</b>");
            result.append("</a>");
            result.append("<br/><div class=\"small\">See the Hadoop FAQ for common causes and potential solutions.");
            result.append("<br/><br/>\n");
            return result.toString();
        }
        return "";
    }

    static String getDelegationToken(final NamenodeProtocols nn, HttpServletRequest request, Configuration conf, final UserGroupInformation ugi) throws IOException, InterruptedException {
        Token token = (Token)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<DelegationTokenIdentifier>>(){

            @Override
            public Token<DelegationTokenIdentifier> run() throws IOException {
                return nn.getDelegationToken(new Text(ugi.getUserName()));
            }
        });
        return token == null ? null : token.encodeToUrlString();
    }

    static DatanodeDescriptor getRandomDatanode(NameNode namenode) {
        return (DatanodeDescriptor)namenode.getNamesystem().getBlockManager().getDatanodeManager().getNetworkTopology().chooseRandom("");
    }

    static void redirectToRandomDataNode(ServletContext context, HttpServletRequest request, HttpServletResponse resp) throws IOException, InterruptedException {
        int redirectPort;
        String nodeToRedirect;
        NameNode nn = NameNodeHttpServer.getNameNodeFromContext(context);
        Configuration conf = (Configuration)context.getAttribute("current.conf");
        if (nn.getNamesystem().getNumLiveDataNodes() < 1) {
            throw new IOException("Can't browse the DFS since there are no live nodes available to redirect to.");
        }
        DatanodeDescriptor datanode = NamenodeJspHelper.getRandomDatanode(nn);
        UserGroupInformation ugi = JspHelper.getUGI(context, request, conf);
        String tokenString = NamenodeJspHelper.getDelegationToken(nn.getRpcServer(), request, conf, ugi);
        if (datanode != null) {
            nodeToRedirect = datanode.getHost();
            redirectPort = datanode.getInfoPort();
        } else {
            nodeToRedirect = nn.getHttpAddress().getHostName();
            redirectPort = nn.getHttpAddress().getPort();
        }
        String addr = NetUtils.getHostPortString((InetSocketAddress)nn.getNameNodeAddress());
        String fqdn = InetAddress.getByName(nodeToRedirect).getCanonicalHostName();
        String redirectLocation = "http://" + fqdn + ":" + redirectPort + "/browseDirectory.jsp?namenodeInfoPort=" + nn.getHttpAddress().getPort() + "&dir=/" + (tokenString == null ? "" : JspHelper.getDelegationTokenUrlParam(tokenString)) + JspHelper.getUrlParam("nnaddr", addr);
        resp.sendRedirect(redirectLocation);
    }

    static class XMLCorruptBlockInfo {
        final Configuration conf;
        final Long startingBlockId;
        final int numCorruptBlocks;
        final BlockManager blockManager;

        XMLCorruptBlockInfo(FSNamesystem fsn, Configuration conf, int numCorruptBlocks, Long startingBlockId) {
            this.blockManager = fsn.getBlockManager();
            this.conf = conf;
            this.numCorruptBlocks = numCorruptBlocks;
            this.startingBlockId = startingBlockId;
        }

        public void toXML(XMLOutputter doc) throws IOException {
            doc.startTag("corrupt_block_info");
            if (this.numCorruptBlocks < 0 || this.numCorruptBlocks > 100) {
                doc.startTag("error");
                doc.pcdata("numCorruptBlocks must be >= 0 and <= 100");
                doc.endTag();
            }
            doc.startTag("dfs.replication");
            doc.pcdata("" + this.conf.getInt("dfs.replication", 3));
            doc.endTag();
            doc.startTag("num_missing_blocks");
            doc.pcdata("" + this.blockManager.getMissingBlocksCount());
            doc.endTag();
            doc.startTag("num_corrupt_replica_blocks");
            doc.pcdata("" + this.blockManager.getCorruptReplicaBlocksCount());
            doc.endTag();
            doc.startTag("corrupt_replica_block_ids");
            long[] corruptBlockIds = this.blockManager.getCorruptReplicaBlockIds(this.numCorruptBlocks, this.startingBlockId);
            if (corruptBlockIds != null) {
                long[] arr$ = corruptBlockIds;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Long blockId = arr$[i$];
                    doc.startTag("block_id");
                    doc.pcdata("" + blockId);
                    doc.endTag();
                }
            }
            doc.endTag();
            doc.endTag();
            doc.getWriter().flush();
        }
    }

    static class XMLBlockInfo {
        final Block block;
        final INodeFile inode;
        final BlockManager blockManager;

        XMLBlockInfo(FSNamesystem fsn, Long blockId) {
            this.blockManager = fsn.getBlockManager();
            if (blockId == null) {
                this.block = null;
                this.inode = null;
            } else {
                this.block = new Block(blockId);
                this.inode = this.blockManager.getINode(this.block);
            }
        }

        public void toXML(XMLOutputter doc) throws IOException {
            doc.startTag("block_info");
            if (this.block == null) {
                doc.startTag("error");
                doc.pcdata("blockId must be a Long");
                doc.endTag();
            } else {
                doc.startTag("block_id");
                doc.pcdata("" + this.block.getBlockId());
                doc.endTag();
                doc.startTag("block_name");
                doc.pcdata(this.block.getBlockName());
                doc.endTag();
                if (this.inode != null) {
                    doc.startTag("file");
                    doc.startTag("local_name");
                    doc.pcdata(this.inode.getLocalName());
                    doc.endTag();
                    doc.startTag("local_directory");
                    doc.pcdata(this.inode.getLocalParentDir());
                    doc.endTag();
                    doc.startTag("user_name");
                    doc.pcdata(this.inode.getUserName());
                    doc.endTag();
                    doc.startTag("group_name");
                    doc.pcdata(this.inode.getGroupName());
                    doc.endTag();
                    doc.startTag("is_directory");
                    doc.pcdata("" + this.inode.isDirectory());
                    doc.endTag();
                    doc.startTag("access_time");
                    doc.pcdata("" + this.inode.getAccessTime());
                    doc.endTag();
                    doc.startTag("is_under_construction");
                    doc.pcdata("" + this.inode.isUnderConstruction());
                    doc.endTag();
                    doc.startTag("ds_quota");
                    doc.pcdata("" + this.inode.getDsQuota());
                    doc.endTag();
                    doc.startTag("permission_status");
                    doc.pcdata(this.inode.getPermissionStatus().toString());
                    doc.endTag();
                    doc.startTag("replication");
                    doc.pcdata("" + this.inode.getReplication());
                    doc.endTag();
                    doc.startTag("disk_space_consumed");
                    doc.pcdata("" + this.inode.diskspaceConsumed());
                    doc.endTag();
                    doc.startTag("preferred_block_size");
                    doc.pcdata("" + this.inode.getPreferredBlockSize());
                    doc.endTag();
                    doc.endTag();
                }
                doc.startTag("replicas");
                Iterator<DatanodeDescriptor> it = this.blockManager.datanodeIterator(this.block);
                while (it.hasNext()) {
                    doc.startTag("replica");
                    DatanodeDescriptor dd = it.next();
                    doc.startTag("host_name");
                    doc.pcdata(dd.getHostName());
                    doc.endTag();
                    boolean isCorrupt = this.blockManager.getCorruptReplicaBlockIds(0, this.block.getBlockId()) != null;
                    doc.startTag("is_corrupt");
                    doc.pcdata("" + isCorrupt);
                    doc.endTag();
                    doc.endTag();
                }
                doc.endTag();
            }
            doc.endTag();
        }
    }

    static class NodeListJsp {
        private int rowNum = 0;
        private long diskBytes = 0x40000000L;
        private String diskByteStr = "GB";
        private String sorterField = null;
        private String sorterOrder = null;
        private String whatNodes = "LIVE";

        NodeListJsp() {
        }

        private String rowTxt() {
            return "<tr class=\"" + (this.rowNum++ % 2 == 0 ? "rowNormal" : "rowAlt") + "\"> ";
        }

        private void counterReset() {
            this.rowNum = 0;
        }

        private String nodeHeaderStr(String name) {
            String ret = "class=header";
            String order = "ASC";
            if (name.equals(this.sorterField)) {
                ret = ret + this.sorterOrder;
                if (this.sorterOrder.equals("ASC")) {
                    order = "DSC";
                }
            }
            ret = ret + " onClick=\"window.document.location='/dfsnodelist.jsp?whatNodes=" + this.whatNodes + "&sorter/field=" + name + "&sorter/order=" + order + "'\" title=\"sort on this column\"";
            return ret;
        }

        private void generateNodeDataHeader(JspWriter out, DatanodeDescriptor d, String suffix, boolean alive, int nnHttpPort, String nnaddr) throws IOException {
            String url = "http://" + d.getHostName() + ":" + d.getInfoPort() + "/browseDirectory.jsp?namenodeInfoPort=" + nnHttpPort + "&dir=" + URLEncoder.encode("/", "UTF-8") + JspHelper.getUrlParam("nnaddr", nnaddr);
            String name = d.getHostName() + ":" + d.getPort();
            if (!name.matches("\\d+\\.\\d+.\\d+\\.\\d+.*")) {
                name = name.replaceAll("\\.[^.:]*", "");
            }
            int idx = suffix != null && name.endsWith(suffix) ? name.indexOf(suffix) : -1;
            out.print(this.rowTxt() + "<td class=\"name\"><a title=\"" + d.getHost() + ":" + d.getPort() + "\" href=\"" + url + "\">" + (idx > 0 ? name.substring(0, idx) : name) + "</a>" + (alive ? "" : "\n"));
        }

        void generateDecommissioningNodeData(JspWriter out, DatanodeDescriptor d, String suffix, boolean alive, int nnHttpPort, String nnaddr) throws IOException {
            this.generateNodeDataHeader(out, d, suffix, alive, nnHttpPort, nnaddr);
            if (!alive) {
                return;
            }
            long decommRequestTime = d.decommissioningStatus.getStartTime();
            long timestamp = d.getLastUpdate();
            long currentTime = System.currentTimeMillis();
            long hoursSinceDecommStarted = (currentTime - decommRequestTime) / 3600000L;
            long remainderMinutes = (currentTime - decommRequestTime) / 60000L % 60L;
            out.print("<td class=\"lastcontact\"> " + (currentTime - timestamp) / 1000L + "<td class=\"underreplicatedblocks\">" + d.decommissioningStatus.getUnderReplicatedBlocks() + "<td class=\"blockswithonlydecommissioningreplicas\">" + d.decommissioningStatus.getDecommissionOnlyReplicas() + "<td class=\"underrepblocksinfilesunderconstruction\">" + d.decommissioningStatus.getUnderReplicatedInOpenFiles() + "<td class=\"timesincedecommissionrequest\">" + hoursSinceDecommStarted + " hrs " + remainderMinutes + " mins" + "\n");
        }

        void generateNodeData(JspWriter out, DatanodeDescriptor d, String suffix, boolean alive, int nnHttpPort, String nnaddr) throws IOException {
            this.generateNodeDataHeader(out, d, suffix, alive, nnHttpPort, nnaddr);
            if (!alive) {
                out.print("<td class=\"decommissioned\"> " + d.isDecommissioned() + "\n");
                return;
            }
            long c = d.getCapacity();
            long u = d.getDfsUsed();
            long nu = d.getNonDfsUsed();
            long r = d.getRemaining();
            String percentUsed = StringUtils.limitDecimalTo2((double)d.getDfsUsedPercent());
            String percentRemaining = StringUtils.limitDecimalTo2((double)d.getRemainingPercent());
            String adminState = d.getAdminState().toString();
            long timestamp = d.getLastUpdate();
            long currentTime = System.currentTimeMillis();
            long bpUsed = d.getBlockPoolUsed();
            String percentBpUsed = StringUtils.limitDecimalTo2((double)d.getBlockPoolUsedPercent());
            out.print("<td class=\"lastcontact\"> " + (currentTime - timestamp) / 1000L + "<td class=\"adminstate\">" + adminState + "<td align=\"right\" class=\"capacity\">" + StringUtils.limitDecimalTo2((double)((double)c * 1.0 / (double)this.diskBytes)) + "<td align=\"right\" class=\"used\">" + StringUtils.limitDecimalTo2((double)((double)u * 1.0 / (double)this.diskBytes)) + "<td align=\"right\" class=\"nondfsused\">" + StringUtils.limitDecimalTo2((double)((double)nu * 1.0 / (double)this.diskBytes)) + "<td align=\"right\" class=\"remaining\">" + StringUtils.limitDecimalTo2((double)((double)r * 1.0 / (double)this.diskBytes)) + "<td align=\"right\" class=\"pcused\">" + percentUsed + "<td class=\"pcused\">" + ServletUtil.percentageGraph((int)((int)Double.parseDouble(percentUsed)), (int)100) + "<td align=\"right\" class=\"pcremaining`\">" + percentRemaining + "<td title=" + "\"blocks scheduled : " + d.getBlocksScheduled() + "\" class=\"blocks\">" + d.numBlocks() + "\n" + "<td align=\"right\" class=\"bpused\">" + StringUtils.limitDecimalTo2((double)((double)bpUsed * 1.0 / (double)this.diskBytes)) + "<td align=\"right\" class=\"pcbpused\">" + percentBpUsed + "<td align=\"right\" class=\"volfails\">" + d.getVolumeFailures() + "\n");
        }

        void generateNodesList(ServletContext context, JspWriter out, HttpServletRequest request) throws IOException {
            int i;
            NameNode nn = NameNodeHttpServer.getNameNodeFromContext(context);
            FSNamesystem ns = nn.getNamesystem();
            DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
            ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
            ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
            dm.fetchDatanodes(live, dead, true);
            InetSocketAddress nnSocketAddress = (InetSocketAddress)context.getAttribute("name.node.address");
            String nnaddr = nnSocketAddress.getAddress().getHostAddress() + ":" + nnSocketAddress.getPort();
            this.whatNodes = request.getParameter("whatNodes");
            this.sorterField = request.getParameter("sorter/field");
            this.sorterOrder = request.getParameter("sorter/order");
            if (this.sorterField == null) {
                this.sorterField = "name";
            }
            if (this.sorterOrder == null) {
                this.sorterOrder = "ASC";
            }
            JspHelper.sortNodeList(live, this.sorterField, this.sorterOrder);
            String port_suffix = null;
            if (live.size() > 0) {
                String name = ((DatanodeDescriptor)live.get(0)).getName();
                int idx = name.indexOf(58);
                if (idx > 0) {
                    port_suffix = name.substring(idx);
                }
                for (i = 1; port_suffix != null && i < live.size(); ++i) {
                    if (((DatanodeDescriptor)live.get(i)).getName().endsWith(port_suffix)) continue;
                    port_suffix = null;
                    break;
                }
            }
            this.counterReset();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (live.isEmpty() && dead.isEmpty()) {
                out.print("There are no datanodes in the cluster");
            } else {
                int i2;
                int nnHttpPort = nn.getHttpAddress().getPort();
                out.print("<div id=\"dfsnodetable\"> ");
                if (this.whatNodes.equals("LIVE")) {
                    out.print("<a name=\"LiveNodes\" id=\"title\">Live Datanodes : " + live.size() + "</a>" + "<br><br>\n<table border=1 cellspacing=0>\n");
                    this.counterReset();
                    if (live.size() > 0) {
                        if (((DatanodeDescriptor)live.get(0)).getCapacity() > 1024L * this.diskBytes) {
                            this.diskBytes *= 1024L;
                            this.diskByteStr = "TB";
                        }
                        out.print("<tr class=\"headerRow\"> <th " + this.nodeHeaderStr("name") + "> Node <th " + this.nodeHeaderStr("lastcontact") + "> Last <br>Contact <th " + this.nodeHeaderStr("adminstate") + "> Admin State <th " + this.nodeHeaderStr("capacity") + "> Configured <br>Capacity (" + this.diskByteStr + ") <th " + this.nodeHeaderStr("used") + "> Used <br>(" + this.diskByteStr + ") <th " + this.nodeHeaderStr("nondfsused") + "> Non DFS <br>Used (" + this.diskByteStr + ") <th " + this.nodeHeaderStr("remaining") + "> Remaining <br>(" + this.diskByteStr + ") <th " + this.nodeHeaderStr("pcused") + "> Used <br>(%) <th " + this.nodeHeaderStr("pcused") + "> Used <br>(%) <th " + this.nodeHeaderStr("pcremaining") + "> Remaining <br>(%) <th " + this.nodeHeaderStr("blocks") + "> Blocks <th " + this.nodeHeaderStr("bpused") + "> Block Pool<br>Used (" + this.diskByteStr + ") <th " + this.nodeHeaderStr("pcbpused") + "> Block Pool<br>Used (%)" + "> Blocks <th " + this.nodeHeaderStr("volfails") + "> Failed Volumes\n");
                        JspHelper.sortNodeList(live, this.sorterField, this.sorterOrder);
                        for (i2 = 0; i2 < live.size(); ++i2) {
                            this.generateNodeData(out, (DatanodeDescriptor)live.get(i2), port_suffix, true, nnHttpPort, nnaddr);
                        }
                    }
                    out.print("</table>\n");
                } else if (this.whatNodes.equals("DEAD")) {
                    out.print("<br> <a name=\"DeadNodes\" id=\"title\">  Dead Datanodes : " + dead.size() + "</a><br><br>\n");
                    if (dead.size() > 0) {
                        out.print("<table border=1 cellspacing=0> <tr id=\"row1\"> <th " + this.nodeHeaderStr("node") + "> Node <th " + this.nodeHeaderStr("decommissioned") + "> Decommissioned\n");
                        JspHelper.sortNodeList(dead, this.sorterField, this.sorterOrder);
                        for (i2 = 0; i2 < dead.size(); ++i2) {
                            this.generateNodeData(out, (DatanodeDescriptor)dead.get(i2), port_suffix, false, nnHttpPort, nnaddr);
                        }
                        out.print("</table>\n");
                    }
                } else if (this.whatNodes.equals("DECOMMISSIONING")) {
                    List<DatanodeDescriptor> decommissioning = dm.getDecommissioningNodes();
                    out.print("<br> <a name=\"DecommissioningNodes\" id=\"title\">  Decommissioning Datanodes : " + decommissioning.size() + "</a><br><br>\n");
                    if (decommissioning.size() > 0) {
                        out.print("<table border=1 cellspacing=0> <tr class=\"headRow\"> <th " + this.nodeHeaderStr("name") + "> Node <th " + this.nodeHeaderStr("lastcontact") + "> Last <br>Contact <th " + this.nodeHeaderStr("underreplicatedblocks") + "> Under Replicated Blocks <th " + this.nodeHeaderStr("blockswithonlydecommissioningreplicas") + "> Blocks With No <br> Live Replicas <th " + this.nodeHeaderStr("underrepblocksinfilesunderconstruction") + "> Under Replicated Blocks <br> In Files Under Construction" + " <th " + this.nodeHeaderStr("timesincedecommissionrequest") + "> Time Since Decommissioning Started");
                        JspHelper.sortNodeList(decommissioning, "name", "ASC");
                        for (i = 0; i < decommissioning.size(); ++i) {
                            this.generateDecommissioningNodeData(out, decommissioning.get(i), port_suffix, true, nnHttpPort, nnaddr);
                        }
                        out.print("</table>\n");
                    }
                }
                out.print("</div>");
            }
        }
    }

    static class HealthJsp {
        private int rowNum = 0;
        private int colNum = 0;
        private String sorterField = null;
        private String sorterOrder = null;

        HealthJsp() {
        }

        private String rowTxt() {
            this.colNum = 0;
            return "<tr class=\"" + (this.rowNum++ % 2 == 0 ? "rowNormal" : "rowAlt") + "\"> ";
        }

        private String colTxt() {
            return "<td id=\"col" + ++this.colNum + "\"> ";
        }

        private String colTxt(String title) {
            return "<td id=\"col" + ++this.colNum + "\" title=\"" + title + "\"> ";
        }

        private void counterReset() {
            this.colNum = 0;
            this.rowNum = 0;
        }

        void generateConfReport(JspWriter out, NameNode nn, HttpServletRequest request) throws IOException {
            FSNamesystem fsn = nn.getNamesystem();
            FSImage fsImage = fsn.getFSImage();
            List<Storage.StorageDirectory> removedStorageDirs = fsImage.getStorage().getRemovedStorageDirs();
            out.print("<h3> " + (Object)((Object)nn.getRole()) + " Storage: </h3>");
            out.print("<div id=\"dfstable\"> <table border=1 cellpadding=10 cellspacing=0 title=\"NameNode Storage\">\n<thead><tr><td><b>Storage Directory</b></td><td><b>Type</b></td><td><b>State</b></td></tr></thead>");
            Storage.StorageDirectory st = null;
            Iterator<Storage.StorageDirectory> it = fsImage.getStorage().dirIterator();
            while (it.hasNext()) {
                st = it.next();
                String dir = "" + st.getRoot();
                String type = "" + st.getStorageDirType();
                out.print("<tr><td>" + dir + "</td><td>" + type + "</td><td>Active</td></tr>");
            }
            long storageDirsSize = removedStorageDirs.size();
            int i = 0;
            while ((long)i < storageDirsSize) {
                st = removedStorageDirs.get(i);
                String dir = "" + st.getRoot();
                String type = "" + st.getStorageDirType();
                out.print("<tr><td>" + dir + "</td><td>" + type + "</td><td><font color=red>Failed</font></td></tr>");
                ++i;
            }
            out.print("</table></div><br>\n");
        }

        void generateHealthReport(JspWriter out, NameNode nn, HttpServletRequest request) throws IOException {
            FSNamesystem fsn = nn.getNamesystem();
            DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
            ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
            ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
            dm.fetchDatanodes(live, dead, true);
            int liveDecommissioned = 0;
            for (DatanodeDescriptor d : live) {
                liveDecommissioned += d.isDecommissioned() ? 1 : 0;
            }
            int deadDecommissioned = 0;
            for (DatanodeDescriptor d : dead) {
                deadDecommissioned += d.isDecommissioned() ? 1 : 0;
            }
            List<DatanodeDescriptor> decommissioning = dm.getDecommissioningNodes();
            this.sorterField = request.getParameter("sorter/field");
            this.sorterOrder = request.getParameter("sorter/order");
            if (this.sorterField == null) {
                this.sorterField = "name";
            }
            if (this.sorterOrder == null) {
                this.sorterOrder = "ASC";
            }
            String port_suffix = null;
            if (live.size() > 0) {
                String name = ((DatanodeDescriptor)live.get(0)).getName();
                int idx = name.indexOf(58);
                if (idx > 0) {
                    port_suffix = name.substring(idx);
                }
                for (int i = 1; port_suffix != null && i < live.size(); ++i) {
                    if (((DatanodeDescriptor)live.get(i)).getName().endsWith(port_suffix)) continue;
                    port_suffix = null;
                    break;
                }
            }
            this.counterReset();
            long[] fsnStats = fsn.getStats();
            long total = fsnStats[0];
            long remaining = fsnStats[2];
            long used = fsnStats[1];
            long nonDFS = total - remaining - used;
            nonDFS = nonDFS < 0L ? 0L : nonDFS;
            float percentUsed = DFSUtil.getPercentUsed(used, total);
            float percentRemaining = DFSUtil.getPercentRemaining(remaining, total);
            float median = 0.0f;
            float max = 0.0f;
            float min = 0.0f;
            float dev = 0.0f;
            if (live.size() > 0) {
                float totalDfsUsed = 0.0f;
                float[] usages = new float[live.size()];
                int i = 0;
                for (DatanodeDescriptor dn : live) {
                    usages[i++] = dn.getDfsUsedPercent();
                    totalDfsUsed += dn.getDfsUsedPercent();
                }
                totalDfsUsed /= (float)live.size();
                Arrays.sort(usages);
                median = usages[usages.length / 2];
                max = usages[usages.length - 1];
                min = usages[0];
                for (i = 0; i < usages.length; ++i) {
                    dev += (usages[i] - totalDfsUsed) * (usages[i] - totalDfsUsed);
                }
                dev = (float)Math.sqrt(dev / (float)usages.length);
            }
            long bpUsed = fsnStats[6];
            float percentBpUsed = DFSUtil.getPercentUsed(bpUsed, total);
            String underReplicatedBlocks = "";
            if (nn.getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
                underReplicatedBlocks = this.rowTxt() + this.colTxt("Excludes missing blocks.") + "Number of Under-Replicated Blocks" + this.colTxt() + ":" + this.colTxt() + fsn.getBlockManager().getUnderReplicatedNotMissingBlocks();
            }
            out.print("<div id=\"dfstable\"> <table>\n" + this.rowTxt() + this.colTxt() + "Configured Capacity" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc((long)total) + this.rowTxt() + this.colTxt() + "DFS Used" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc((long)used) + this.rowTxt() + this.colTxt() + "Non DFS Used" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc((long)nonDFS) + this.rowTxt() + this.colTxt() + "DFS Remaining" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc((long)remaining) + this.rowTxt() + this.colTxt() + "DFS Used%" + this.colTxt() + ":" + this.colTxt() + StringUtils.limitDecimalTo2((double)percentUsed) + " %" + this.rowTxt() + this.colTxt() + "DFS Remaining%" + this.colTxt() + ":" + this.colTxt() + StringUtils.limitDecimalTo2((double)percentRemaining) + " %" + this.rowTxt() + this.colTxt() + "Block Pool Used" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc((long)bpUsed) + this.rowTxt() + this.colTxt() + "Block Pool Used%" + this.colTxt() + ":" + this.colTxt() + StringUtils.limitDecimalTo2((double)percentBpUsed) + " %" + this.rowTxt() + this.colTxt() + "DataNodes usages" + this.colTxt() + ":" + this.colTxt() + "Min %" + this.colTxt() + "Median %" + this.colTxt() + "Max %" + this.colTxt() + "stdev %" + this.rowTxt() + this.colTxt() + this.colTxt() + this.colTxt() + StringUtils.limitDecimalTo2((double)min) + " %" + this.colTxt() + StringUtils.limitDecimalTo2((double)median) + " %" + this.colTxt() + StringUtils.limitDecimalTo2((double)max) + " %" + this.colTxt() + StringUtils.limitDecimalTo2((double)dev) + " %" + this.rowTxt() + this.colTxt() + "<a href=\"dfsnodelist.jsp?whatNodes=LIVE\">Live Nodes</a> " + this.colTxt() + ":" + this.colTxt() + live.size() + " (Decommissioned: " + liveDecommissioned + ")" + this.rowTxt() + this.colTxt() + "<a href=\"dfsnodelist.jsp?whatNodes=DEAD\">Dead Nodes</a> " + this.colTxt() + ":" + this.colTxt() + dead.size() + " (Decommissioned: " + deadDecommissioned + ")" + this.rowTxt() + this.colTxt() + "<a href=\"dfsnodelist.jsp?whatNodes=DECOMMISSIONING\">" + "Decommissioning Nodes</a> " + this.colTxt() + ":" + this.colTxt() + decommissioning.size() + underReplicatedBlocks + "</table></div><br>\n");
            if (live.isEmpty() && dead.isEmpty()) {
                out.print("There are no datanodes in the cluster");
            }
        }
    }
}

