/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FinalizeCommand
extends DatanodeCommand {
    String blockPoolId;

    private FinalizeCommand() {
        super(5);
    }

    public FinalizeCommand(String bpid) {
        super(5);
        this.blockPoolId = bpid;
    }

    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.blockPoolId = WritableUtils.readString((DataInput)in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeString((DataOutput)out, (String)this.blockPoolId);
    }

    static {
        WritableFactories.setFactory(FinalizeCommand.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new FinalizeCommand();
            }
        });
    }
}

