/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HeartbeatResponse
implements Writable {
    private DatanodeCommand[] commands;
    private NNHAStatusHeartbeat haStatus;

    public HeartbeatResponse() {
    }

    public HeartbeatResponse(DatanodeCommand[] cmds, NNHAStatusHeartbeat haStatus) {
        this.commands = cmds;
        this.haStatus = haStatus;
    }

    public DatanodeCommand[] getCommands() {
        return this.commands;
    }

    public NNHAStatusHeartbeat getNameNodeHaState() {
        return this.haStatus;
    }

    public void write(DataOutput out) throws IOException {
        int length = this.commands == null ? 0 : this.commands.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            ObjectWritable.writeObject((DataOutput)out, (Object)this.commands[i], this.commands[i].getClass(), null, (boolean)true);
        }
        this.haStatus.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        this.commands = new DatanodeCommand[length];
        ObjectWritable objectWritable = new ObjectWritable();
        for (int i = 0; i < length; ++i) {
            this.commands[i] = (DatanodeCommand)ObjectWritable.readObject((DataInput)in, (ObjectWritable)objectWritable, null);
        }
        this.haStatus = new NNHAStatusHeartbeat();
        this.haStatus.readFields(in);
    }
}

