/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class LayoutVersion {
    public static final int BUGFIX_HDFS_2991_VERSION = -40;
    static final Map<Integer, EnumSet<Feature>> map = new HashMap<Integer, EnumSet<Feature>>();

    private static void initMap() {
        for (Feature f : Feature.values()) {
            EnumSet<Feature> ancestorSet = map.get(f.ancestorLV);
            if (ancestorSet == null) {
                ancestorSet = EnumSet.noneOf(Feature.class);
                map.put(f.ancestorLV, ancestorSet);
            }
            EnumSet<Feature> featureSet = EnumSet.copyOf(ancestorSet);
            if (f.specialFeatures != null) {
                for (Feature specialFeature : f.specialFeatures) {
                    featureSet.add(specialFeature);
                }
            }
            featureSet.add(f);
            map.put(f.lv, featureSet);
        }
    }

    public static String getString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Feature List:\n");
        for (Feature f : Feature.values()) {
            buf.append((Object)f).append(" introduced in layout version ").append(f.lv).append(" (").append(f.description).append(")\n");
        }
        buf.append("\n\nLayoutVersion and supported features:\n");
        for (Feature f : Feature.values()) {
            buf.append(f.lv).append(": ").append(map.get(f.lv)).append("\n");
        }
        return buf.toString();
    }

    public static boolean supports(Feature f, int lv) {
        EnumSet<Feature> set = map.get(lv);
        return set != null && set.contains((Object)f);
    }

    public static int getCurrentLayoutVersion() {
        Feature[] values = Feature.values();
        for (int i = values.length - 1; i >= 0; --i) {
            if (values[i].isReservedForOldRelease()) continue;
            return values[i].lv;
        }
        throw new AssertionError((Object)"All layout versions are reserved.");
    }

    static {
        LayoutVersion.initMap();
    }

    public static enum Feature {
        NAMESPACE_QUOTA(-16, "Support for namespace quotas"),
        FILE_ACCESS_TIME(-17, "Support for access time on files"),
        DISKSPACE_QUOTA(-18, "Support for disk space quotas"),
        STICKY_BIT(-19, "Support for sticky bits"),
        APPEND_RBW_DIR(-20, "Datanode has \"rbw\" subdirectory for append"),
        ATOMIC_RENAME(-21, "Support for atomic rename"),
        CONCAT(-22, "Support for concat operation"),
        SYMLINKS(-23, "Support for symbolic links"),
        DELEGATION_TOKEN(-24, "Support for delegation tokens for security"),
        FSIMAGE_COMPRESSION(-25, "Support for fsimage compression"),
        FSIMAGE_CHECKSUM(-26, "Support checksum for fsimage"),
        REMOVE_REL13_DISK_LAYOUT_SUPPORT(-27, "Remove support for 0.13 disk layout"),
        EDITS_CHESKUM(-28, "Support checksum for editlog"),
        UNUSED(-29, "Skipped version"),
        FSIMAGE_NAME_OPTIMIZATION(-30, "Store only last part of path in fsimage"),
        RESERVED_REL20_203(-31, -19, "Reserved for release 0.20.203", true, DELEGATION_TOKEN),
        RESERVED_REL20_204(-32, -31, "Reserved for release 0.20.204", true, new Feature[0]),
        RESERVED_REL22(-33, -27, "Reserved for release 0.22", true, new Feature[0]),
        RESERVED_REL23(-34, -30, "Reserved for release 0.23", true, new Feature[0]),
        FEDERATION(-35, "Support for namenode federation"),
        LEASE_REASSIGNMENT(-36, "Support for persisting lease holder reassignment"),
        STORED_TXIDS(-37, "Transaction IDs are stored in edits log and image files"),
        TXID_BASED_LAYOUT(-38, "File names in NN Storage are based on transaction IDs"),
        EDITLOG_OP_OPTIMIZATION(-39, "Use LongWritable and ShortWritable directly instead of ArrayWritable of UTF8"),
        OPTIMIZE_PERSIST_BLOCKS(-40, "Serialize block lists with delta-encoded variable length ints, add OP_UPDATE_BLOCKS"),
        RESERVED_REL1_2_0(-41, -32, "Reserved for release 1.2.0", true, CONCAT),
        ADD_INODE_ID(-42, -40, "Assign a unique inode id for each inode", false, new Feature[0]),
        SNAPSHOT(-43, "Support for snapshot feature");

        final int lv;
        final int ancestorLV;
        final String description;
        final boolean reserved;
        final Feature[] specialFeatures;

        private Feature(int lv, String description) {
            this(lv, lv + 1, description, false, new Feature[0]);
        }

        private Feature(int lv, int ancestorLV, String description, boolean reserved, Feature ... features) {
            this.lv = lv;
            this.ancestorLV = ancestorLV;
            this.description = description;
            this.reserved = reserved;
            this.specialFeatures = features;
        }

        public int getLayoutVersion() {
            return this.lv;
        }

        public int getAncestorLayoutVersion() {
            return this.ancestorLV;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isReservedForOldRelease() {
            return this.reserved;
        }
    }
}

