/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.NetworkTopologyWithNodeGroup;
import org.apache.hadoop.net.Node;

public class BlockPlacementPolicyWithNodeGroup
extends BlockPlacementPolicyDefault {
    BlockPlacementPolicyWithNodeGroup(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        this.initialize(conf, stats, clusterMap);
    }

    BlockPlacementPolicyWithNodeGroup() {
    }

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        super.initialize(conf, stats, clusterMap);
    }

    @Override
    protected DatanodeDescriptor chooseLocalNode(DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
        Node oldNode = excludedNodes.put(localMachine, localMachine);
        if (oldNode == null && this.isGoodTarget(localMachine, blocksize, maxNodesPerRack, false, results, avoidStaleNodes)) {
            results.add(localMachine);
            this.addNodeGroupToExcludedNodes(excludedNodes, localMachine.getNetworkLocation());
            return localMachine;
        }
        DatanodeDescriptor chosenNode = this.chooseLocalNodeGroup((NetworkTopologyWithNodeGroup)this.clusterMap, localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        if (chosenNode != null) {
            return chosenNode;
        }
        return this.chooseLocalRack(localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
    }

    @Override
    protected void adjustExcludedNodes(HashMap<Node, Node> excludedNodes, Node chosenNode) {
        this.addNodeGroupToExcludedNodes(excludedNodes, chosenNode.getNetworkLocation());
    }

    private void addNodeGroupToExcludedNodes(HashMap<Node, Node> excludedNodes, String nodeGroup) {
        List leafNodes = this.clusterMap.getLeaves(nodeGroup);
        for (Node node : leafNodes) {
            excludedNodes.put(node, node);
        }
    }

    @Override
    protected DatanodeDescriptor chooseLocalRack(DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
        try {
            return this.chooseRandom(NetworkTopology.getFirstHalf((String)localMachine.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e1) {
            DatanodeInfo newLocal = null;
            for (DatanodeDescriptor nextNode : results) {
                if (nextNode == localMachine) continue;
                newLocal = nextNode;
                break;
            }
            if (newLocal != null) {
                try {
                    return this.chooseRandom(this.clusterMap.getRack(newLocal.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e2) {
                    return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                }
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
    }

    @Override
    protected void chooseRemoteRack(int numOfReplicas, DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxReplicasPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int oldNumOfReplicas = results.size();
        try {
            this.chooseRandom(numOfReplicas, "~" + NetworkTopology.getFirstHalf((String)localMachine.getNetworkLocation()), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            this.chooseRandom(numOfReplicas - (results.size() - oldNumOfReplicas), localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes);
        }
    }

    private DatanodeDescriptor chooseLocalNodeGroup(NetworkTopologyWithNodeGroup clusterMap, DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
        try {
            return this.chooseRandom(clusterMap.getNodeGroup(localMachine.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e1) {
            DatanodeInfo newLocal = null;
            for (DatanodeDescriptor nextNode : results) {
                if (nextNode == localMachine) continue;
                newLocal = nextNode;
                break;
            }
            if (newLocal != null) {
                try {
                    return this.chooseRandom(clusterMap.getNodeGroup(newLocal.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e2) {
                    return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                }
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
    }

    @Override
    protected String getRack(DatanodeInfo cur) {
        String nodeGroupString = cur.getNetworkLocation();
        return NetworkTopology.getFirstHalf((String)nodeGroupString);
    }

    @Override
    protected int addToExcludedNodes(DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes) {
        int countOfExcludedNodes = 0;
        String nodeGroupScope = localMachine.getNetworkLocation();
        List leafNodes = this.clusterMap.getLeaves(nodeGroupScope);
        for (Node leafNode : leafNodes) {
            Node node = excludedNodes.put(leafNode, leafNode);
            if (node != null) continue;
            ++countOfExcludedNodes;
        }
        return countOfExcludedNodes;
    }

    @Override
    public Iterator<DatanodeDescriptor> pickupReplicaSet(Collection<DatanodeDescriptor> first, Collection<DatanodeDescriptor> second) {
        if (first.isEmpty()) {
            return second.iterator();
        }
        HashMap nodeGroupMap = new HashMap();
        for (DatanodeDescriptor node : first) {
            String nodeGroupName = NetworkTopology.getLastHalf((String)node.getNetworkLocation());
            List datanodeList = (ArrayList<DatanodeDescriptor>)nodeGroupMap.get(nodeGroupName);
            if (datanodeList == null) {
                datanodeList = new ArrayList<DatanodeDescriptor>();
                nodeGroupMap.put(nodeGroupName, datanodeList);
            }
            datanodeList.add(node);
        }
        ArrayList moreThanOne = new ArrayList();
        ArrayList exactlyOne = new ArrayList();
        for (List datanodeList : nodeGroupMap.values()) {
            if (datanodeList.size() == 1) {
                exactlyOne.add(datanodeList.get(0));
                continue;
            }
            moreThanOne.addAll(datanodeList);
        }
        Iterator<DatanodeDescriptor> iter = moreThanOne.isEmpty() ? exactlyOne.iterator() : moreThanOne.iterator();
        return iter;
    }
}

