/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.net.DomainPeerServer;
import org.apache.hadoop.hdfs.net.TcpPeerServer;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferEncryptor;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.InterDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockPoolTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolManager;
import org.apache.hadoop.hdfs.server.datanode.BlockSender;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataBlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNodeMXBean;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.datanode.web.resources.DatanodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.namenode.FileChecksumServlets;
import org.apache.hadoop.hdfs.server.namenode.StreamFile;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.mortbay.util.ajax.JSON;

@InterfaceAudience.Private
public class DataNode
extends Configured
implements InterDatanodeProtocol,
ClientDatanodeProtocol,
DataNodeMXBean {
    public static final Log LOG = LogFactory.getLog(DataNode.class);
    public static final String DN_CLIENTTRACE_FORMAT = "src: %s, dest: %s, bytes: %s, op: %s, cliID: %s, offset: %s, srvID: %s, blockid: %s, duration: %s";
    static final Log ClientTraceLog;
    private static final String USAGE = "Usage: java DataNode [-rollback | -regular]";
    static final int CURRENT_BLOCK_FORMAT_VERSION = 1;
    volatile boolean shouldRun = true;
    private BlockPoolManager blockPoolManager;
    volatile FsDatasetSpi<? extends FsVolumeSpi> data = null;
    private String clusterId = null;
    public static final String EMPTY_DEL_HINT = "";
    AtomicInteger xmitsInProgress = new AtomicInteger();
    Daemon dataXceiverServer = null;
    Daemon localDataXceiverServer = null;
    ThreadGroup threadGroup = null;
    private DNConf dnConf;
    private volatile boolean heartbeatsDisabledForTests = false;
    private DataStorage storage = null;
    private HttpServer infoServer = null;
    DataNodeMetrics metrics;
    private InetSocketAddress streamingAddr;
    private String hostName;
    private DatanodeID id;
    private final String fileDescriptorPassingDisabledReason;
    boolean isBlockTokenEnabled;
    BlockPoolTokenSecretManager blockPoolTokenSecretManager;
    private boolean hasAnyBlockPoolRegistered = false;
    volatile DataBlockScanner blockScanner = null;
    private DirectoryScanner directoryScanner = null;
    private List<ServicePlugin> plugins;
    public RPC.Server ipcServer;
    private SecureDataNodeStarter.SecureResources secureResources = null;
    private AbstractList<File> dataDirs;
    private Configuration conf;
    private final List<String> usersWithLocalPathAccess;
    private boolean connectToDnViaHostname;
    ReadaheadPool readaheadPool;
    private final boolean getHdfsBlockLocationsEnabled;

    @Deprecated
    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr((String)target);
    }

    DataNode(Configuration conf, AbstractList<File> dataDirs) throws IOException {
        this(conf, dataDirs, null);
    }

    DataNode(Configuration conf, AbstractList<File> dataDirs, SecureDataNodeStarter.SecureResources resources) throws IOException {
        super(conf);
        this.usersWithLocalPathAccess = Arrays.asList(conf.getTrimmedStrings("dfs.block.local-path-access.user"));
        this.connectToDnViaHostname = conf.getBoolean("dfs.datanode.use.datanode.hostname", false);
        this.getHdfsBlockLocationsEnabled = conf.getBoolean("dfs.datanode.hdfs-blocks-metadata.enabled", false);
        if (conf.getBoolean("dfs.client.read.shortcircuit", false)) {
            String reason = DomainSocket.getLoadingFailureReason();
            if (reason != null) {
                LOG.warn((Object)("File descriptor passing is disabled because " + reason));
                this.fileDescriptorPassingDisabledReason = reason;
            } else {
                LOG.info((Object)"File descriptor passing is enabled.");
                this.fileDescriptorPassingDisabledReason = null;
            }
        } else {
            this.fileDescriptorPassingDisabledReason = "File descriptor passing was not configured.";
            LOG.debug((Object)this.fileDescriptorPassingDisabledReason);
        }
        try {
            this.hostName = DataNode.getHostName(conf);
            LOG.info((Object)("Configured hostname is " + this.hostName));
            this.startDataNode(conf, dataDirs, resources);
        }
        catch (IOException ie) {
            this.shutdown();
            throw ie;
        }
    }

    private synchronized void setClusterId(String nsCid, String bpid) throws IOException {
        if (this.clusterId != null && !this.clusterId.equals(nsCid)) {
            throw new IOException("Cluster IDs not matched: dn cid=" + this.clusterId + " but ns cid=" + nsCid + "; bpid=" + bpid);
        }
        this.clusterId = nsCid;
    }

    private static String getHostName(Configuration config) throws UnknownHostException {
        String name = config.get("dfs.datanode.hostname");
        if (name == null) {
            name = DNS.getDefaultHost((String)config.get("dfs.datanode.dns.interface", "default"), (String)config.get("dfs.datanode.dns.nameserver", "default"));
        }
        return name;
    }

    private void startInfoServer(Configuration conf) throws IOException {
        InetSocketAddress infoSocAddr = DataNode.getInfoAddr(conf);
        String infoHost = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.infoServer = this.secureResources == null ? new HttpServer("datanode", infoHost, tmpInfoPort, tmpInfoPort == 0, conf, new AccessControlList(conf.get("dfs.cluster.administrators", " "))) : new HttpServer("datanode", infoHost, tmpInfoPort, tmpInfoPort == 0, conf, new AccessControlList(conf.get("dfs.cluster.administrators", " ")), this.secureResources.getListener());
        LOG.info((Object)("Opened info server at " + infoHost + ":" + tmpInfoPort));
        if (conf.getBoolean("dfs.https.enable", false)) {
            boolean needClientAuth = conf.getBoolean("dfs.client.https.need-auth", false);
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr((String)conf.get("dfs.datanode.https.address", infoHost + ":" + 0));
            HdfsConfiguration sslConf = new HdfsConfiguration(false);
            sslConf.addResource(conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
            this.infoServer.addSslListener(secInfoSocAddr, (Configuration)sslConf, needClientAuth);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Datanode listening for SSL on " + secInfoSocAddr));
            }
        }
        this.infoServer.addInternalServlet(null, "/streamFile/*", StreamFile.class);
        this.infoServer.addInternalServlet(null, "/getFileChecksum/*", FileChecksumServlets.GetServlet.class);
        this.infoServer.setAttribute("datanode", (Object)this);
        this.infoServer.setAttribute("current.conf", (Object)conf);
        this.infoServer.addServlet(null, "/blockScannerReport", DataBlockScanner.Servlet.class);
        if (WebHdfsFileSystem.isEnabled(conf, LOG)) {
            this.infoServer.addJerseyResourcePackage(DatanodeWebHdfsMethods.class.getPackage().getName() + ";" + Param.class.getPackage().getName(), "/webhdfs/v1/*");
        }
        this.infoServer.start();
    }

    private void startPlugins(Configuration conf) {
        this.plugins = conf.getInstances("dfs.datanode.plugins", ServicePlugin.class);
        for (ServicePlugin p : this.plugins) {
            try {
                p.start((Object)this);
                LOG.info((Object)("Started plug-in " + p));
            }
            catch (Throwable t) {
                LOG.warn((Object)("ServicePlugin " + p + " could not be started"), t);
            }
        }
    }

    private void initIpcServer(Configuration conf) throws IOException {
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr((String)conf.get("dfs.datanode.ipc.address"));
        RPC.setProtocolEngine((Configuration)conf, ClientDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientDatanodeProtocolServerSideTranslatorPB clientDatanodeProtocolXlator = new ClientDatanodeProtocolServerSideTranslatorPB(this);
        BlockingService service = ClientDatanodeProtocolProtos.ClientDatanodeProtocolService.newReflectiveBlockingService(clientDatanodeProtocolXlator);
        this.ipcServer = new RPC.Builder(conf).setProtocol(ClientDatanodeProtocolPB.class).setInstance((Object)service).setBindAddress(ipcAddr.getHostName()).setPort(ipcAddr.getPort()).setNumHandlers(conf.getInt("dfs.datanode.handler.count", 10)).setVerbose(false).setSecretManager((SecretManager)this.blockPoolTokenSecretManager).build();
        InterDatanodeProtocolServerSideTranslatorPB interDatanodeProtocolXlator = new InterDatanodeProtocolServerSideTranslatorPB(this);
        service = InterDatanodeProtocolProtos.InterDatanodeProtocolService.newReflectiveBlockingService(interDatanodeProtocolXlator);
        DFSUtil.addPBProtocol(conf, InterDatanodeProtocolPB.class, service, this.ipcServer);
        LOG.info((Object)("Opened IPC server at " + this.ipcServer.getListenerAddress()));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.ipcServer.refreshServiceAcl(conf, (PolicyProvider)new HDFSPolicyProvider());
        }
    }

    private void initPeriodicScanners(Configuration conf) {
        this.initDataBlockScanner(conf);
        this.initDirectoryScanner(conf);
    }

    private void shutdownPeriodicScanners() {
        this.shutdownDirectoryScanner();
        this.shutdownDataBlockScanner();
    }

    private synchronized void initDataBlockScanner(Configuration conf) {
        if (this.blockScanner != null) {
            return;
        }
        String reason = null;
        assert (this.data != null);
        if (conf.getInt("dfs.datanode.scan.period.hours", 0) < 0) {
            reason = "verification is turned off by configuration";
        } else if ("SimulatedFSDataset".equals(this.data.getClass().getSimpleName())) {
            reason = "verifcation is not supported by SimulatedFSDataset";
        }
        if (reason == null) {
            this.blockScanner = new DataBlockScanner(this, this.data, conf);
            this.blockScanner.start();
        } else {
            LOG.info((Object)("Periodic Block Verification scan disabled because " + reason));
        }
    }

    private void shutdownDataBlockScanner() {
        if (this.blockScanner != null) {
            this.blockScanner.shutdown();
        }
    }

    private synchronized void initDirectoryScanner(Configuration conf) {
        if (this.directoryScanner != null) {
            return;
        }
        String reason = null;
        if (conf.getInt("dfs.datanode.directoryscan.interval", 21600) < 0) {
            reason = "verification is turned off by configuration";
        } else if ("SimulatedFSDataset".equals(this.data.getClass().getSimpleName())) {
            reason = "verifcation is not supported by SimulatedFSDataset";
        }
        if (reason == null) {
            this.directoryScanner = new DirectoryScanner(this.data, conf);
            this.directoryScanner.start();
        } else {
            LOG.info((Object)("Periodic Directory Tree Verification scan is disabled because " + reason));
        }
    }

    private synchronized void shutdownDirectoryScanner() {
        if (this.directoryScanner != null) {
            this.directoryScanner.shutdown();
        }
    }

    private void initDataXceiver(Configuration conf) throws IOException {
        DomainPeerServer domainPeerServer;
        TcpPeerServer tcpPeerServer = this.secureResources != null ? new TcpPeerServer(this.secureResources) : new TcpPeerServer(this.dnConf.socketWriteTimeout, DataNode.getStreamingAddr(conf));
        tcpPeerServer.setReceiveBufferSize(131072);
        this.streamingAddr = tcpPeerServer.getStreamingAddr();
        LOG.info((Object)("Opened streaming server at " + this.streamingAddr));
        this.threadGroup = new ThreadGroup("dataXceiverServer");
        this.dataXceiverServer = new Daemon(this.threadGroup, (Runnable)new DataXceiverServer(tcpPeerServer, conf, this));
        this.threadGroup.setDaemon(true);
        if ((conf.getBoolean("dfs.client.read.shortcircuit", false) || conf.getBoolean("dfs.client.domain.socket.data.traffic", false)) && (domainPeerServer = DataNode.getDomainPeerServer(conf, this.streamingAddr.getPort())) != null) {
            this.localDataXceiverServer = new Daemon(this.threadGroup, (Runnable)new DataXceiverServer(domainPeerServer, conf, this));
            LOG.info((Object)("Listening on UNIX domain socket: " + domainPeerServer.getBindPath()));
        }
    }

    static DomainPeerServer getDomainPeerServer(Configuration conf, int port) throws IOException {
        String domainSocketPath = conf.getTrimmed("dfs.domain.socket.path", EMPTY_DEL_HINT);
        if (domainSocketPath.isEmpty()) {
            if (conf.getBoolean("dfs.client.read.shortcircuit", false) && !conf.getBoolean("dfs.client.use.legacy.blockreader.local", false)) {
                LOG.warn((Object)"Although short-circuit local reads are configured, they are disabled because you didn't configure dfs.domain.socket.path");
            }
            return null;
        }
        if (DomainSocket.getLoadingFailureReason() != null) {
            throw new RuntimeException("Although a UNIX domain socket path is configured as " + domainSocketPath + ", we cannot " + "start a localDataXceiverServer because " + DomainSocket.getLoadingFailureReason());
        }
        DomainPeerServer domainPeerServer = new DomainPeerServer(domainSocketPath, port);
        domainPeerServer.setReceiveBufferSize(131072);
        return domainPeerServer;
    }

    protected void notifyNamenodeReceivedBlock(ExtendedBlock block, String delHint) {
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeReceivedBlock(block, delHint);
        } else {
            LOG.error((Object)("Cannot find BPOfferService for reporting block received for bpid=" + block.getBlockPoolId()));
        }
    }

    protected void notifyNamenodeReceivingBlock(ExtendedBlock block) {
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeReceivingBlock(block);
        } else {
            LOG.error((Object)("Cannot find BPOfferService for reporting block receiving for bpid=" + block.getBlockPoolId()));
        }
    }

    public void notifyNamenodeDeletedBlock(ExtendedBlock block) {
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeDeletedBlock(block);
        } else {
            LOG.error((Object)("Cannot find BPOfferService for reporting block deleted for bpid=" + block.getBlockPoolId()));
        }
    }

    public void reportBadBlocks(ExtendedBlock block) throws IOException {
        BPOfferService bpos = this.getBPOSForBlock(block);
        bpos.reportBadBlocks(block);
    }

    public void reportRemoteBadBlock(DatanodeInfo srcDataNode, ExtendedBlock block) throws IOException {
        BPOfferService bpos = this.getBPOSForBlock(block);
        bpos.reportRemoteBadBlock(srcDataNode, block);
    }

    void trySendErrorReport(String bpid, int errCode, String errMsg) {
        BPOfferService bpos = this.blockPoolManager.get(bpid);
        if (bpos == null) {
            throw new IllegalArgumentException("Bad block pool: " + bpid);
        }
        bpos.trySendErrorReport(errCode, errMsg);
    }

    private BPOfferService getBPOSForBlock(ExtendedBlock block) throws IOException {
        Preconditions.checkNotNull((Object)block);
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos == null) {
            throw new IOException("cannot locate OfferService thread for bp=" + block.getBlockPoolId());
        }
        return bpos;
    }

    void setHeartbeatsDisabledForTests(boolean heartbeatsDisabledForTests) {
        this.heartbeatsDisabledForTests = heartbeatsDisabledForTests;
    }

    boolean areHeartbeatsDisabledForTests() {
        return this.heartbeatsDisabledForTests;
    }

    void startDataNode(Configuration conf, AbstractList<File> dataDirs, SecureDataNodeStarter.SecureResources resources) throws IOException {
        if (UserGroupInformation.isSecurityEnabled() && resources == null && !conf.getBoolean("ignore.secure.ports.for.testing", false)) {
            throw new RuntimeException("Cannot start secure cluster without privileged resources.");
        }
        this.secureResources = resources;
        this.dataDirs = dataDirs;
        this.conf = conf;
        this.dnConf = new DNConf(conf);
        this.storage = new DataStorage();
        this.registerMXBean();
        this.initDataXceiver(conf);
        this.startInfoServer(conf);
        this.blockPoolTokenSecretManager = new BlockPoolTokenSecretManager();
        this.initIpcServer(conf);
        this.metrics = DataNodeMetrics.create(conf, this.getDisplayName());
        this.blockPoolManager = new BlockPoolManager(this);
        this.blockPoolManager.refreshNamenodes(conf);
        this.readaheadPool = ReadaheadPool.getInstance();
    }

    DatanodeRegistration createBPRegistration(NamespaceInfo nsInfo) {
        StorageInfo storageInfo = this.storage.getBPStorage(nsInfo.getBlockPoolID());
        if (storageInfo == null) {
            storageInfo = new StorageInfo(nsInfo);
        }
        DatanodeID dnId = new DatanodeID(this.streamingAddr.getAddress().getHostAddress(), this.hostName, this.getStorageId(), this.getXferPort(), this.getInfoPort(), this.getIpcPort());
        return new DatanodeRegistration(dnId, storageInfo, new ExportedBlockKeys(), VersionInfo.getVersion());
    }

    synchronized void bpRegistrationSucceeded(DatanodeRegistration bpRegistration, String blockPoolId) throws IOException {
        if (null == this.id) {
            this.id = bpRegistration;
        }
        if (this.storage.getStorageID().equals(EMPTY_DEL_HINT)) {
            this.storage.setStorageID(bpRegistration.getStorageID());
            this.storage.writeAll();
            LOG.info((Object)("New storage id " + bpRegistration.getStorageID() + " is assigned to data-node " + bpRegistration));
        } else if (!this.storage.getStorageID().equals(bpRegistration.getStorageID())) {
            throw new IOException("Inconsistent storage IDs. Name-node returned " + bpRegistration.getStorageID() + ". Expecting " + this.storage.getStorageID());
        }
        this.registerBlockPoolWithSecretManager(bpRegistration, blockPoolId);
    }

    private synchronized void registerBlockPoolWithSecretManager(DatanodeRegistration bpRegistration, String blockPoolId) throws IOException {
        ExportedBlockKeys keys = bpRegistration.getExportedKeys();
        if (!this.hasAnyBlockPoolRegistered) {
            this.hasAnyBlockPoolRegistered = true;
            this.isBlockTokenEnabled = keys.isBlockTokenEnabled();
        } else if (this.isBlockTokenEnabled != keys.isBlockTokenEnabled()) {
            throw new RuntimeException("Inconsistent configuration of block access tokens. Either all block pools must be configured to use block tokens, or none may be.");
        }
        if (!this.isBlockTokenEnabled) {
            return;
        }
        if (!this.blockPoolTokenSecretManager.isBlockPoolRegistered(blockPoolId)) {
            long blockKeyUpdateInterval = keys.getKeyUpdateInterval();
            long blockTokenLifetime = keys.getTokenLifetime();
            LOG.info((Object)("Block token params received from NN: for block pool " + blockPoolId + " keyUpdateInterval=" + blockKeyUpdateInterval / 60000L + " min(s), tokenLifetime=" + blockTokenLifetime / 60000L + " min(s)"));
            BlockTokenSecretManager secretMgr = new BlockTokenSecretManager(0L, blockTokenLifetime, blockPoolId, this.dnConf.encryptionAlgorithm);
            this.blockPoolTokenSecretManager.addBlockPool(blockPoolId, secretMgr);
        }
    }

    void shutdownBlockPool(BPOfferService bpos) {
        this.blockPoolManager.remove(bpos);
        String bpId = bpos.getBlockPoolId();
        if (this.blockScanner != null) {
            this.blockScanner.removeBlockPool(bpId);
        }
        if (this.data != null) {
            this.data.shutdownBlockPool(bpId);
        }
        if (this.storage != null) {
            this.storage.removeBlockPoolStorage(bpId);
        }
    }

    void initBlockPool(BPOfferService bpos) throws IOException {
        NamespaceInfo nsInfo = bpos.getNamespaceInfo();
        if (nsInfo == null) {
            throw new IOException("NamespaceInfo not found: Block pool " + bpos + " should have retrieved namespace info before initBlockPool.");
        }
        this.blockPoolManager.addBlockPool(bpos);
        this.setClusterId(nsInfo.clusterID, nsInfo.getBlockPoolID());
        this.initStorage(nsInfo);
        this.initPeriodicScanners(this.conf);
        this.data.addBlockPool(nsInfo.getBlockPoolID(), this.conf);
    }

    BPOfferService[] getAllBpOs() {
        return this.blockPoolManager.getAllNamenodeThreads();
    }

    int getBpOsCount() {
        return this.blockPoolManager.getAllNamenodeThreads().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStorage(NamespaceInfo nsInfo) throws IOException {
        FsDatasetSpi.Factory<?> factory = FsDatasetSpi.Factory.getFactory(this.conf);
        if (!factory.isSimulated()) {
            HdfsServerConstants.StartupOption startOpt = DataNode.getStartupOption(this.conf);
            if (startOpt == null) {
                throw new IOException("Startup option not set.");
            }
            String bpid = nsInfo.getBlockPoolID();
            this.storage.recoverTransitionRead(this, bpid, nsInfo, this.dataDirs, startOpt);
            StorageInfo bpStorage = this.storage.getBPStorage(bpid);
            LOG.info((Object)("Setting up storage: nsid=" + bpStorage.getNamespaceID() + ";bpid=" + bpid + ";lv=" + this.storage.getLayoutVersion() + ";nsInfo=" + nsInfo));
        }
        DataNode dataNode = this;
        synchronized (dataNode) {
            if (this.data == null) {
                this.data = factory.newInstance(this, this.storage, this.conf);
            }
        }
    }

    public static InetSocketAddress getInfoAddr(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.get("dfs.datanode.http.address", "0.0.0.0:50075"));
    }

    private void registerMXBean() {
        MBeans.register((String)"DataNode", (String)"DataNodeInfo", (Object)this);
    }

    @VisibleForTesting
    public int getXferPort() {
        return this.streamingAddr.getPort();
    }

    String getStorageId() {
        return this.storage.getStorageID();
    }

    public String getDisplayName() {
        return this.hostName + ":" + this.getXferPort();
    }

    public InetSocketAddress getXferAddress() {
        return this.streamingAddr;
    }

    public int getIpcPort() {
        return this.ipcServer.getListenerAddress().getPort();
    }

    @VisibleForTesting
    public DatanodeRegistration getDNRegistrationForBP(String bpid) throws IOException {
        BPOfferService bpos = this.blockPoolManager.get(bpid);
        if (bpos == null || bpos.bpRegistration == null) {
            throw new IOException("cannot find BPOfferService for bpid=" + bpid);
        }
        return bpos.bpRegistration;
    }

    protected Socket newSocket() throws IOException {
        return this.dnConf.socketWriteTimeout > 0 ? SocketChannel.open().socket() : new Socket();
    }

    DatanodeProtocolClientSideTranslatorPB connectToNN(InetSocketAddress nnAddr) throws IOException {
        return new DatanodeProtocolClientSideTranslatorPB(nnAddr, this.conf);
    }

    public static InterDatanodeProtocol createInterDataNodeProtocolProxy(DatanodeID datanodeid, final Configuration conf, final int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        final InetSocketAddress addr = NetUtils.createSocketAddr((String)dnAddr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to datanode " + dnAddr + " addr=" + addr));
        }
        final UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        try {
            return (InterDatanodeProtocol)loginUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<InterDatanodeProtocol>(){

                @Override
                public InterDatanodeProtocol run() throws IOException {
                    return new InterDatanodeProtocolTranslatorPB(addr, loginUgi, conf, NetUtils.getDefaultSocketFactory((Configuration)conf), socketTimeout);
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.getMessage());
        }
    }

    DataNodeMetrics getMetrics() {
        return this.metrics;
    }

    public static void setNewStorageID(DatanodeID dnId) {
        LOG.info((Object)("Datanode is " + dnId));
        dnId.setStorageID(DataNode.createNewStorageId(dnId.getXferPort()));
    }

    static String createNewStorageId(int port) {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP((String)"default");
        }
        catch (UnknownHostException ignored) {
            LOG.warn((Object)"Could not find an IP address for the \"default\" inteface.");
        }
        int rand = DFSUtil.getSecureRandom().nextInt(Integer.MAX_VALUE);
        return "DS-" + rand + "-" + ip + "-" + port + "-" + Time.now();
    }

    private void checkKerberosAuthMethod(String msg) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (UserGroupInformation.getCurrentUser().getAuthenticationMethod() != UserGroupInformation.AuthenticationMethod.KERBEROS) {
            throw new AccessControlException("Error in " + msg + "Only kerberos based authentication is allowed.");
        }
    }

    private void checkBlockLocalPathAccess() throws IOException {
        this.checkKerberosAuthMethod("getBlockLocalPathInfo()");
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (!this.usersWithLocalPathAccess.contains(currentUser)) {
            throw new AccessControlException("Can't continue with getBlockLocalPathInfo() authorization. The user " + currentUser + " is not allowed to call getBlockLocalPathInfo");
        }
    }

    @Override
    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block, Token<BlockTokenIdentifier> token) throws IOException {
        this.checkBlockLocalPathAccess();
        this.checkBlockToken(block, token, BlockTokenSecretManager.AccessMode.READ);
        BlockLocalPathInfo info = this.data.getBlockLocalPathInfo(block);
        if (LOG.isDebugEnabled()) {
            if (info != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("getBlockLocalPathInfo successful block=" + block + " blockfile " + info.getBlockPath() + " metafile " + info.getMetaPath()));
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("getBlockLocalPathInfo for block=" + block + " returning null"));
            }
        }
        this.metrics.incrBlocksGetLocalPathInfo();
        return info;
    }

    FileInputStream[] requestShortCircuitFdsForRead(ExtendedBlock blk, Token<BlockTokenIdentifier> token, int maxVersion) throws ShortCircuitFdsUnsupportedException, ShortCircuitFdsVersionException, IOException {
        if (this.fileDescriptorPassingDisabledReason != null) {
            throw new ShortCircuitFdsUnsupportedException(this.fileDescriptorPassingDisabledReason);
        }
        this.checkBlockToken(blk, token, BlockTokenSecretManager.AccessMode.READ);
        int blkVersion = 1;
        if (maxVersion < blkVersion) {
            throw new ShortCircuitFdsVersionException("Your client is too old to read this block!  Its format version is " + blkVersion + ", but the highest format version you can read is " + maxVersion);
        }
        this.metrics.incrBlocksGetLocalPathInfo();
        FileInputStream[] fis = new FileInputStream[2];
        try {
            fis[0] = (FileInputStream)this.data.getBlockInputStream(blk, 0L);
            fis[1] = (FileInputStream)this.data.getMetaDataInputStream(blk).getWrappedStream();
        }
        catch (ClassCastException e) {
            LOG.debug((Object)"requestShortCircuitFdsForRead failed", (Throwable)e);
            throw new ShortCircuitFdsUnsupportedException("This DataNode's FsDatasetSpi does not support short-circuit local reads");
        }
        return fis;
    }

    @Override
    public HdfsBlocksMetadata getHdfsBlocksMetadata(List<ExtendedBlock> blocks, List<Token<BlockTokenIdentifier>> tokens) throws IOException, UnsupportedOperationException {
        if (!this.getHdfsBlockLocationsEnabled) {
            throw new UnsupportedOperationException("Datanode#getHdfsBlocksMetadata  is not enabled in datanode config");
        }
        if (blocks.size() != tokens.size()) {
            throw new IOException("Differing number of blocks and tokens");
        }
        for (int i = 0; i < blocks.size(); ++i) {
            this.checkBlockToken(blocks.get(i), tokens.get(i), BlockTokenSecretManager.AccessMode.READ);
        }
        return this.data.getHdfsBlocksMetadata(blocks);
    }

    private void checkBlockToken(ExtendedBlock block, Token<BlockTokenIdentifier> token, BlockTokenSecretManager.AccessMode accessMode) throws IOException {
        if (this.isBlockTokenEnabled && UserGroupInformation.isSecurityEnabled()) {
            BlockTokenIdentifier id = new BlockTokenIdentifier();
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            id.readFields(in);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Got: " + id.toString()));
            }
            this.blockPoolTokenSecretManager.checkAccess(id, null, block, accessMode);
        }
    }

    public void shutdown() {
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                    LOG.info((Object)("Stopped plug-in " + p));
                }
                catch (Throwable t) {
                    LOG.warn((Object)("ServicePlugin " + p + " could not be stopped"), t);
                }
            }
        }
        BPOfferService[] bposArray = this.blockPoolManager == null ? null : this.blockPoolManager.getAllNamenodeThreads();
        this.shouldRun = false;
        this.shutdownPeriodicScanners();
        if (this.infoServer != null) {
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception shutting down DataNode", (Throwable)e);
            }
        }
        if (this.ipcServer != null) {
            this.ipcServer.stop();
        }
        if (this.dataXceiverServer != null) {
            ((DataXceiverServer)this.dataXceiverServer.getRunnable()).kill();
            this.dataXceiverServer.interrupt();
        }
        if (this.localDataXceiverServer != null) {
            ((DataXceiverServer)this.localDataXceiverServer.getRunnable()).kill();
            this.localDataXceiverServer.interrupt();
        }
        if (this.threadGroup != null) {
            int sleepMs = 2;
            while (true) {
                this.threadGroup.interrupt();
                LOG.info((Object)("Waiting for threadgroup to exit, active threads is " + this.threadGroup.activeCount()));
                if (this.threadGroup.activeCount() == 0) break;
                try {
                    Thread.sleep(sleepMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((sleepMs = sleepMs * 3 / 2) <= 1000) continue;
                sleepMs = 1000;
            }
            this.threadGroup = null;
        }
        if (this.dataXceiverServer != null) {
            try {
                this.dataXceiverServer.join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (this.localDataXceiverServer != null) {
            try {
                this.localDataXceiverServer.join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (this.blockPoolManager != null) {
            try {
                this.blockPoolManager.shutDownAll(bposArray);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"Received exception in BlockPoolManager#shutDownAll: ", (Throwable)ie);
            }
        }
        if (this.storage != null) {
            try {
                this.storage.unlockAll();
            }
            catch (IOException ie) {
                LOG.warn((Object)("Exception when unlocking storage: " + ie), (Throwable)ie);
            }
        }
        if (this.data != null) {
            this.data.shutdown();
        }
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    protected void checkDiskError(Exception e) throws IOException {
        LOG.warn((Object)"checkDiskError: exception: ", (Throwable)e);
        if (e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof ClosedByInterruptException || e.getMessage().startsWith("An established connection was aborted") || e.getMessage().startsWith("Broken pipe") || e.getMessage().startsWith("Connection reset") || e.getMessage().contains("java.nio.channels.SocketChannel")) {
            LOG.info((Object)"Not checking disk as checkDiskError was called on a network related exception");
            return;
        }
        if (e.getMessage() != null && e.getMessage().startsWith("No space left on device")) {
            throw new DiskChecker.DiskOutOfSpaceException("No space left on device");
        }
        this.checkDiskError();
    }

    public void checkDiskError() {
        try {
            this.data.checkDataDir();
        }
        catch (DiskChecker.DiskErrorException de) {
            this.handleDiskError(de.getMessage());
        }
    }

    private void handleDiskError(String errMsgr) {
        boolean hasEnoughResources = this.data.hasEnoughResource();
        LOG.warn((Object)("DataNode.handleDiskError: Keep Running: " + hasEnoughResources));
        int dpError = hasEnoughResources ? 1 : 3;
        this.metrics.incrVolumeFailures();
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            bpos.trySendErrorReport(dpError, errMsgr);
        }
        if (hasEnoughResources) {
            this.scheduleAllBlockReport(0L);
            return;
        }
        LOG.warn((Object)("DataNode is shutting down: " + errMsgr));
        this.shouldRun = false;
    }

    @Override
    public int getXceiverCount() {
        return this.threadGroup == null ? 0 : this.threadGroup.activeCount();
    }

    int getXmitsInProgress() {
        return this.xmitsInProgress.get();
    }

    private void transferBlock(ExtendedBlock block, DatanodeInfo[] xferTargets) throws IOException {
        BPOfferService bpos = this.getBPOSForBlock(block);
        DatanodeRegistration bpReg = this.getDNRegistrationForBP(block.getBlockPoolId());
        if (!this.data.isValidBlock(block)) {
            String errStr = "Can't send invalid block " + block;
            LOG.info((Object)errStr);
            bpos.trySendErrorReport(2, errStr);
            return;
        }
        long onDiskLength = this.data.getLength(block);
        if (block.getNumBytes() > onDiskLength) {
            bpos.reportBadBlocks(block);
            LOG.warn((Object)("Can't replicate block " + block + " because on-disk length " + onDiskLength + " is shorter than NameNode recorded length " + block.getNumBytes()));
            return;
        }
        int numTargets = xferTargets.length;
        if (numTargets > 0) {
            if (LOG.isInfoEnabled()) {
                StringBuilder xfersBuilder = new StringBuilder();
                for (int i = 0; i < numTargets; ++i) {
                    xfersBuilder.append(xferTargets[i]);
                    xfersBuilder.append(" ");
                }
                LOG.info((Object)(bpReg + " Starting thread to transfer " + block + " to " + xfersBuilder));
            }
            new Daemon((Runnable)new DataTransfer(xferTargets, block, BlockConstructionStage.PIPELINE_SETUP_CREATE, EMPTY_DEL_HINT)).start();
        }
    }

    void transferBlocks(String poolId, Block[] blocks, DatanodeInfo[][] xferTargets) {
        for (int i = 0; i < blocks.length; ++i) {
            try {
                this.transferBlock(new ExtendedBlock(poolId, blocks[i]), xferTargets[i]);
                continue;
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failed to transfer block " + blocks[i]), (Throwable)ie);
            }
        }
    }

    void closeBlock(ExtendedBlock block, String delHint) {
        this.metrics.incrBlocksWritten();
        BPOfferService bpos = this.blockPoolManager.get(block.getBlockPoolId());
        if (bpos != null) {
            bpos.notifyNamenodeReceivedBlock(block, delHint);
        } else {
            LOG.warn((Object)("Cannot find BPOfferService for reporting block received for bpid=" + block.getBlockPoolId()));
        }
        if (this.blockScanner != null) {
            this.blockScanner.addBlock(block);
        }
    }

    public void runDatanodeDaemon() throws IOException {
        this.blockPoolManager.startAll();
        this.dataXceiverServer.start();
        if (this.localDataXceiverServer != null) {
            this.localDataXceiverServer.start();
        }
        this.ipcServer.start();
        this.startPlugins(this.conf);
    }

    public boolean isDatanodeUp() {
        for (BPOfferService bp : this.blockPoolManager.getAllNamenodeThreads()) {
            if (!bp.isAlive()) continue;
            return true;
        }
        return false;
    }

    public static DataNode instantiateDataNode(String[] args, Configuration conf) throws IOException {
        return DataNode.instantiateDataNode(args, conf, null);
    }

    public static DataNode instantiateDataNode(String[] args, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if (args != null) {
            GenericOptionsParser hParser = new GenericOptionsParser(conf, args);
            args = hParser.getRemainingArgs();
        }
        if (!DataNode.parseArguments(args, conf)) {
            DataNode.printUsage(System.err);
            return null;
        }
        Collection<URI> dataDirs = DataNode.getStorageDirs(conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        SecurityUtil.login((Configuration)conf, (String)"dfs.datanode.keytab.file", (String)"dfs.datanode.kerberos.principal");
        return DataNode.makeInstance(dataDirs, conf, resources);
    }

    static Collection<URI> getStorageDirs(Configuration conf) {
        Collection dirNames = conf.getTrimmedStringCollection("dfs.datanode.data.dir");
        return Util.stringCollectionAsURIs(dirNames);
    }

    public static DataNode createDataNode(String[] args, Configuration conf) throws IOException {
        return DataNode.createDataNode(args, conf, null);
    }

    @InterfaceAudience.Private
    public static DataNode createDataNode(String[] args, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        DataNode dn = DataNode.instantiateDataNode(args, conf, resources);
        if (dn != null) {
            dn.runDatanodeDaemon();
        }
        return dn;
    }

    void join() {
        while (this.shouldRun) {
            try {
                this.blockPoolManager.joinAll();
                if (this.blockPoolManager.getAllNamenodeThreads() != null && this.blockPoolManager.getAllNamenodeThreads().length == 0) {
                    this.shouldRun = false;
                }
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)("Received exception in Datanode#join: " + ex));
            }
        }
    }

    static DataNode makeInstance(Collection<URI> dataDirs, Configuration conf, SecureDataNodeStarter.SecureResources resources) throws IOException {
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        FsPermission permission = new FsPermission(conf.get("dfs.datanode.data.dir.perm", "700"));
        DataNodeDiskChecker dataNodeDiskChecker = new DataNodeDiskChecker(permission);
        ArrayList<File> dirs = DataNode.getDataDirsFromURIs(dataDirs, localFS, dataNodeDiskChecker);
        DefaultMetricsSystem.initialize((String)"DataNode");
        assert (dirs.size() > 0) : "number of data directories should be > 0";
        return new DataNode(conf, dirs, resources);
    }

    static ArrayList<File> getDataDirsFromURIs(Collection<URI> dataDirs, LocalFileSystem localFS, DataNodeDiskChecker dataNodeDiskChecker) throws IOException {
        ArrayList<File> dirs = new ArrayList<File>();
        StringBuilder invalidDirs = new StringBuilder();
        for (URI dirURI : dataDirs) {
            if (!"file".equalsIgnoreCase(dirURI.getScheme())) {
                LOG.warn((Object)("Unsupported URI schema in " + dirURI + ". Ignoring ..."));
                invalidDirs.append("\"").append(dirURI).append("\" ");
                continue;
            }
            File dir = new File(dirURI.getPath());
            try {
                dataNodeDiskChecker.checkDir(localFS, new Path(dir.toURI()));
                dirs.add(dir);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Invalid dfs.datanode.data.dir " + dir + " : "), (Throwable)ioe);
                invalidDirs.append("\"").append(dir.getCanonicalPath()).append("\" ");
            }
        }
        if (dirs.size() == 0) {
            throw new IOException("All directories in dfs.datanode.data.dir are invalid: " + invalidDirs);
        }
        return dirs;
    }

    public String toString() {
        return "DataNode{data=" + this.data + ", localName='" + this.getDisplayName() + "', storageID='" + this.getStorageId() + "', xmitsInProgress=" + this.xmitsInProgress.get() + "}";
    }

    private static void printUsage(PrintStream out) {
        out.println("Usage: java DataNode [-rollback | -regular]\n");
    }

    private static boolean parseArguments(String[] args, Configuration conf) {
        int argsLen = args == null ? 0 : args.length;
        HdfsServerConstants.StartupOption startOpt = HdfsServerConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if ("-r".equalsIgnoreCase(cmd) || "--rack".equalsIgnoreCase(cmd)) {
                LOG.error((Object)"-r, --rack arguments are not supported anymore. RackID resolution is handled by the NameNode.");
                ExitUtil.terminate((int)1);
                continue;
            }
            if ("-rollback".equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.ROLLBACK;
                continue;
            }
            if ("-regular".equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.REGULAR;
                continue;
            }
            return false;
        }
        DataNode.setStartupOption(conf, startOpt);
        return true;
    }

    private static void setStartupOption(Configuration conf, HdfsServerConstants.StartupOption opt) {
        conf.set("dfs.datanode.startup", opt.toString());
    }

    static HdfsServerConstants.StartupOption getStartupOption(Configuration conf) {
        return HdfsServerConstants.StartupOption.valueOf(conf.get("dfs.datanode.startup", HdfsServerConstants.StartupOption.REGULAR.toString()));
    }

    public void scheduleAllBlockReport(long delay) {
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            bpos.scheduleBlockReport(delay);
        }
    }

    FsDatasetSpi<?> getFSDataset() {
        return this.data;
    }

    public DataBlockScanner getBlockScanner() {
        return this.blockScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void secureMain(String[] args, SecureDataNodeStarter.SecureResources resources) {
        try {
            StringUtils.startupShutdownMessage(DataNode.class, (String[])args, (Log)LOG);
            DataNode datanode = DataNode.createDataNode(args, null, resources);
            if (datanode != null) {
                datanode.join();
            }
        }
        catch (Throwable e) {
            LOG.fatal((Object)"Exception in secureMain", e);
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        finally {
            LOG.warn((Object)"Exiting Datanode");
            ExitUtil.terminate((int)0);
        }
    }

    public static void main(String[] args) {
        if (DFSUtil.parseHelpArgument(args, USAGE, System.out, true)) {
            System.exit(0);
        }
        DataNode.secureMain(args, null);
    }

    public Daemon recoverBlocks(final String who, final Collection<BlockRecoveryCommand.RecoveringBlock> blocks) {
        Daemon d = new Daemon(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                for (BlockRecoveryCommand.RecoveringBlock b : blocks) {
                    try {
                        DataNode.logRecoverBlock(who, b);
                        DataNode.this.recoverBlock(b);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("recoverBlocks FAILED: " + b), (Throwable)e);
                    }
                }
            }
        });
        d.start();
        return d;
    }

    @Override
    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        return this.data.initReplicaRecovery(rBlock);
    }

    private static ReplicaRecoveryInfo callInitReplicaRecovery(InterDatanodeProtocol datanode, BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        try {
            return datanode.initReplicaRecovery(rBlock);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    @Override
    public String updateReplicaUnderRecovery(ExtendedBlock oldBlock, long recoveryId, long newLength) throws IOException {
        String storageID = this.data.updateReplicaUnderRecovery(oldBlock, recoveryId, newLength);
        ExtendedBlock newBlock = new ExtendedBlock(oldBlock);
        newBlock.setGenerationStamp(recoveryId);
        newBlock.setNumBytes(newLength);
        this.notifyNamenodeReceivedBlock(newBlock, EMPTY_DEL_HINT);
        return storageID;
    }

    private void recoverBlock(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        ExtendedBlock block = rBlock.getBlock();
        String blookPoolId = block.getBlockPoolId();
        DatanodeInfo[] datanodeids = rBlock.getLocations();
        ArrayList<BlockRecord> syncList = new ArrayList<BlockRecord>(datanodeids.length);
        int errorCount = 0;
        for (DatanodeInfo id : datanodeids) {
            try {
                BPOfferService bpos = this.blockPoolManager.get(blookPoolId);
                DatanodeRegistration bpReg = bpos.bpRegistration;
                DataNode datanode = bpReg.equals(id) ? this : DataNode.createInterDataNodeProtocolProxy(id, this.getConf(), this.dnConf.socketTimeout, this.dnConf.connectToDnViaHostname);
                ReplicaRecoveryInfo info = DataNode.callInitReplicaRecovery(datanode, rBlock);
                if (info == null || info.getGenerationStamp() < block.getGenerationStamp() || info.getNumBytes() <= 0L) continue;
                syncList.add(new BlockRecord(id, datanode, info));
            }
            catch (RecoveryInProgressException ripE) {
                InterDatanodeProtocol.LOG.warn((Object)("Recovery for replica " + block + " on data-node " + id + " is already in progress. Recovery id = " + rBlock.getNewGenerationStamp() + " is aborted."), (Throwable)ripE);
                return;
            }
            catch (IOException e) {
                ++errorCount;
                InterDatanodeProtocol.LOG.warn((Object)("Failed to obtain replica info for block (=" + block + ") from datanode (=" + id + ")"), (Throwable)e);
            }
        }
        if (errorCount == datanodeids.length) {
            throw new IOException("All datanodes failed: block=" + block + ", datanodeids=" + Arrays.asList(datanodeids));
        }
        this.syncBlock(rBlock, syncList);
    }

    public DatanodeProtocolClientSideTranslatorPB getActiveNamenodeForBP(String bpid) throws IOException {
        BPOfferService bpos = this.blockPoolManager.get(bpid);
        if (bpos == null) {
            throw new IOException("No block pool offer service for bpid=" + bpid);
        }
        DatanodeProtocolClientSideTranslatorPB activeNN = bpos.getActiveNN();
        if (activeNN == null) {
            throw new IOException("Block pool " + bpid + " has not recognized an active NN");
        }
        return activeNN;
    }

    void syncBlock(BlockRecoveryCommand.RecoveringBlock rBlock, List<BlockRecord> syncList) throws IOException {
        ExtendedBlock block = rBlock.getBlock();
        String bpid = block.getBlockPoolId();
        DatanodeProtocolClientSideTranslatorPB nn = this.getActiveNamenodeForBP(block.getBlockPoolId());
        long recoveryId = rBlock.getNewGenerationStamp();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("block=" + block + ", (length=" + block.getNumBytes() + "), syncList=" + syncList));
        }
        if (syncList.isEmpty()) {
            nn.commitBlockSynchronization(block, recoveryId, 0L, true, true, DatanodeID.EMPTY_ARRAY, null);
            return;
        }
        HdfsServerConstants.ReplicaState bestState = HdfsServerConstants.ReplicaState.RWR;
        long finalizedLength = -1L;
        for (BlockRecord r : syncList) {
            assert (r.rInfo.getNumBytes() > 0L) : "zero length replica";
            HdfsServerConstants.ReplicaState rState = r.rInfo.getOriginalReplicaState();
            if (rState.getValue() < bestState.getValue()) {
                bestState = rState;
            }
            if (rState != HdfsServerConstants.ReplicaState.FINALIZED) continue;
            if (finalizedLength > 0L && finalizedLength != r.rInfo.getNumBytes()) {
                throw new IOException("Inconsistent size of finalized replicas. Replica " + r.rInfo + " expected size: " + finalizedLength);
            }
            finalizedLength = r.rInfo.getNumBytes();
        }
        ArrayList<BlockRecord> participatingList = new ArrayList<BlockRecord>();
        ExtendedBlock newBlock = new ExtendedBlock(bpid, block.getBlockId(), -1L, recoveryId);
        switch (bestState) {
            case FINALIZED: {
                assert (finalizedLength > 0L) : "finalizedLength is not positive";
                for (BlockRecord r : syncList) {
                    HdfsServerConstants.ReplicaState rState = r.rInfo.getOriginalReplicaState();
                    if (rState != HdfsServerConstants.ReplicaState.FINALIZED && (rState != HdfsServerConstants.ReplicaState.RBW || r.rInfo.getNumBytes() != finalizedLength)) continue;
                    participatingList.add(r);
                }
                newBlock.setNumBytes(finalizedLength);
                break;
            }
            case RBW: 
            case RWR: {
                long minLength = Long.MAX_VALUE;
                for (BlockRecord r : syncList) {
                    HdfsServerConstants.ReplicaState rState = r.rInfo.getOriginalReplicaState();
                    if (rState != bestState) continue;
                    minLength = Math.min(minLength, r.rInfo.getNumBytes());
                    participatingList.add(r);
                }
                newBlock.setNumBytes(minLength);
                break;
            }
            case RUR: 
            case TEMPORARY: {
                assert (false) : "bad replica state: " + (Object)((Object)bestState);
                break;
            }
        }
        ArrayList<DatanodeID> failedList = new ArrayList<DatanodeID>();
        ArrayList<BlockRecord> successList = new ArrayList<BlockRecord>();
        for (BlockRecord r : participatingList) {
            try {
                r.updateReplicaUnderRecovery(bpid, recoveryId, newBlock.getNumBytes());
                successList.add(r);
            }
            catch (IOException e) {
                InterDatanodeProtocol.LOG.warn((Object)("Failed to updateBlock (newblock=" + newBlock + ", datanode=" + r.id + ")"), (Throwable)e);
                failedList.add(r.id);
            }
        }
        if (!failedList.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (DatanodeID id : failedList) {
                b.append("\n  " + id);
            }
            throw new IOException("Cannot recover " + block + ", the following " + failedList.size() + " data-nodes failed {" + b + "\n}");
        }
        DatanodeID[] datanodes = new DatanodeID[successList.size()];
        String[] storages = new String[datanodes.length];
        for (int i = 0; i < datanodes.length; ++i) {
            BlockRecord r = (BlockRecord)successList.get(i);
            datanodes[i] = r.id;
            storages[i] = r.storageID;
        }
        nn.commitBlockSynchronization(block, newBlock.getGenerationStamp(), newBlock.getNumBytes(), true, false, datanodes, storages);
    }

    private static void logRecoverBlock(String who, BlockRecoveryCommand.RecoveringBlock rb) {
        ExtendedBlock block = rb.getBlock();
        Object[] targets = rb.getLocations();
        LOG.info((Object)(who + " calls recoverBlock(" + block + ", targets=[" + Joiner.on((String)", ").join(targets) + "]" + ", newGenerationStamp=" + rb.getNewGenerationStamp() + ")"));
    }

    @Override
    public long getReplicaVisibleLength(ExtendedBlock block) throws IOException {
        this.checkWriteAccess(block);
        return this.data.getReplicaVisibleLength(block);
    }

    private void checkWriteAccess(ExtendedBlock block) throws IOException {
        if (this.isBlockTokenEnabled) {
            Set tokenIds = UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            if (tokenIds.size() != 1) {
                throw new IOException("Can't continue since none or more than one BlockTokenIdentifier is found.");
            }
            for (TokenIdentifier tokenId : tokenIds) {
                BlockTokenIdentifier id = (BlockTokenIdentifier)tokenId;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got: " + id.toString()));
                }
                this.blockPoolTokenSecretManager.checkAccess(id, null, block, BlockTokenSecretManager.AccessMode.READ);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transferReplicaForPipelineRecovery(ExtendedBlock b, DatanodeInfo[] targets, String client) throws IOException {
        long visible;
        BlockConstructionStage stage;
        FsDatasetSpi<? extends FsVolumeSpi> fsDatasetSpi = this.data;
        synchronized (fsDatasetSpi) {
            Block storedBlock = this.data.getStoredBlock(b.getBlockPoolId(), b.getBlockId());
            if (null == storedBlock) {
                throw new IOException(b + " not found in datanode.");
            }
            long storedGS = storedBlock.getGenerationStamp();
            if (storedGS < b.getGenerationStamp()) {
                throw new IOException(storedGS + " = storedGS < b.getGenerationStamp(), b=" + b);
            }
            b.setGenerationStamp(storedGS);
            if (this.data.isValidRbw(b)) {
                stage = BlockConstructionStage.TRANSFER_RBW;
            } else if (this.data.isValidBlock(b)) {
                stage = BlockConstructionStage.TRANSFER_FINALIZED;
            } else {
                String r = this.data.getReplicaString(b.getBlockPoolId(), b.getBlockId());
                throw new IOException(b + " is neither a RBW nor a Finalized, r=" + r);
            }
            visible = this.data.getReplicaVisibleLength(b);
        }
        b.setNumBytes(visible);
        if (targets.length > 0) {
            new DataTransfer(targets, b, stage, client).run();
        }
    }

    void finalizeUpgradeForPool(String blockPoolId) throws IOException {
        this.storage.finalizeUpgrade(blockPoolId);
    }

    static InetSocketAddress getStreamingAddr(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.get("dfs.datanode.address", "0.0.0.0:50010"));
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public String getRpcPort() {
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr((String)this.getConf().get("dfs.datanode.ipc.address"));
        return Integer.toString(ipcAddr.getPort());
    }

    @Override
    public String getHttpPort() {
        return this.getConf().get("dfs.datanode.info.port");
    }

    public int getInfoPort() {
        return this.infoServer.getPort();
    }

    @Override
    public String getNamenodeAddresses() {
        HashMap<String, String> info = new HashMap<String, String>();
        for (BPOfferService bpos : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bpos == null) continue;
            for (BPServiceActor actor : bpos.getBPServiceActors()) {
                info.put(actor.getNNSocketAddress().getHostName(), bpos.getBlockPoolId());
            }
        }
        return JSON.toString(info);
    }

    @Override
    public String getVolumeInfo() {
        return JSON.toString(this.data.getVolumeInfoMap());
    }

    @Override
    public synchronized String getClusterId() {
        return this.clusterId;
    }

    public void refreshNamenodes(Configuration conf) throws IOException {
        this.blockPoolManager.refreshNamenodes(conf);
    }

    @Override
    public void refreshNamenodes() throws IOException {
        this.conf = new Configuration();
        this.refreshNamenodes(this.conf);
    }

    @Override
    public void deleteBlockPool(String blockPoolId, boolean force) throws IOException {
        LOG.info((Object)("deleteBlockPool command received for block pool " + blockPoolId + ", force=" + force));
        if (this.blockPoolManager.get(blockPoolId) != null) {
            LOG.warn((Object)("The block pool " + blockPoolId + " is still running, cannot be deleted."));
            throw new IOException("The block pool is still running. First do a refreshNamenodes to shutdown the block pool service");
        }
        this.data.deleteBlockPool(blockPoolId, force);
    }

    public boolean isConnectedToNN(InetSocketAddress addr) {
        for (BPOfferService bpos : this.getAllBpOs()) {
            for (BPServiceActor bpsa : bpos.getBPServiceActors()) {
                if (!addr.equals(bpsa.getNNSocketAddress())) continue;
                return bpsa.isAlive();
            }
        }
        return false;
    }

    public boolean isBPServiceAlive(String bpid) {
        BPOfferService bp = this.blockPoolManager.get(bpid);
        return bp != null ? bp.isAlive() : false;
    }

    public boolean isDatanodeFullyStarted() {
        for (BPOfferService bp : this.blockPoolManager.getAllNamenodeThreads()) {
            if (bp.isInitialized() && bp.isAlive()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public DatanodeID getDatanodeId() {
        return this.id;
    }

    @VisibleForTesting
    public void clearAllBlockSecretKeys() {
        this.blockPoolTokenSecretManager.clearAllKeysForTesting();
    }

    public Long getBalancerBandwidth() {
        DataXceiverServer dxcs = (DataXceiverServer)this.dataXceiverServer.getRunnable();
        return dxcs.balanceThrottler.getBandwidth();
    }

    public DNConf getDnConf() {
        return this.dnConf;
    }

    boolean shouldRun() {
        return this.shouldRun;
    }

    static {
        HdfsConfiguration.init();
        ClientTraceLog = LogFactory.getLog((String)(DataNode.class.getName() + ".clienttrace"));
    }

    static class BlockRecord {
        final DatanodeID id;
        final InterDatanodeProtocol datanode;
        final ReplicaRecoveryInfo rInfo;
        private String storageID;

        BlockRecord(DatanodeID id, InterDatanodeProtocol datanode, ReplicaRecoveryInfo rInfo) {
            this.id = id;
            this.datanode = datanode;
            this.rInfo = rInfo;
        }

        void updateReplicaUnderRecovery(String bpid, long recoveryId, long newLength) throws IOException {
            ExtendedBlock b = new ExtendedBlock(bpid, this.rInfo);
            this.storageID = this.datanode.updateReplicaUnderRecovery(b, recoveryId, newLength);
        }

        public String toString() {
            return "block:" + this.rInfo + " node:" + this.id;
        }
    }

    static class DataNodeDiskChecker {
        private FsPermission expectedPermission;

        public DataNodeDiskChecker(FsPermission expectedPermission) {
            this.expectedPermission = expectedPermission;
        }

        public void checkDir(LocalFileSystem localFS, Path path) throws DiskChecker.DiskErrorException, IOException {
            DiskChecker.checkDir((LocalFileSystem)localFS, (Path)path, (FsPermission)this.expectedPermission);
        }
    }

    private class DataTransfer
    implements Runnable {
        final DatanodeInfo[] targets;
        final ExtendedBlock b;
        final BlockConstructionStage stage;
        private final DatanodeRegistration bpReg;
        final String clientname;

        DataTransfer(DatanodeInfo[] targets, ExtendedBlock b, BlockConstructionStage stage, String clientname) {
            if (DataTransferProtocol.LOG.isDebugEnabled()) {
                DataTransferProtocol.LOG.debug((Object)(this.getClass().getSimpleName() + ": " + b + " (numBytes=" + b.getNumBytes() + ")" + ", stage=" + (Object)((Object)stage) + ", clientname=" + clientname + ", targests=" + Arrays.asList(targets)));
            }
            this.targets = targets;
            this.b = b;
            this.stage = stage;
            BPOfferService bpos = DataNode.this.blockPoolManager.get(b.getBlockPoolId());
            this.bpReg = bpos.bpRegistration;
            this.clientname = clientname;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DataNode.this.xmitsInProgress.getAndIncrement();
            Socket sock = null;
            DataOutputStream out = null;
            DataInputStream in = null;
            BlockSender blockSender = null;
            boolean isClient = this.clientname.length() > 0;
            try {
                String dnAddr = this.targets[0].getXferAddr(DataNode.this.connectToDnViaHostname);
                InetSocketAddress curTarget = NetUtils.createSocketAddr((String)dnAddr);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connecting to datanode " + dnAddr));
                }
                sock = DataNode.this.newSocket();
                NetUtils.connect((Socket)sock, (SocketAddress)curTarget, (int)((DataNode)DataNode.this).dnConf.socketTimeout);
                sock.setSoTimeout(this.targets.length * ((DataNode)DataNode.this).dnConf.socketTimeout);
                long writeTimeout = ((DataNode)DataNode.this).dnConf.socketWriteTimeout + HdfsServerConstants.WRITE_TIMEOUT_EXTENSION * (this.targets.length - 1);
                OutputStream unbufOut = NetUtils.getOutputStream((Socket)sock, (long)writeTimeout);
                Object unbufIn = NetUtils.getInputStream((Socket)sock);
                if (((DataNode)DataNode.this).dnConf.encryptDataTransfer) {
                    IOStreamPair encryptedStreams = DataTransferEncryptor.getEncryptedStreams(unbufOut, (InputStream)unbufIn, DataNode.this.blockPoolTokenSecretManager.generateDataEncryptionKey(this.b.getBlockPoolId()));
                    unbufOut = encryptedStreams.out;
                    unbufIn = encryptedStreams.in;
                }
                out = new DataOutputStream(new BufferedOutputStream(unbufOut, HdfsConstants.SMALL_BUFFER_SIZE));
                in = new DataInputStream((InputStream)unbufIn);
                blockSender = new BlockSender(this.b, 0L, this.b.getNumBytes(), false, false, true, DataNode.this, null);
                DatanodeInfo srcNode = new DatanodeInfo(this.bpReg);
                Token<BlockTokenIdentifier> accessToken = BlockTokenSecretManager.DUMMY_TOKEN;
                if (DataNode.this.isBlockTokenEnabled) {
                    accessToken = DataNode.this.blockPoolTokenSecretManager.generateToken(this.b, EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE));
                }
                new Sender(out).writeBlock(this.b, accessToken, this.clientname, this.targets, srcNode, this.stage, 0, 0L, 0L, 0L, blockSender.getChecksum());
                blockSender.sendBlock(out, unbufOut, null);
                LOG.info((Object)(this.getClass().getSimpleName() + ": Transmitted " + this.b + " (numBytes=" + this.b.getNumBytes() + ") to " + curTarget));
                if (isClient) {
                    DataTransferProtos.DNTransferAckProto closeAck = DataTransferProtos.DNTransferAckProto.parseFrom(PBHelper.vintPrefixed(in));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getClass().getSimpleName() + ": close-ack=" + closeAck));
                    }
                    if (closeAck.getStatus() != DataTransferProtos.Status.SUCCESS) {
                        if (closeAck.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                            throw new InvalidBlockTokenException("Got access token error for connect ack, targets=" + Arrays.asList(this.targets));
                        }
                        throw new IOException("Bad connect ack, targets=" + Arrays.asList(this.targets));
                    }
                }
                DataNode.this.xmitsInProgress.getAndDecrement();
            }
            catch (IOException ie) {
                try {
                    LOG.warn((Object)(this.bpReg + ":Failed to transfer " + this.b + " to " + this.targets[0] + " got "), (Throwable)ie);
                    try {
                        DataNode.this.checkDiskError(ie);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"DataNode.checkDiskError failed in run() with: ", (Throwable)e);
                    }
                    DataNode.this.xmitsInProgress.getAndDecrement();
                }
                catch (Throwable throwable) {
                    DataNode.this.xmitsInProgress.getAndDecrement();
                    IOUtils.closeStream(blockSender);
                    IOUtils.closeStream(out);
                    IOUtils.closeStream(in);
                    IOUtils.closeSocket(sock);
                    throw throwable;
                }
                IOUtils.closeStream(blockSender);
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                IOUtils.closeSocket((Socket)sock);
            }
            IOUtils.closeStream((Closeable)blockSender);
            IOUtils.closeStream((Closeable)out);
            IOUtils.closeStream((Closeable)in);
            IOUtils.closeSocket((Socket)sock);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public static class ShortCircuitFdsVersionException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ShortCircuitFdsVersionException(String msg) {
            super(msg);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public static class ShortCircuitFdsUnsupportedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ShortCircuitFdsUnsupportedException(String msg) {
            super(msg);
        }
    }
}

