/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TestWriteBlockGetsBlockLengthHint {
    static final long DEFAULT_BLOCK_LENGTH = 1024L;
    static final long EXPECTED_BLOCK_LENGTH = 2048L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockLengthHintIsPropagated() throws IOException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        HdfsConfiguration conf = new HdfsConfiguration();
        FsDatasetChecker.setFactory((Configuration)conf);
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.datanode.scan.period.hours", -1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), path, 4096, 2048L, 2048L, (short)1, 464346861L);
        }
        finally {
            cluster.shutdown();
        }
    }

    static class FsDatasetChecker
    extends SimulatedFSDataset {
        public static void setFactory(Configuration conf) {
            conf.set("dfs.datanode.fsdataset.factory", Factory.class.getName());
        }

        public FsDatasetChecker(DataStorage storage, Configuration conf) {
            super(storage, conf);
        }

        @Override
        public synchronized ReplicaHandler createRbw(StorageType storageType, ExtendedBlock b, boolean allowLazyPersist) throws IOException {
            Assert.assertThat((Object)b.getLocalBlock().getNumBytes(), (Matcher)Is.is((Object)2048L));
            return super.createRbw(storageType, b, allowLazyPersist);
        }

        static class Factory
        extends FsDatasetSpi.Factory<SimulatedFSDataset> {
            Factory() {
            }

            public SimulatedFSDataset newInstance(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
                return new FsDatasetChecker(storage, conf);
            }

            public boolean isSimulated() {
                return true;
            }
        }
    }
}

