/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public abstract class BlockPlacementPolicy {
    static final Log LOG = LogFactory.getLog(BlockPlacementPolicy.class);

    public abstract DatanodeStorageInfo[] chooseTarget(String var1, int var2, Node var3, List<DatanodeStorageInfo> var4, boolean var5, Set<Node> var6, long var7, BlockStoragePolicy var9);

    DatanodeStorageInfo[] chooseTarget(String src, int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, List<DatanodeDescriptor> favoredNodes, BlockStoragePolicy storagePolicy) {
        return this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>(numOfReplicas), false, excludedNodes, blocksize, storagePolicy);
    }

    public abstract BlockPlacementStatus verifyBlockPlacement(String var1, LocatedBlock var2, int var3);

    public abstract DatanodeStorageInfo chooseReplicaToDelete(BlockCollection var1, Block var2, short var3, Collection<DatanodeStorageInfo> var4, Collection<DatanodeStorageInfo> var5, List<StorageType> var6);

    protected abstract void initialize(Configuration var1, FSClusterStats var2, NetworkTopology var3, Host2NodesMap var4);

    public static BlockPlacementPolicy getInstance(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, Host2NodesMap host2datanodeMap) {
        Class replicatorClass = conf.getClass("dfs.block.replicator.classname", DFSConfigKeys.DFS_BLOCK_REPLICATOR_CLASSNAME_DEFAULT, BlockPlacementPolicy.class);
        BlockPlacementPolicy replicator = (BlockPlacementPolicy)ReflectionUtils.newInstance((Class)replicatorClass, (Configuration)conf);
        replicator.initialize(conf, stats, clusterMap, host2datanodeMap);
        return replicator;
    }

    public void adjustSetsWithChosenReplica(Map<String, List<DatanodeStorageInfo>> rackMap, List<DatanodeStorageInfo> moreThanOne, List<DatanodeStorageInfo> exactlyOne, DatanodeStorageInfo cur) {
        String rack = this.getRack(cur.getDatanodeDescriptor());
        List<DatanodeStorageInfo> storages = rackMap.get(rack);
        storages.remove(cur);
        if (storages.isEmpty()) {
            rackMap.remove(rack);
        }
        if (moreThanOne.remove(cur)) {
            if (storages.size() == 1) {
                DatanodeStorageInfo remaining = storages.get(0);
                moreThanOne.remove(remaining);
                exactlyOne.add(remaining);
            }
        } else {
            exactlyOne.remove(cur);
        }
    }

    protected String getRack(DatanodeInfo datanode) {
        return datanode.getNetworkLocation();
    }

    public void splitNodesWithRack(Iterable<DatanodeStorageInfo> storages, Map<String, List<DatanodeStorageInfo>> rackMap, List<DatanodeStorageInfo> moreThanOne, List<DatanodeStorageInfo> exactlyOne) {
        for (DatanodeStorageInfo datanodeStorageInfo : storages) {
            String rackName = this.getRack(datanodeStorageInfo.getDatanodeDescriptor());
            List<DatanodeStorageInfo> storageList = rackMap.get(rackName);
            if (storageList == null) {
                storageList = new ArrayList<DatanodeStorageInfo>();
                rackMap.put(rackName, storageList);
            }
            storageList.add(datanodeStorageInfo);
        }
        for (List list : rackMap.values()) {
            if (list.size() == 1) {
                exactlyOne.add((DatanodeStorageInfo)list.get(0));
                continue;
            }
            moreThanOne.addAll(list);
        }
    }

    @InterfaceAudience.Private
    public static class NotEnoughReplicasException
    extends Exception {
        private static final long serialVersionUID = 1L;

        NotEnoughReplicasException(String msg) {
            super(msg);
        }
    }
}

