/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshotFeature;
import org.apache.hadoop.hdfs.util.LongBitFormat;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public class INodeFile
extends INodeWithAdditionalFields
implements INodeFileAttributes,
BlockCollection {
    private long header = 0L;
    private BlockInfo[] blocks;

    public static INodeFile valueOf(INode inode, String path) throws FileNotFoundException {
        return INodeFile.valueOf(inode, path, false);
    }

    public static INodeFile valueOf(INode inode, String path, boolean acceptNull) throws FileNotFoundException {
        if (inode == null) {
            if (acceptNull) {
                return null;
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!inode.isFile()) {
            throw new FileNotFoundException("Path is not a file: " + path);
        }
        return inode.asFile();
    }

    INodeFile(long id, byte[] name, PermissionStatus permissions, long mtime, long atime, BlockInfo[] blklist, short replication, long preferredBlockSize) {
        this(id, name, permissions, mtime, atime, blklist, replication, preferredBlockSize, 0);
    }

    INodeFile(long id, byte[] name, PermissionStatus permissions, long mtime, long atime, BlockInfo[] blklist, short replication, long preferredBlockSize, byte storagePolicyID) {
        super(id, name, permissions, mtime, atime);
        this.header = HeaderFormat.toLong(preferredBlockSize, replication, storagePolicyID);
        this.setBlocks(blklist);
    }

    public INodeFile(INodeFile that) {
        super(that);
        this.header = that.header;
        this.features = that.features;
        this.setBlocks(that.blocks);
    }

    public INodeFile(INodeFile that, FileDiffList diffs) {
        this(that);
        Preconditions.checkArgument((!that.isWithSnapshot() ? 1 : 0) != 0);
        this.addSnapshotFeature(diffs);
    }

    @Override
    public final boolean isFile() {
        return true;
    }

    @Override
    public final INodeFile asFile() {
        return this;
    }

    @Override
    public boolean metadataEquals(INodeFileAttributes other) {
        return other != null && this.getHeaderLong() == other.getHeaderLong() && this.getPermissionLong() == other.getPermissionLong() && this.getAclFeature() == other.getAclFeature() && this.getXAttrFeature() == other.getXAttrFeature();
    }

    public final FileUnderConstructionFeature getFileUnderConstructionFeature() {
        return (FileUnderConstructionFeature)this.getFeature(FileUnderConstructionFeature.class);
    }

    @Override
    public boolean isUnderConstruction() {
        return this.getFileUnderConstructionFeature() != null;
    }

    INodeFile toUnderConstruction(String clientName, String clientMachine) {
        Preconditions.checkState((!this.isUnderConstruction() ? 1 : 0) != 0, (Object)"file is already under construction");
        FileUnderConstructionFeature uc = new FileUnderConstructionFeature(clientName, clientMachine);
        this.addFeature(uc);
        return this;
    }

    void toCompleteFile(long mtime, int numCommittedAllowed, short minReplication) {
        FileUnderConstructionFeature uc = this.getFileUnderConstructionFeature();
        Preconditions.checkNotNull((Object)uc, (String)"File %s is not under construction", (Object[])new Object[]{this});
        this.assertAllBlocksComplete(numCommittedAllowed, minReplication);
        this.removeFeature(uc);
        this.setModificationTime(mtime);
    }

    private void assertAllBlocksComplete(int numCommittedAllowed, short minReplication) {
        for (int i = 0; i < this.blocks.length; ++i) {
            String err = INodeFile.checkBlockComplete(this.blocks, i, numCommittedAllowed, minReplication);
            Preconditions.checkState((err == null ? 1 : 0) != 0, (String)"Unexpected block state: %s, file=%s (%s), blocks=%s (i=%s)", (Object[])new Object[]{err, this, this.getClass().getSimpleName(), Arrays.asList(this.blocks), i});
        }
    }

    static String checkBlockComplete(BlockInfo[] blocks, int i, int numCommittedAllowed, short minReplication) {
        BlockInfo b = blocks[i];
        HdfsServerConstants.BlockUCState state = b.getBlockUCState();
        if (state == HdfsServerConstants.BlockUCState.COMPLETE) {
            return null;
        }
        if (i < blocks.length - numCommittedAllowed) {
            return (Object)((Object)b) + " is " + (Object)((Object)state) + " but not COMPLETE";
        }
        if (state != HdfsServerConstants.BlockUCState.COMMITTED) {
            return (Object)((Object)b) + " is " + (Object)((Object)state) + " but neither COMPLETE nor COMMITTED";
        }
        int numExpectedLocations = b.getUnderConstructionFeature().getNumExpectedLocations();
        if (numExpectedLocations <= minReplication) {
            return (Object)((Object)b) + " is " + (Object)((Object)state) + " but numExpectedLocations = " + numExpectedLocations + " <= minReplication = " + minReplication;
        }
        return null;
    }

    @Override
    public void setBlock(int index, BlockInfo blk) {
        this.blocks[index] = blk;
    }

    @Override
    public void convertLastBlockToUC(BlockInfo lastBlock, DatanodeStorageInfo[] locations) throws IOException {
        Preconditions.checkState((boolean)this.isUnderConstruction(), (Object)"file is no longer under construction");
        if (this.numBlocks() == 0) {
            throw new IOException("Failed to set last block: File is empty.");
        }
        lastBlock.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, locations);
    }

    void setLastBlock(BlockInfo blk) {
        blk.setBlockCollectionId(this.getId());
        this.setBlock(this.numBlocks() - 1, blk);
    }

    BlockInfo removeLastBlock(Block oldblock) {
        Preconditions.checkState((boolean)this.isUnderConstruction(), (Object)"file is no longer under construction");
        if (this.blocks.length == 0) {
            return null;
        }
        int size_1 = this.blocks.length - 1;
        if (!this.blocks[size_1].equals(oldblock)) {
            return null;
        }
        BlockInfo ucBlock = this.blocks[size_1];
        BlockInfo[] newlist = new BlockInfo[size_1];
        System.arraycopy(this.blocks, 0, newlist, 0, size_1);
        this.setBlocks(newlist);
        return ucBlock;
    }

    public FileWithSnapshotFeature addSnapshotFeature(FileDiffList diffs) {
        Preconditions.checkState((!this.isWithSnapshot() ? 1 : 0) != 0, (Object)"File is already with snapshot");
        FileWithSnapshotFeature sf = new FileWithSnapshotFeature(diffs);
        this.addFeature(sf);
        return sf;
    }

    public final FileWithSnapshotFeature getFileWithSnapshotFeature() {
        return (FileWithSnapshotFeature)this.getFeature(FileWithSnapshotFeature.class);
    }

    public final boolean isWithSnapshot() {
        return this.getFileWithSnapshotFeature() != null;
    }

    @Override
    public String toDetailString() {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        return super.toDetailString() + (sf == null ? "" : sf.getDetailedString());
    }

    @Override
    public INodeFileAttributes getSnapshotINode(int snapshotId) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            return sf.getDiffs().getSnapshotINode(snapshotId, this);
        }
        return this;
    }

    @Override
    public void recordModification(int latestSnapshotId) {
        this.recordModification(latestSnapshotId, false);
    }

    public void recordModification(int latestSnapshotId, boolean withBlocks) {
        if (this.isInLatestSnapshot(latestSnapshotId) && !this.shouldRecordInSrcSnapshot(latestSnapshotId)) {
            FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
            if (sf == null) {
                sf = this.addSnapshotFeature(null);
            }
            sf.getDiffs().saveSelf2Snapshot(latestSnapshotId, this, null, withBlocks);
        }
    }

    public FileDiffList getDiffs() {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            return sf.getDiffs();
        }
        return null;
    }

    public final short getFileReplication(int snapshot) {
        if (snapshot != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshot).getFileReplication();
        }
        return HeaderFormat.getReplication(this.header);
    }

    @Override
    public final short getFileReplication() {
        return this.getFileReplication(0x7FFFFFFE);
    }

    public short getPreferredBlockReplication() {
        short max = this.getFileReplication(0x7FFFFFFE);
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            short maxInSnapshot = sf.getMaxBlockRepInDiffs(null);
            if (sf.isCurrentFileDeleted()) {
                return maxInSnapshot;
            }
            max = maxInSnapshot > max ? maxInSnapshot : max;
        }
        return max;
    }

    private void setFileReplication(short replication) {
        this.header = HeaderFormat.REPLICATION.BITS.combine((long)replication, this.header);
    }

    public final INodeFile setFileReplication(short replication, int latestSnapshotId) throws QuotaExceededException {
        this.recordModification(latestSnapshotId);
        this.setFileReplication(replication);
        return this;
    }

    @Override
    public long getPreferredBlockSize() {
        return HeaderFormat.getPreferredBlockSize(this.header);
    }

    @Override
    public byte getLocalStoragePolicyID() {
        return HeaderFormat.getStoragePolicyID(this.header);
    }

    @Override
    public byte getStoragePolicyID() {
        byte id = this.getLocalStoragePolicyID();
        if (id == 0) {
            return this.getParent() != null ? this.getParent().getStoragePolicyID() : id;
        }
        return id;
    }

    private void setStoragePolicyID(byte storagePolicyId) {
        this.header = HeaderFormat.STORAGE_POLICY_ID.BITS.combine((long)storagePolicyId, this.header);
    }

    public final void setStoragePolicyID(byte storagePolicyId, int latestSnapshotId) throws QuotaExceededException {
        this.recordModification(latestSnapshotId);
        this.setStoragePolicyID(storagePolicyId);
    }

    @Override
    public long getHeaderLong() {
        return this.header;
    }

    @Override
    public BlockInfo[] getBlocks() {
        return this.blocks;
    }

    public BlockInfo[] getBlocks(int snapshot) {
        BlockInfo[] snapshotBlocks;
        if (snapshot == 0x7FFFFFFE || this.getDiffs() == null) {
            return this.getBlocks();
        }
        FileDiff diff = (FileDiff)this.getDiffs().getDiffById(snapshot);
        BlockInfo[] blockInfoArray = snapshotBlocks = diff == null ? this.getBlocks() : diff.getBlocks();
        if (snapshotBlocks != null) {
            return snapshotBlocks;
        }
        snapshotBlocks = this.getDiffs().findLaterSnapshotBlocks(snapshot);
        return snapshotBlocks == null ? this.getBlocks() : snapshotBlocks;
    }

    void concatBlocks(INodeFile[] inodes, BlockManager bm) {
        int size = this.blocks.length;
        int totalAddedBlocks = 0;
        for (INodeFile f : inodes) {
            totalAddedBlocks += f.blocks.length;
        }
        BlockInfo[] newlist = new BlockInfo[size + totalAddedBlocks];
        System.arraycopy(this.blocks, 0, newlist, 0, size);
        for (INodeFile iNodeFile : inodes) {
            System.arraycopy(iNodeFile.blocks, 0, newlist, size, iNodeFile.blocks.length);
            size += iNodeFile.blocks.length;
        }
        this.setBlocks(newlist);
        for (LightWeightGSet.LinkedElement linkedElement : this.blocks) {
            linkedElement.setBlockCollectionId(this.getId());
            short oldRepl = linkedElement.getReplication();
            short repl = this.getPreferredBlockReplication();
            if (oldRepl == repl) continue;
            bm.setReplication(oldRepl, repl, (BlockInfo)linkedElement);
        }
    }

    void addBlock(BlockInfo newblock) {
        if (this.blocks.length == 0) {
            this.setBlocks(new BlockInfo[]{newblock});
        } else {
            int size = this.blocks.length;
            BlockInfo[] newlist = new BlockInfo[size + 1];
            System.arraycopy(this.blocks, 0, newlist, 0, size);
            newlist[size] = newblock;
            this.setBlocks(newlist);
        }
    }

    private void setBlocks(BlockInfo[] blocks) {
        this.blocks = blocks != null ? blocks : BlockInfo.EMPTY_ARRAY;
    }

    public void clearBlocks() {
        this.blocks = BlockInfo.EMPTY_ARRAY;
    }

    @Override
    public void cleanSubtree(INode.ReclaimContext reclaimContext, int snapshot, int priorSnapshotId) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            sf.cleanFile(reclaimContext, this, snapshot, priorSnapshotId, this.getStoragePolicyID());
        } else if (snapshot == 0x7FFFFFFE) {
            if (priorSnapshotId == -1) {
                this.destroyAndCollectBlocks(reclaimContext);
            } else {
                FileUnderConstructionFeature uc = this.getFileUnderConstructionFeature();
                if (uc != null) {
                    uc.cleanZeroSizeBlock(this, reclaimContext.collectedBlocks);
                    if (reclaimContext.removedUCFiles != null) {
                        reclaimContext.removedUCFiles.add(this.getId());
                    }
                }
            }
        }
    }

    @Override
    public void destroyAndCollectBlocks(INode.ReclaimContext reclaimContext) {
        reclaimContext.quotaDelta().add(this.computeQuotaUsage(reclaimContext.bsps, false));
        this.clearFile(reclaimContext);
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            sf.getDiffs().destroyAndCollectSnapshotBlocks(reclaimContext.collectedBlocks);
            sf.clearDiffs();
        }
        if (this.isUnderConstruction() && reclaimContext.removedUCFiles != null) {
            reclaimContext.removedUCFiles.add(this.getId());
        }
    }

    public void clearFile(INode.ReclaimContext reclaimContext) {
        if (this.blocks != null && reclaimContext.collectedBlocks != null) {
            for (BlockInfo blk : this.blocks) {
                reclaimContext.collectedBlocks.addDeleteBlock(blk);
                blk.setBlockCollectionId(-1L);
            }
        }
        this.clearBlocks();
        if (this.getAclFeature() != null) {
            AclStorage.removeAclFeature(this.getAclFeature());
        }
        this.clear();
        reclaimContext.removedINodes.add(this);
    }

    @Override
    public String getName() {
        return this.getFullPathName();
    }

    @Override
    public final QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, boolean useCache, int lastSnapshotId) {
        short replication;
        long ssDeltaNoReplication;
        QuotaCounts counts = new QuotaCounts.Builder().nameSpace(1L).build();
        BlockStoragePolicy bsp = blockStoragePolicyId == 0 ? null : bsps.getPolicy(blockStoragePolicyId);
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf == null) {
            counts.add(this.storagespaceConsumed(bsp));
            return counts;
        }
        FileDiffList fileDiffList = sf.getDiffs();
        int last = fileDiffList.getLastSnapshotId();
        if (lastSnapshotId == 0x7FFFFFFE || last == 0x7FFFFFFE) {
            counts.add(this.storagespaceConsumed(bsp));
            return counts;
        }
        if (last < lastSnapshotId) {
            ssDeltaNoReplication = this.computeFileSize(true, false);
            replication = this.getFileReplication();
        } else {
            int sid = fileDiffList.getSnapshotById(lastSnapshotId);
            ssDeltaNoReplication = this.computeFileSize(sid);
            replication = this.getFileReplication(sid);
        }
        counts.addStorageSpace(ssDeltaNoReplication * (long)replication);
        if (bsp != null) {
            List storageTypes = bsp.chooseStorageTypes(replication);
            for (StorageType t : storageTypes) {
                if (!t.supportTypeQuota()) continue;
                counts.addTypeSpace(t, ssDeltaNoReplication);
            }
        }
        return counts;
    }

    @Override
    public final ContentSummaryComputationContext computeContentSummary(int snapshotId, ContentSummaryComputationContext summary) {
        summary.nodeIncluded(this);
        ContentCounts counts = summary.getCounts();
        counts.addContent(Content.FILE, 1L);
        long fileLen = this.computeFileSize(snapshotId);
        counts.addContent(Content.LENGTH, fileLen);
        counts.addContent(Content.DISKSPACE, this.storagespaceConsumed(null).getStorageSpace());
        if (this.getStoragePolicyID() != 0) {
            BlockStoragePolicy bsp = summary.getBlockStoragePolicySuite().getPolicy(this.getStoragePolicyID());
            List storageTypes = bsp.chooseStorageTypes(this.getFileReplication());
            for (StorageType t : storageTypes) {
                if (!t.supportTypeQuota()) continue;
                counts.addTypeSpace(t, fileLen);
            }
        }
        return summary;
    }

    public final long computeFileSize() {
        return this.computeFileSize(0x7FFFFFFE);
    }

    public final long computeFileSize(int snapshotId) {
        FileDiff d;
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (snapshotId != 0x7FFFFFFE && sf != null && (d = (FileDiff)sf.getDiffs().getDiffById(snapshotId)) != null) {
            return d.getFileSize();
        }
        return this.computeFileSize(true, false);
    }

    public final long computeFileSizeNotIncludingLastUcBlock() {
        return this.computeFileSize(false, false);
    }

    public final long computeFileSize(boolean includesLastUcBlock, boolean usePreferredBlockSize4LastUcBlock) {
        if (this.blocks.length == 0) {
            return 0L;
        }
        int last = this.blocks.length - 1;
        long size = this.blocks[last].getNumBytes();
        if (!this.blocks[last].isComplete()) {
            if (!includesLastUcBlock) {
                size = 0L;
            } else if (usePreferredBlockSize4LastUcBlock) {
                size = this.getPreferredBlockSize();
            }
        }
        for (int i = 0; i < last; ++i) {
            size += this.blocks[i].getNumBytes();
        }
        return size;
    }

    public final QuotaCounts storagespaceConsumed(BlockStoragePolicy bsp) {
        Collection<BlockInfo> blocks;
        QuotaCounts counts = new QuotaCounts.Builder().build();
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf == null) {
            blocks = Arrays.asList(this.getBlocks());
        } else {
            HashSet<BlockInfo> allBlocks = new HashSet<BlockInfo>(Arrays.asList(this.getBlocks()));
            List diffs = sf.getDiffs().asList();
            for (FileDiff diff : diffs) {
                BlockInfo[] diffBlocks = diff.getBlocks();
                if (diffBlocks == null) continue;
                allBlocks.addAll(Arrays.asList(diffBlocks));
            }
            blocks = allBlocks;
        }
        short replication = this.getPreferredBlockReplication();
        for (BlockInfo b : blocks) {
            long blockSize = b.isComplete() ? b.getNumBytes() : this.getPreferredBlockSize();
            counts.addStorageSpace(blockSize * (long)replication);
            if (bsp == null) continue;
            List types = bsp.chooseStorageTypes(replication);
            for (StorageType t : types) {
                if (!t.supportTypeQuota()) continue;
                counts.addTypeSpace(t, blockSize);
            }
        }
        return counts;
    }

    BlockInfo getPenultimateBlock() {
        if (this.blocks.length <= 1) {
            return null;
        }
        return this.blocks[this.blocks.length - 2];
    }

    @Override
    public BlockInfo getLastBlock() {
        return this.blocks.length == 0 ? null : this.blocks[this.blocks.length - 1];
    }

    @Override
    public int numBlocks() {
        return this.blocks.length;
    }

    @Override
    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, int snapshotId) {
        super.dumpTreeRecursively(out, prefix, snapshotId);
        out.print(", fileSize=" + this.computeFileSize(snapshotId));
        out.print(", blocks=");
        out.print((Object)(this.blocks.length == 0 ? null : this.blocks[0]));
        out.println();
    }

    public long collectBlocksBeyondMax(long max, INode.BlocksMapUpdateInfo collectedBlocks) {
        long size;
        BlockInfo[] oldBlocks = this.getBlocks();
        if (oldBlocks == null) {
            return 0L;
        }
        int n = 0;
        for (size = 0L; n < oldBlocks.length && max > size; size += oldBlocks[n].getNumBytes(), ++n) {
        }
        if (n >= oldBlocks.length) {
            return size;
        }
        this.truncateBlocksTo(n);
        if (collectedBlocks != null) {
            while (n < oldBlocks.length) {
                collectedBlocks.addDeleteBlock(oldBlocks[n]);
                ++n;
            }
        }
        return size;
    }

    void computeQuotaDeltaForTruncate(long newLength, BlockStoragePolicy bsps, QuotaCounts delta) {
        BlockInfo[] blocks = this.getBlocks();
        if (blocks.length == 0) {
            return;
        }
        long size = 0L;
        for (BlockInfo b : blocks) {
            size += b.getNumBytes();
        }
        BlockInfo[] sblocks = null;
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            FileDiff diff = (FileDiff)sf.getDiffs().getLast();
            sblocks = diff != null ? diff.getBlocks() : null;
        }
        for (int i = blocks.length - 1; i >= 0 && size > newLength; size -= blocks[i].getNumBytes(), --i) {
            BlockInfo bi = blocks[i];
            long truncatedBytes = size - newLength < bi.getNumBytes() ? bi.getNumBytes() - this.getPreferredBlockSize() : bi.getNumBytes();
            if (sblocks != null && i < sblocks.length && bi.equals((Object)sblocks[i])) {
                truncatedBytes -= bi.getNumBytes();
            }
            delta.addStorageSpace(-truncatedBytes * (long)bi.getReplication());
            if (bsps == null) continue;
            List types = bsps.chooseStorageTypes(bi.getReplication());
            for (StorageType t : types) {
                if (!t.supportTypeQuota()) continue;
                delta.addTypeSpace(t, -truncatedBytes);
            }
        }
    }

    void truncateBlocksTo(int n) {
        BlockInfo[] newBlocks;
        if (n == 0) {
            newBlocks = BlockInfo.EMPTY_ARRAY;
        } else {
            newBlocks = new BlockInfo[n];
            System.arraycopy(this.getBlocks(), 0, newBlocks, 0, n);
        }
        this.setBlocks(newBlocks);
    }

    public void collectBlocksBeyondSnapshot(BlockInfo[] snapshotBlocks, INode.BlocksMapUpdateInfo collectedBlocks) {
        int n;
        BlockInfo[] oldBlocks = this.getBlocks();
        if (snapshotBlocks == null || oldBlocks == null) {
            return;
        }
        for (n = 0; n < oldBlocks.length && n < snapshotBlocks.length && oldBlocks[n] == snapshotBlocks[n]; ++n) {
        }
        this.truncateBlocksTo(n);
        while (n < oldBlocks.length) {
            collectedBlocks.addDeleteBlock(oldBlocks[n++]);
        }
    }

    void excludeSnapshotBlocks(int snapshotId, INode.BlocksMapUpdateInfo collectedBlocks) {
        if (collectedBlocks == null || collectedBlocks.getToDeleteList().isEmpty()) {
            return;
        }
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf == null) {
            return;
        }
        BlockInfo[] snapshotBlocks = this.getDiffs().findEarlierSnapshotBlocks(snapshotId);
        if (snapshotBlocks == null) {
            return;
        }
        List<BlockInfo> toDelete = collectedBlocks.getToDeleteList();
        for (BlockInfo blk : snapshotBlocks) {
            if (!toDelete.contains((Object)blk)) continue;
            collectedBlocks.removeDeleteBlock(blk);
        }
    }

    boolean isBlockInLatestSnapshot(BlockInfo block) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf == null || sf.getDiffs() == null) {
            return false;
        }
        BlockInfo[] snapshotBlocks = this.getDiffs().findEarlierSnapshotBlocks(this.getDiffs().getLastSnapshotId());
        return snapshotBlocks != null && Arrays.asList(snapshotBlocks).contains((Object)block);
    }

    static enum HeaderFormat {
        PREFERRED_BLOCK_SIZE(null, 48, 1L),
        REPLICATION(HeaderFormat.PREFERRED_BLOCK_SIZE.BITS, 12, 1L),
        STORAGE_POLICY_ID(HeaderFormat.REPLICATION.BITS, 4, 0L);

        private final LongBitFormat BITS;

        private HeaderFormat(LongBitFormat previous, int length, long min) {
            this.BITS = new LongBitFormat(this.name(), previous, length, min);
        }

        static short getReplication(long header) {
            return (short)HeaderFormat.REPLICATION.BITS.retrieve(header);
        }

        static long getPreferredBlockSize(long header) {
            return HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.retrieve(header);
        }

        static byte getStoragePolicyID(long header) {
            return (byte)HeaderFormat.STORAGE_POLICY_ID.BITS.retrieve(header);
        }

        static long toLong(long preferredBlockSize, short replication, byte storagePolicyID) {
            long h = 0L;
            if (preferredBlockSize == 0L) {
                preferredBlockSize = HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.getMin();
            }
            h = HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.combine(preferredBlockSize, h);
            h = HeaderFormat.REPLICATION.BITS.combine((long)replication, h);
            h = HeaderFormat.STORAGE_POLICY_ID.BITS.combine((long)storagePolicyID, h);
            return h;
        }
    }
}

