/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.TestViewFileSystemOverloadSchemeWithHdfsScheme;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.fs.viewfs.ViewFsTestSetup;
import org.junit.Before;

public class TestViewFSOverloadSchemeWithMountTableConfigInHDFS
extends TestViewFileSystemOverloadSchemeWithHdfsScheme {
    private Path oldVersionMountTablePath;
    private Path newVersionMountTablePath;

    @Override
    @Before
    public void startCluster() throws IOException {
        super.startCluster();
        String mountTableDir = URI.create(this.getConf().get("fs.defaultFS")).toString() + "/MountTable/";
        this.getConf().set("fs.viewfs.mounttable.path", mountTableDir);
        FileSystem fs = new ViewFileSystemOverloadScheme.ChildFsGetter("hdfs").getNewInstance(new Path(mountTableDir).toUri(), this.getConf());
        fs.mkdirs(new Path(mountTableDir));
        String oldVersionMountTable = "mount-table.30.xml";
        String newVersionMountTable = "mount-table.31.xml";
        this.oldVersionMountTablePath = new Path(mountTableDir, oldVersionMountTable);
        this.newVersionMountTablePath = new Path(mountTableDir, newVersionMountTable);
        fs.createNewFile(this.oldVersionMountTablePath);
        fs.createNewFile(this.newVersionMountTablePath);
    }

    @Override
    void addMountLinks(String mountTable, String[] sources, String[] targets, Configuration config) throws IOException, URISyntaxException {
        ViewFsTestSetup.addMountLinksToFile((String)mountTable, (String[])sources, (String[])targets, (Path)this.newVersionMountTablePath, (Configuration)this.getConf());
    }
}

