/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestWriteReadStripedFile {
    public static final Logger LOG = LoggerFactory.getLogger(TestWriteReadStripedFile.class);
    private final ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByID((byte)2);
    private final int cellSize = this.ecPolicy.getCellSize();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final int numDNs = this.dataBlocks + this.parityBlocks;
    private final int stripesPerBlock = 2;
    private final int blockSize = 2 * this.cellSize;
    private final int blockGroupSize = this.blockSize * this.dataBlocks;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private Configuration conf = new HdfsConfiguration();
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Before
    public void setup() throws IOException {
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.numDNs).build();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(this.ecPolicy.getName());
        this.fs.mkdirs(new Path("/ec"));
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy("/ec", this.ecPolicy.getName());
    }

    @After
    public void tearDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testFileEmpty() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/EmptyFile", 0);
        this.testOneFileUsingDFSStripedInputStream("/ec/EmptyFile2", 0, true);
    }

    @Test
    public void testFileSmallerThanOneCell1() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/SmallerThanOneCell", 1);
        this.testOneFileUsingDFSStripedInputStream("/ec/SmallerThanOneCell2", 1, true);
    }

    @Test
    public void testFileSmallerThanOneCell2() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/SmallerThanOneCell", this.cellSize - 1);
        this.testOneFileUsingDFSStripedInputStream("/ec/SmallerThanOneCell2", this.cellSize - 1, true);
    }

    @Test
    public void testFileEqualsWithOneCell() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/EqualsWithOneCell", this.cellSize);
        this.testOneFileUsingDFSStripedInputStream("/ec/EqualsWithOneCell2", this.cellSize, true);
    }

    @Test
    public void testFileSmallerThanOneStripe1() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/SmallerThanOneStripe", this.cellSize * this.dataBlocks - 1);
        this.testOneFileUsingDFSStripedInputStream("/ec/SmallerThanOneStripe2", this.cellSize * this.dataBlocks - 1, true);
    }

    @Test
    public void testFileSmallerThanOneStripe2() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/SmallerThanOneStripe", this.cellSize + 123);
        this.testOneFileUsingDFSStripedInputStream("/ec/SmallerThanOneStripe2", this.cellSize + 123, true);
    }

    @Test
    public void testFileEqualsWithOneStripe() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/EqualsWithOneStripe", this.cellSize * this.dataBlocks);
        this.testOneFileUsingDFSStripedInputStream("/ec/EqualsWithOneStripe2", this.cellSize * this.dataBlocks, true);
    }

    @Test
    public void testFileMoreThanOneStripe1() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanOneStripe1", this.cellSize * this.dataBlocks + 123);
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanOneStripe12", this.cellSize * this.dataBlocks + 123, true);
    }

    @Test
    public void testFileMoreThanOneStripe2() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanOneStripe2", this.cellSize * this.dataBlocks + this.cellSize * this.dataBlocks + 123);
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanOneStripe22", this.cellSize * this.dataBlocks + this.cellSize * this.dataBlocks + 123, true);
    }

    @Test
    public void testLessThanFullBlockGroup() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/LessThanFullBlockGroup", this.cellSize * this.dataBlocks * 1 + this.cellSize);
        this.testOneFileUsingDFSStripedInputStream("/ec/LessThanFullBlockGroup2", this.cellSize * this.dataBlocks * 1 + this.cellSize, true);
    }

    @Test
    public void testFileFullBlockGroup() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/FullBlockGroup", this.blockSize * this.dataBlocks);
        this.testOneFileUsingDFSStripedInputStream("/ec/FullBlockGroup2", this.blockSize * this.dataBlocks, true);
    }

    @Test
    public void testFileMoreThanABlockGroup1() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanABlockGroup1", this.blockSize * this.dataBlocks + 123);
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanABlockGroup12", this.blockSize * this.dataBlocks + 123, true);
    }

    @Test
    public void testFileMoreThanABlockGroup2() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanABlockGroup2", this.blockSize * this.dataBlocks + this.cellSize + 123);
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanABlockGroup22", this.blockSize * this.dataBlocks + this.cellSize + 123, true);
    }

    @Test
    public void testFileMoreThanABlockGroup3() throws Exception {
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanABlockGroup3", this.blockSize * this.dataBlocks * 3 + this.cellSize * this.dataBlocks + this.cellSize + 123);
        this.testOneFileUsingDFSStripedInputStream("/ec/MoreThanABlockGroup32", this.blockSize * this.dataBlocks * 3 + this.cellSize * this.dataBlocks + this.cellSize + 123, true);
    }

    private void testOneFileUsingDFSStripedInputStream(String src, int fileLength) throws Exception {
        this.testOneFileUsingDFSStripedInputStream(src, fileLength, false);
    }

    private void testOneFileUsingDFSStripedInputStream(String src, int fileLength, boolean withDataNodeFailure) throws Exception {
        byte[] expected = StripedFileTestUtil.generateBytes(fileLength);
        Path srcPath = new Path(src);
        DFSTestUtil.writeFile((FileSystem)this.fs, srcPath, new String(expected));
        StripedFileTestUtil.waitBlockGroupsReported(this.fs, src);
        StripedFileTestUtil.verifyLength((FileSystem)this.fs, srcPath, fileLength);
        if (withDataNodeFailure) {
            int dnIndex = 1;
            LOG.info("stop DataNode " + dnIndex);
            this.stopDataNode(srcPath, dnIndex);
        }
        byte[] smallBuf = new byte[1024];
        byte[] largeBuf = new byte[fileLength + 100];
        StripedFileTestUtil.verifyPread(this.fs, srcPath, fileLength, expected, largeBuf);
        StripedFileTestUtil.verifyStatefulRead((FileSystem)this.fs, srcPath, fileLength, expected, largeBuf);
        StripedFileTestUtil.verifySeek((FileSystem)this.fs, srcPath, fileLength, this.ecPolicy, this.blockGroupSize);
        StripedFileTestUtil.verifyStatefulRead((FileSystem)this.fs, srcPath, fileLength, expected, ByteBuffer.allocate(fileLength + 100));
        StripedFileTestUtil.verifyStatefulRead((FileSystem)this.fs, srcPath, fileLength, expected, smallBuf);
        StripedFileTestUtil.verifyStatefulRead((FileSystem)this.fs, srcPath, fileLength, expected, ByteBuffer.allocate(1024));
    }

    private void stopDataNode(Path path, int failedDNIdx) throws IOException {
        BlockLocation[] locs = this.fs.getFileBlockLocations(path, 0L, (long)this.cellSize);
        if (locs != null && locs.length > 0) {
            String name = locs[0].getNames()[failedDNIdx];
            for (DataNode dn : this.cluster.getDataNodes()) {
                int port = dn.getXferPort();
                if (!name.contains(Integer.toString(port))) continue;
                dn.shutdown();
                break;
            }
        }
    }

    @Test
    public void testWriteReadUsingWebHdfs() throws Exception {
        int fileLength = this.blockSize * this.dataBlocks + this.cellSize + 123;
        byte[] expected = StripedFileTestUtil.generateBytes(fileLength);
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(this.conf, "webhdfs");
        Path srcPath = new Path("/testWriteReadUsingWebHdfs");
        DFSTestUtil.writeFile((FileSystem)fs, srcPath, new String(expected));
        StripedFileTestUtil.verifyLength((FileSystem)fs, srcPath, fileLength);
        byte[] smallBuf = new byte[1024];
        byte[] largeBuf = new byte[fileLength + 100];
        StripedFileTestUtil.verifyPread((FileSystem)fs, srcPath, fileLength, expected, largeBuf, this.ecPolicy);
        StripedFileTestUtil.verifyStatefulRead((FileSystem)fs, srcPath, fileLength, expected, largeBuf);
        StripedFileTestUtil.verifySeek((FileSystem)fs, srcPath, fileLength, this.ecPolicy, this.blockGroupSize);
        StripedFileTestUtil.verifyStatefulRead((FileSystem)fs, srcPath, fileLength, expected, smallBuf);
    }

    @Test
    public void testConcat() throws Exception {
        byte[] data = StripedFileTestUtil.generateBytes(this.blockSize * this.dataBlocks * 10 + 234);
        int totalLength = 0;
        Random r = new Random();
        Path target = new Path("/ec/testConcat_target");
        DFSTestUtil.writeFile((FileSystem)this.fs, target, Arrays.copyOfRange(data, 0, 123));
        totalLength += 123;
        int numFiles = 5;
        Path[] srcs = new Path[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            srcs[i] = new Path("/ec/testConcat_src_file_" + i);
            int srcLength = r.nextInt(this.blockSize * this.dataBlocks * 2) + 1;
            DFSTestUtil.writeFile((FileSystem)this.fs, srcs[i], Arrays.copyOfRange(data, totalLength, totalLength + srcLength));
            totalLength += srcLength;
        }
        this.fs.concat(target, srcs);
        StripedFileTestUtil.verifyStatefulRead((FileSystem)this.fs, target, totalLength, Arrays.copyOfRange(data, 0, totalLength), new byte[1024]);
    }

    @Test
    public void testConcatWithDifferentECPolicy() throws Exception {
        byte[] data = StripedFileTestUtil.generateBytes(this.blockSize * this.dataBlocks);
        Path nonECFile = new Path("/non_ec_file");
        DFSTestUtil.writeFile((FileSystem)this.fs, nonECFile, data);
        Path target = new Path("/ec/non_ec_file");
        this.fs.rename(nonECFile, target);
        int numFiles = 2;
        Path[] srcs = new Path[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            srcs[i] = new Path("/ec/testConcat_src_file_" + i);
            DFSTestUtil.writeFile((FileSystem)this.fs, srcs[i], data);
        }
        try {
            this.fs.concat(target, srcs);
            Assert.fail((String)"non-ec file shouldn't concat with ec file");
        }
        catch (RemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("have different erasure coding policy"));
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DFSOutputStream.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DataStreamer.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)BlockPlacementPolicy.LOG, (Level)Level.TRACE);
    }
}

