/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class TestTriggerBlockReport {
    private void testTriggerBlockReport(boolean incremental, boolean withSpecificNN) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 10800000L);
        conf.setLong("dfs.heartbeat.interval", 1080L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        cluster.waitActive();
        cluster.transitionToActive(0);
        DistributedFileSystem fs = cluster.getFileSystem(0);
        DatanodeProtocolClientSideTranslatorPB spyOnNn0 = InternalDataNodeTestUtils.spyOnBposToNN(cluster.getDataNodes().get(0), cluster.getNameNode(0));
        DatanodeProtocolClientSideTranslatorPB spyOnNn1 = InternalDataNodeTestUtils.spyOnBposToNN(cluster.getDataNodes().get(0), cluster.getNameNode(1));
        DFSTestUtil.createFile((FileSystem)fs, new Path("/abc"), 16L, (short)1, 1L);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn0, (VerificationMode)Mockito.timeout((int)60000).times(1))).blockReceivedAndDeleted((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageReceivedDeletedBlocks[])Matchers.any(StorageReceivedDeletedBlocks[].class));
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn1, (VerificationMode)Mockito.timeout((int)60000).times(1))).blockReceivedAndDeleted((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageReceivedDeletedBlocks[])Matchers.any(StorageReceivedDeletedBlocks[].class));
        for (int i = 0; i < 3; ++i) {
            Thread.sleep(10L);
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn0, (VerificationMode)Mockito.times((int)0))).blockReport((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageBlockReport[])Matchers.any(StorageBlockReport[].class), (BlockReportContext)Mockito.anyObject());
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn0, (VerificationMode)Mockito.times((int)1))).blockReceivedAndDeleted((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageReceivedDeletedBlocks[])Matchers.any(StorageReceivedDeletedBlocks[].class));
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn1, (VerificationMode)Mockito.times((int)0))).blockReport((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageBlockReport[])Matchers.any(StorageBlockReport[].class), (BlockReportContext)Matchers.any());
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn1, (VerificationMode)Mockito.times((int)1))).blockReceivedAndDeleted((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageReceivedDeletedBlocks[])Matchers.any(StorageReceivedDeletedBlocks[].class));
        }
        ReceivedDeletedBlockInfo rdbi = new ReceivedDeletedBlockInfo(new Block(5678L, 512L, 1000L), ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK, null);
        DataNode datanode = cluster.getDataNodes().get(0);
        for (BPServiceActor actor : ((BPOfferService)datanode.getAllBpOs().get(0)).getBPServiceActors()) {
            DatanodeStorage storage;
            FsDatasetSpi dataset = datanode.getFSDataset();
            try (FsDatasetSpi.FsVolumeReferences volumes = dataset.getFsVolumeReferences();){
                storage = dataset.getStorage(volumes.get(0).getStorageID());
            }
            actor.getIbrManager().addRDBI(rdbi, storage);
        }
        InetSocketAddress nnAddr = withSpecificNN ? cluster.getNameNode(1).getServiceRpcAddress() : null;
        datanode.triggerBlockReport(new BlockReportOptions.Factory().setNamenodeAddr(nnAddr).setIncremental(incremental).build());
        if (incremental) {
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn1, (VerificationMode)Mockito.timeout((int)60000).times(2))).blockReceivedAndDeleted((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageReceivedDeletedBlocks[])Matchers.any(StorageReceivedDeletedBlocks[].class));
            int nn0IncrBlockReport = withSpecificNN ? 1 : 2;
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn0, (VerificationMode)Mockito.timeout((int)60000).times(nn0IncrBlockReport))).blockReceivedAndDeleted((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageReceivedDeletedBlocks[])Matchers.any(StorageReceivedDeletedBlocks[].class));
        } else {
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn1, (VerificationMode)Mockito.timeout((int)60000).times(1))).blockReport((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageBlockReport[])Matchers.any(StorageBlockReport[].class), (BlockReportContext)Matchers.any());
            int nn0BlockReport = withSpecificNN ? 0 : 1;
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spyOnNn0, (VerificationMode)Mockito.timeout((int)60000).times(nn0BlockReport))).blockReport((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageBlockReport[])Matchers.any(StorageBlockReport[].class), (BlockReportContext)Mockito.anyObject());
        }
        cluster.shutdown();
    }

    @Test
    public void testTriggerFullBlockReport() throws Exception {
        this.testTriggerBlockReport(false, false);
        this.testTriggerBlockReport(false, true);
    }

    @Test
    public void testTriggerIncrementalBlockReport() throws Exception {
        this.testTriggerBlockReport(true, false);
        this.testTriggerBlockReport(true, true);
    }
}

