/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.Counters;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobMapTaskRescheduledEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptCompletedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerFailedEvent;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

public abstract class TaskImpl
implements Task,
EventHandler<TaskEvent> {
    private static final Log LOG = LogFactory.getLog(TaskImpl.class);
    protected final Configuration conf;
    protected final Path jobFile;
    protected final OutputCommitter committer;
    protected final int partition;
    protected final TaskAttemptListener taskAttemptListener;
    protected final EventHandler eventHandler;
    private final TaskId taskId;
    private Map<TaskAttemptId, TaskAttempt> attempts;
    private final int maxAttempts;
    protected final Clock clock;
    private final Lock readLock;
    private final Lock writeLock;
    private final MRAppMetrics metrics;
    private long scheduledTime;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected Collection<Token<? extends TokenIdentifier>> fsTokens;
    protected Token<JobTokenIdentifier> jobToken;
    private int numberUncompletedAttempts = 0;
    private boolean historyTaskStartGenerated = false;
    private static final SingleArcTransition<TaskImpl, TaskEvent> ATTEMPT_KILLED_TRANSITION = new AttemptKilledTransition();
    private static final SingleArcTransition<TaskImpl, TaskEvent> KILL_TRANSITION = new KillTransition();
    private static final StateMachineFactory<TaskImpl, TaskState, TaskEventType, TaskEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskState.NEW).addTransition((Enum)TaskState.NEW, (Enum)TaskState.SCHEDULED, (Enum)TaskEventType.T_SCHEDULE, (SingleArcTransition)new InitialScheduleTransition()).addTransition((Enum)TaskState.NEW, (Enum)TaskState.KILLED, (Enum)TaskEventType.T_KILL, (SingleArcTransition)new KillNewTransition()).addTransition((Enum)TaskState.SCHEDULED, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED, (SingleArcTransition)new LaunchTransition()).addTransition((Enum)TaskState.SCHEDULED, (Enum)TaskState.KILL_WAIT, (Enum)TaskEventType.T_KILL, KILL_TRANSITION).addTransition((Enum)TaskState.SCHEDULED, (Enum)TaskState.SCHEDULED, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskState.SCHEDULED, EnumSet.of(TaskState.SCHEDULED, TaskState.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition()).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ATTEMPT_COMMIT_PENDING, (SingleArcTransition)new AttemptCommitPendingTransition()).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ADD_SPEC_ATTEMPT, (SingleArcTransition)new RedundantScheduleTransition()).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.SUCCEEDED, (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (SingleArcTransition)new AttemptSucceededTransition()).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskState.RUNNING, EnumSet.of(TaskState.RUNNING, TaskState.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition()).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.KILL_WAIT, (Enum)TaskEventType.T_KILL, KILL_TRANSITION).addTransition((Enum)TaskState.KILL_WAIT, EnumSet.of(TaskState.KILL_WAIT, TaskState.KILLED), (Enum)TaskEventType.T_ATTEMPT_KILLED, (MultipleArcTransition)new KillWaitAttemptKilledTransition()).addTransition((Enum)TaskState.KILL_WAIT, (Enum)TaskState.KILL_WAIT, EnumSet.of(TaskEventType.T_KILL, new TaskEventType[]{TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ATTEMPT_FAILED, TaskEventType.T_ATTEMPT_SUCCEEDED, TaskEventType.T_ADD_SPEC_ATTEMPT})).addTransition((Enum)TaskState.SUCCEEDED, EnumSet.of(TaskState.SCHEDULED, TaskState.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new MapRetroactiveFailureTransition()).addTransition((Enum)TaskState.SUCCEEDED, (Enum)TaskState.SUCCEEDED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_KILLED)).addTransition((Enum)TaskState.FAILED, (Enum)TaskState.FAILED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ADD_SPEC_ATTEMPT)).addTransition((Enum)TaskState.KILLED, (Enum)TaskState.KILLED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ADD_SPEC_ATTEMPT)).installTopology();
    private final StateMachine<TaskState, TaskEventType, TaskEvent> stateMachine;
    protected int nextAttemptNumber;
    private TaskAttemptId commitAttempt;
    private TaskAttemptId successfulAttempt;
    private int failedAttempts;
    private int finishedAttempts;

    @Override
    public TaskState getState() {
        return (TaskState)this.stateMachine.getCurrentState();
    }

    public TaskImpl(JobId jobId, TaskType taskType, int partition, EventHandler eventHandler, Path remoteJobConfFile, Configuration conf, TaskAttemptListener taskAttemptListener, OutputCommitter committer, Token<JobTokenIdentifier> jobToken, Collection<Token<? extends TokenIdentifier>> fsTokens, Clock clock, Set<TaskId> completedTasksFromPreviousRun, int startCount, MRAppMetrics metrics) {
        this.conf = conf;
        this.clock = clock;
        this.jobFile = remoteJobConfFile;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.attempts = Collections.emptyMap();
        this.maxAttempts = this.getMaxAttempts();
        this.taskId = (TaskId)this.recordFactory.newRecordInstance(TaskId.class);
        this.taskId.setJobId(jobId);
        this.taskId.setId(partition);
        this.taskId.setTaskType(taskType);
        this.partition = partition;
        this.taskAttemptListener = taskAttemptListener;
        this.eventHandler = eventHandler;
        this.committer = committer;
        this.fsTokens = fsTokens;
        this.jobToken = jobToken;
        this.metrics = metrics;
        if (completedTasksFromPreviousRun != null && completedTasksFromPreviousRun.contains(this.taskId)) {
            LOG.info((Object)("Task is from previous run " + this.taskId));
            --startCount;
        }
        this.nextAttemptNumber = (startCount - 1) * 1000;
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TaskAttemptId, TaskAttempt> getAttempts() {
        this.readLock.lock();
        try {
            if (this.attempts.size() <= 1) {
                Map<TaskAttemptId, TaskAttempt> map = this.attempts;
                return map;
            }
            LinkedHashMap<TaskAttemptId, TaskAttempt> result = new LinkedHashMap<TaskAttemptId, TaskAttempt>();
            result.putAll(this.attempts);
            LinkedHashMap<TaskAttemptId, TaskAttempt> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttempt getAttempt(TaskAttemptId attemptID) {
        this.readLock.lock();
        try {
            TaskAttempt taskAttempt = this.attempts.get(attemptID);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskId getID() {
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getState() == TaskState.SUCCEEDED || this.getState() == TaskState.FAILED || this.getState() == TaskState.KILLED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskReport getReport() {
        TaskReport report = (TaskReport)this.recordFactory.newRecordInstance(TaskReport.class);
        this.readLock.lock();
        try {
            report.setTaskId(this.taskId);
            report.setStartTime(this.getLaunchTime());
            report.setFinishTime(this.getFinishTime());
            report.setTaskState(this.getState());
            report.setProgress(this.getProgress());
            report.setCounters(this.getCounters());
            for (TaskAttempt attempt : this.attempts.values()) {
                if (!TaskAttemptState.RUNNING.equals((Object)attempt.getState())) continue;
                report.addRunningAttempt(attempt.getID());
            }
            report.setSuccessfulAttempt(this.successfulAttempt);
            for (TaskAttempt att : this.attempts.values()) {
                String prefix = "AttemptID:" + att.getID() + " Info:";
                for (String cs : att.getDiagnostics()) {
                    report.addDiagnostics(prefix + cs);
                }
            }
            TaskReport taskReport = report;
            return taskReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getCounters() {
        Counters counters = null;
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            counters = bestAttempt != null ? bestAttempt.getCounters() : (Counters)this.recordFactory.newRecordInstance(Counters.class);
            Counters counters2 = counters;
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            if (bestAttempt == null) {
                float f = 0.0f;
                return f;
            }
            float f = bestAttempt.getProgress();
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private long getLaunchTime() {
        long launchTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (launchTime != 0L && launchTime <= at.getLaunchTime()) continue;
            launchTime = at.getLaunchTime();
        }
        if (launchTime == 0L) {
            return this.scheduledTime;
        }
        return launchTime;
    }

    private long getFinishTime() {
        if (!this.isFinished()) {
            return 0L;
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (finishTime >= at.getFinishTime()) continue;
            finishTime = at.getFinishTime();
        }
        return finishTime;
    }

    private long getFinishTime(TaskAttemptId taId) {
        if (taId == null) {
            return this.clock.getTime();
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (!at.getID().equals((Object)taId)) continue;
            return at.getFinishTime();
        }
        return finishTime;
    }

    private TaskState finished(TaskState finalState) {
        if (this.getState() == TaskState.RUNNING) {
            this.metrics.endRunningTask(this);
        }
        return finalState;
    }

    private TaskAttempt selectBestAttempt() {
        float progress = 0.0f;
        TaskAttempt result = null;
        block3: for (TaskAttempt at : this.attempts.values()) {
            switch (at.getState()) {
                case FAIL_CONTAINER_CLEANUP: 
                case FAIL_TASK_CLEANUP: 
                case FAILED: 
                case KILL_CONTAINER_CLEANUP: 
                case KILL_TASK_CLEANUP: 
                case KILLED: {
                    continue block3;
                }
            }
            if (result == null) {
                result = at;
            }
            if (!(at.getProgress() > progress)) continue;
            result = at;
            progress = at.getProgress();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canCommit(TaskAttemptId taskAttemptID) {
        this.readLock.lock();
        boolean canCommit = false;
        try {
            if (this.commitAttempt != null) {
                canCommit = taskAttemptID.equals((Object)this.commitAttempt);
                LOG.info((Object)("Result of canCommit for " + taskAttemptID + ":" + canCommit));
            }
        }
        finally {
            this.readLock.unlock();
        }
        return canCommit;
    }

    protected abstract TaskAttemptImpl createAttempt();

    protected abstract int getMaxAttempts();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskAttempt getSuccessfulAttempt() {
        this.readLock.lock();
        try {
            if (null == this.successfulAttempt) {
                TaskAttempt taskAttempt = null;
                return taskAttempt;
            }
            TaskAttempt taskAttempt = this.attempts.get(this.successfulAttempt);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addAndScheduleAttempt() {
        TaskAttemptImpl attempt = this.createAttempt();
        LOG.info((Object)("Created attempt " + attempt.getID()));
        switch (this.attempts.size()) {
            case 0: {
                this.attempts = Collections.singletonMap(attempt.getID(), attempt);
                break;
            }
            case 1: {
                LinkedHashMap<TaskAttemptId, TaskAttempt> newAttempts = new LinkedHashMap<TaskAttemptId, TaskAttempt>(this.maxAttempts);
                newAttempts.putAll(this.attempts);
                this.attempts = newAttempts;
                this.attempts.put(attempt.getID(), attempt);
                break;
            }
            default: {
                this.attempts.put(attempt.getID(), attempt);
            }
        }
        ++this.nextAttemptNumber;
        ++this.numberUncompletedAttempts;
        if (this.failedAttempts > 0) {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_RESCHEDULE));
        } else {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_SCHEDULE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskEvent event) {
        LOG.info((Object)("Processing " + event.getTaskID() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            TaskState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.taskId), (Throwable)e);
                this.internalError((TaskEventType)event.getType());
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.taskId + " Task Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void internalError(TaskEventType type) {
        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(this.taskId.getJobId(), "Invalid event " + (Object)((Object)type) + " on Task " + this.taskId));
        this.eventHandler.handle((Event)new JobEvent(this.taskId.getJobId(), JobEventType.INTERNAL_ERROR));
    }

    private void handleTaskAttemptCompletion(TaskAttemptId attemptId, TaskAttemptCompletionEventStatus status) {
        ++this.finishedAttempts;
        TaskAttempt attempt = this.attempts.get(attemptId);
        if (attempt.getNodeHttpAddress() != null) {
            TaskAttemptCompletionEvent tce = (TaskAttemptCompletionEvent)this.recordFactory.newRecordInstance(TaskAttemptCompletionEvent.class);
            tce.setEventId(-1);
            tce.setMapOutputServerAddress("http://" + attempt.getNodeHttpAddress().split(":")[0] + ":" + attempt.getShufflePort());
            tce.setStatus(status);
            tce.setAttemptId(attempt.getID());
            int runTime = 0;
            if (attempt.getFinishTime() != 0L && attempt.getLaunchTime() != 0L) {
                runTime = (int)(attempt.getFinishTime() - attempt.getLaunchTime());
            }
            tce.setAttemptRunTime(runTime);
            this.eventHandler.handle((Event)new JobTaskAttemptCompletedEvent(tce));
        }
    }

    private static TaskFinishedEvent createTaskFinishedEvent(TaskImpl task, TaskState taskState) {
        TaskFinishedEvent tfe = new TaskFinishedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), task.getFinishTime(task.successfulAttempt), TypeConverter.fromYarn((TaskType)task.taskId.getTaskType()), taskState.toString(), TypeConverter.fromYarn((Counters)task.getCounters()));
        return tfe;
    }

    private static TaskFailedEvent createTaskFailedEvent(TaskImpl task, List<String> diag, TaskState taskState, TaskAttemptId taId) {
        StringBuilder errorSb = new StringBuilder();
        if (diag != null) {
            for (String d : diag) {
                errorSb.append(", ").append(d);
            }
        }
        TaskFailedEvent taskFailedEvent = new TaskFailedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), task.getFinishTime(taId), TypeConverter.fromYarn((TaskType)task.getType()), errorSb.toString(), taskState.toString(), (TaskAttemptID)(taId == null ? null : TypeConverter.fromYarn((TaskAttemptId)taId)));
        return taskFailedEvent;
    }

    protected String getSplitsAsString() {
        return "";
    }

    private void killUnfinishedAttempt(TaskAttempt attempt, String logMsg) {
        if (attempt != null && !attempt.isFinished()) {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_KILL));
        }
    }

    static class LaunchTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        LaunchTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            task.metrics.launchedTask(task);
            task.metrics.runningTask(task);
        }
    }

    private static class KillTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            for (TaskAttempt attempt : task.attempts.values()) {
                task.killUnfinishedAttempt(attempt, "Task KILL is received. Killing attempt!");
            }
            task.numberUncompletedAttempts = 0;
        }
    }

    private static class KillNewTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillNewTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            if (task.historyTaskStartGenerated) {
                TaskFailedEvent taskFailedEvent = TaskImpl.createTaskFailedEvent(task, null, TaskState.KILLED, null);
                task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)taskFailedEvent));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getID()));
            }
            task.eventHandler.handle((Event)new JobTaskEvent(task.taskId, TaskState.KILLED));
            task.metrics.endWaitingTask(task);
        }
    }

    private static class MapRetroactiveFailureTransition
    extends AttemptFailedTransition {
        private MapRetroactiveFailureTransition() {
        }

        @Override
        public TaskState transition(TaskImpl task, TaskEvent event) {
            if (!TaskType.MAP.equals((Object)task.getType())) {
                LOG.error((Object)("Unexpected event for REDUCE task " + event.getType()));
                task.internalError((TaskEventType)event.getType());
            }
            task.eventHandler.handle((Event)new JobMapTaskRescheduledEvent(task.taskId));
            this.unSucceed(task);
            return super.transition(task, event);
        }

        @Override
        protected TaskState getDefaultState(Task task) {
            return TaskState.SCHEDULED;
        }
    }

    private static class AttemptFailedTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskState> {
        private AttemptFailedTransition() {
        }

        public TaskState transition(TaskImpl task, TaskEvent event) {
            task.failedAttempts++;
            TaskTAttemptEvent castEvent = (TaskTAttemptEvent)event;
            TaskAttempt attempt = (TaskAttempt)task.attempts.get(castEvent.getTaskAttemptID());
            if (attempt.getAssignedContainerMgrAddress() != null) {
                task.eventHandler.handle((Event)new ContainerFailedEvent(attempt.getID(), attempt.getAssignedContainerMgrAddress()));
            }
            if (task.failedAttempts < task.maxAttempts) {
                task.handleTaskAttemptCompletion(((TaskTAttemptEvent)event).getTaskAttemptID(), TaskAttemptCompletionEventStatus.FAILED);
                if (--task.numberUncompletedAttempts == 0 && task.successfulAttempt == null) {
                    task.addAndScheduleAttempt();
                }
            } else {
                task.handleTaskAttemptCompletion(((TaskTAttemptEvent)event).getTaskAttemptID(), TaskAttemptCompletionEventStatus.TIPFAILED);
                TaskTAttemptEvent ev = (TaskTAttemptEvent)event;
                TaskAttemptId taId = ev.getTaskAttemptID();
                if (task.historyTaskStartGenerated) {
                    TaskFailedEvent taskFailedEvent = TaskImpl.createTaskFailedEvent(task, attempt.getDiagnostics(), TaskState.FAILED, taId);
                    task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)taskFailedEvent));
                } else {
                    LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getID()));
                }
                task.eventHandler.handle((Event)new JobTaskEvent(task.taskId, TaskState.FAILED));
                return task.finished(TaskState.FAILED);
            }
            return this.getDefaultState(task);
        }

        protected TaskState getDefaultState(Task task) {
            return task.getState();
        }

        protected void unSucceed(TaskImpl task) {
            ++task.numberUncompletedAttempts;
            task.successfulAttempt = null;
        }
    }

    private static class KillWaitAttemptKilledTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskState> {
        protected TaskState finalState = TaskState.KILLED;

        private KillWaitAttemptKilledTransition() {
        }

        public TaskState transition(TaskImpl task, TaskEvent event) {
            task.handleTaskAttemptCompletion(((TaskTAttemptEvent)event).getTaskAttemptID(), TaskAttemptCompletionEventStatus.KILLED);
            if (task.finishedAttempts == task.attempts.size()) {
                if (task.historyTaskStartGenerated) {
                    TaskFailedEvent taskFailedEvent = TaskImpl.createTaskFailedEvent(task, null, this.finalState, null);
                    task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)taskFailedEvent));
                } else {
                    LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getID()));
                }
                task.eventHandler.handle((Event)new JobTaskEvent(task.taskId, this.finalState));
                return this.finalState;
            }
            return task.getState();
        }
    }

    private static class AttemptKilledTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptKilledTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            task.handleTaskAttemptCompletion(((TaskTAttemptEvent)event).getTaskAttemptID(), TaskAttemptCompletionEventStatus.KILLED);
            --task.numberUncompletedAttempts;
            if (task.successfulAttempt == null) {
                task.addAndScheduleAttempt();
            }
        }
    }

    private static class AttemptSucceededTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptSucceededTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            task.handleTaskAttemptCompletion(((TaskTAttemptEvent)event).getTaskAttemptID(), TaskAttemptCompletionEventStatus.SUCCEEDED);
            --task.numberUncompletedAttempts;
            task.successfulAttempt = ((TaskTAttemptEvent)event).getTaskAttemptID();
            task.eventHandler.handle((Event)new JobTaskEvent(task.taskId, TaskState.SUCCEEDED));
            LOG.info((Object)("Task succeeded with attempt " + task.successfulAttempt));
            if (task.historyTaskStartGenerated) {
                TaskFinishedEvent tfe = TaskImpl.createTaskFinishedEvent(task, TaskState.SUCCEEDED);
                task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)tfe));
            }
            for (TaskAttempt attempt : task.attempts.values()) {
                if (attempt.getID() == task.successfulAttempt || attempt.isFinished()) continue;
                LOG.info((Object)("Issuing kill to other attempt " + attempt.getID()));
                task.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_KILL));
            }
            task.finished(TaskState.SUCCEEDED);
        }
    }

    private static class AttemptCommitPendingTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptCommitPendingTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskTAttemptEvent ev = (TaskTAttemptEvent)event;
            TaskAttemptId attemptID = ev.getTaskAttemptID();
            if (task.commitAttempt == null) {
                task.commitAttempt = attemptID;
                LOG.info((Object)(attemptID + " given a go for committing the task output."));
            } else {
                LOG.info((Object)(task.commitAttempt + " already given a go for committing the task output, so killing " + attemptID));
                task.eventHandler.handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_KILL));
            }
        }
    }

    private static class RedundantScheduleTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private RedundantScheduleTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            LOG.info((Object)("Scheduling a redundant attempt for task " + task.taskId));
            task.addAndScheduleAttempt();
        }
    }

    private static class InitialScheduleTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private InitialScheduleTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            task.addAndScheduleAttempt();
            task.scheduledTime = task.clock.getTime();
            TaskStartedEvent tse = new TaskStartedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), task.getLaunchTime(), TypeConverter.fromYarn((TaskType)task.taskId.getTaskType()), task.getSplitsAsString());
            task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)tse));
            task.historyTaskStartGenerated = true;
        }
    }
}

