/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.Records;

public class ContainerLauncherImpl
extends AbstractService
implements ContainerLauncher {
    static final Log LOG = LogFactory.getLog(ContainerLauncherImpl.class);
    int nmTimeOut;
    private AppContext context;
    private ThreadPoolExecutor launcherPool;
    private static final int INITIAL_POOL_SIZE = 10;
    private int limitOnPoolSize;
    private Thread eventHandlingThread;
    private BlockingQueue<ContainerLauncherEvent> eventQueue = new LinkedBlockingQueue<ContainerLauncherEvent>();
    final Timer commandTimer = new Timer(true);
    YarnRPC rpc;
    Set<String> allNodes = new HashSet<String>();

    public ContainerLauncherImpl(AppContext context) {
        super(ContainerLauncherImpl.class.getName());
        this.context = context;
    }

    public synchronized void init(Configuration config) {
        Configuration conf = new Configuration(config);
        conf.setInt("ipc.client.connection.maxidletime", 0);
        this.limitOnPoolSize = conf.getInt("yarn.app.mapreduce.am.containerlauncher.thread-count-limit", 500);
        this.nmTimeOut = conf.getInt("yarn.app.mapreduce.am.nm-command-timeout", 60000);
        this.rpc = YarnRPC.create((Configuration)conf);
        super.init(conf);
    }

    public void start() {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build();
        this.launcherPool = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        this.eventHandlingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ContainerLauncherEvent event = null;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        event = (ContainerLauncherEvent)((Object)ContainerLauncherImpl.this.eventQueue.take());
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Returning, interrupted : " + e));
                        return;
                    }
                    int poolSize = ContainerLauncherImpl.this.launcherPool.getCorePoolSize();
                    if (poolSize != ContainerLauncherImpl.this.limitOnPoolSize) {
                        int numNodes = ContainerLauncherImpl.this.allNodes.size();
                        int idealPoolSize = Math.min(ContainerLauncherImpl.this.limitOnPoolSize, numNodes);
                        if (poolSize <= idealPoolSize) {
                            int newPoolSize = idealPoolSize + 10;
                            LOG.info((Object)("Setting ContainerLauncher pool size to " + newPoolSize));
                            ContainerLauncherImpl.this.launcherPool.setCorePoolSize(newPoolSize);
                        }
                    }
                    ContainerLauncherImpl.this.launcherPool.execute(new EventProcessor(event));
                }
            }
        });
        this.eventHandlingThread.setName("ContainerLauncher Event Handler");
        this.eventHandlingThread.start();
        super.start();
    }

    public void stop() {
        this.eventHandlingThread.interrupt();
        this.launcherPool.shutdownNow();
        super.stop();
    }

    protected ContainerManager getCMProxy(ContainerId containerID, final String containerManagerBindAddr, ContainerToken containerToken) throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        this.allNodes.add(containerManagerBindAddr);
        if (UserGroupInformation.isSecurityEnabled()) {
            Token token = new Token(containerToken.getIdentifier().array(), containerToken.getPassword().array(), new Text(containerToken.getKind()), new Text(containerToken.getService()));
            user = UserGroupInformation.createRemoteUser((String)containerID.toString());
            user.addToken(token);
        }
        ContainerManager proxy = (ContainerManager)user.doAs((PrivilegedAction)new PrivilegedAction<ContainerManager>(){

            @Override
            public ContainerManager run() {
                return (ContainerManager)ContainerLauncherImpl.this.rpc.getProxy(ContainerManager.class, NetUtils.createSocketAddr((String)containerManagerBindAddr), ContainerLauncherImpl.this.getConfig());
            }
        });
        return proxy;
    }

    void sendContainerLaunchFailedMsg(TaskAttemptId taskAttemptID, String message) {
        LOG.error((Object)message);
        this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptID, message));
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED));
    }

    public void handle(ContainerLauncherEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
    }

    static /* synthetic */ AppContext access$300(ContainerLauncherImpl x0) {
        return x0.context;
    }

    static class 3 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$hadoop$mapreduce$v2$app$launcher$ContainerLauncher$EventType;

        static {
            $SwitchMap$org$apache$hadoop$mapreduce$v2$app$launcher$ContainerLauncher$EventType = new int[ContainerLauncher.EventType.values().length];
            try {
                3.$SwitchMap$org$apache$hadoop$mapreduce$v2$app$launcher$ContainerLauncher$EventType[ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$hadoop$mapreduce$v2$app$launcher$ContainerLauncher$EventType[ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class EventProcessor
    implements Runnable {
        private ContainerLauncherEvent event;

        EventProcessor(ContainerLauncherEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ContainerLauncherImpl.LOG.info((Object)("Processing the event " + this.event.toString()));
            containerManagerBindAddr = this.event.getContainerMgrAddress();
            containerID = this.event.getContainerID();
            containerToken = this.event.getContainerToken();
            taskAttemptID = this.event.getTaskAttemptID();
            proxy = null;
            timerTask = new CommandTimerTask(Thread.currentThread(), this.event);
            switch (3.$SwitchMap$org$apache$hadoop$mapreduce$v2$app$launcher$ContainerLauncher$EventType[((ContainerLauncher.EventType)this.event.getType()).ordinal()]) {
                case 1: {
                    launchEvent = (ContainerRemoteLaunchEvent)this.event;
                    ContainerLauncherImpl.this.commandTimer.schedule((TimerTask)timerTask, ContainerLauncherImpl.this.nmTimeOut);
                    proxy = ContainerLauncherImpl.this.getCMProxy(containerID, containerManagerBindAddr, containerToken);
                    if (!Thread.interrupted()) ** GOTO lbl23
                    message = "Container launch failed for " + containerID + " : Start-container for " + this.event.getContainerID() + " got interrupted. Returning.";
                    ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(taskAttemptID, message);
                    timerTask.cancel();
                    if (proxy != null) {
                        ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                    }
                    return;
lbl23:
                    // 2 sources

                    containerLaunchContext = launchEvent.getContainer();
                    startRequest = (StartContainerRequest)Records.newRecord(StartContainerRequest.class);
                    startRequest.setContainerLaunchContext(containerLaunchContext);
                    response = proxy.startContainer(startRequest);
                    timerTask.cancel();
                    if (!Thread.interrupted()) ** GOTO lbl37
                    message = "Container launch failed for " + containerID + " : Start-container for " + this.event.getContainerID() + " got interrupted. Returning.";
                    ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(taskAttemptID, message);
                    timerTask.cancel();
                    if (proxy != null) {
                        ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                    }
                    return;
lbl37:
                    // 1 sources

                    try {
                        portInfo = response.getServiceResponse("mapreduce.shuffle");
                        port = -1;
                        if (portInfo != null) {
                            port = ShuffleHandler.deserializeMetaData((ByteBuffer)portInfo);
                        }
                        ContainerLauncherImpl.LOG.info((Object)("Shuffle port returned by ContainerManager for " + taskAttemptID + " : " + port));
                        if (port < 0) {
                            throw new IllegalStateException("Invalid shuffle port number " + port + " returned for " + taskAttemptID);
                        }
                        ContainerLauncherImpl.access$300(ContainerLauncherImpl.this).getEventHandler().handle((Event)new TaskAttemptContainerLaunchedEvent(taskAttemptID, port));
                        timerTask.cancel();
                    }
                    catch (Throwable t) {
                        try {
                            if (Thread.interrupted()) {
                                ContainerLauncherImpl.LOG.info((Object)("Start-container for " + this.event.getContainerID() + " got interrupted."));
                            }
                            message = "Container launch failed for " + containerID + " : " + StringUtils.stringifyException((Throwable)t);
                            ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(taskAttemptID, message);
                            timerTask.cancel();
                        }
                        catch (Throwable var13_19) {
                            timerTask.cancel();
                            if (proxy != null) {
                                ContainerLauncherImpl.this.rpc.stopProxy(proxy, ContainerLauncherImpl.this.getConfig());
                            }
                            throw var13_19;
                        }
                        if (proxy == null) break;
                        ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                        break;
                    }
                    if (proxy == null) break;
                    ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                    break;
                }
                case 2: {
                    if (ContainerLauncherImpl.access$000(ContainerLauncherImpl.this).contains((Object)this.event)) {
                        ContainerLauncherImpl.access$000(ContainerLauncherImpl.this).remove((Object)this.event);
                        ContainerLauncherImpl.access$300(ContainerLauncherImpl.this).getEventHandler().handle((Event)new ContainerAllocatorEvent(taskAttemptID, ContainerAllocator.EventType.CONTAINER_DEALLOCATE));
                        break;
                    }
                    try {
                        ContainerLauncherImpl.this.commandTimer.schedule((TimerTask)timerTask, ContainerLauncherImpl.this.nmTimeOut);
                        proxy = ContainerLauncherImpl.this.getCMProxy(containerID, containerManagerBindAddr, containerToken);
                        if (Thread.interrupted()) {
                            ContainerLauncherImpl.LOG.info((Object)("Stop-container for " + this.event.getContainerID() + " got interrupted."));
                        } else {
                            stopRequest = (StopContainerRequest)Records.newRecord(StopContainerRequest.class);
                            stopRequest.setContainerId(this.event.getContainerID());
                            proxy.stopContainer(stopRequest);
                        }
                    }
                    catch (Throwable t) {
                        if (Thread.interrupted()) {
                            ContainerLauncherImpl.LOG.info((Object)("Stop-container for " + this.event.getContainerID() + " got interrupted."));
                        }
                        message = "cleanup failed for container " + this.event.getContainerID() + " : " + StringUtils.stringifyException((Throwable)t);
                        ContainerLauncherImpl.access$300(ContainerLauncherImpl.this).getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptID, message));
                        ContainerLauncherImpl.LOG.warn((Object)message);
                    }
                    finally {
                        timerTask.cancel();
                        if (Thread.interrupted()) {
                            ContainerLauncherImpl.LOG.info((Object)("Stop-container for " + this.event.getContainerID() + " got interrupted."));
                            ContainerLauncherImpl.access$300(ContainerLauncherImpl.this).getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptID, "cleanup failed for container " + this.event.getContainerID()));
                        }
                        if (proxy != null) {
                            ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                        }
                    }
                    ContainerLauncherImpl.access$300(ContainerLauncherImpl.this).getEventHandler().handle((Event)new TaskAttemptEvent(this.event.getTaskAttemptID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
                }
            }
        }
    }

    private static class CommandTimerTask
    extends TimerTask {
        private final Thread commandThread;
        protected final String message;
        private boolean cancelled = false;

        public CommandTimerTask(Thread thread, ContainerLauncherEvent event) {
            this.commandThread = thread;
            this.message = "Couldn't complete " + event.getType() + " on " + event.getContainerID() + "/" + event.getTaskAttemptID() + ". Interrupting and returning";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CommandTimerTask commandTimerTask = this;
            synchronized (commandTimerTask) {
                if (this.cancelled) {
                    return;
                }
                LOG.warn((Object)this.message);
                StackTraceElement[] trace = this.commandThread.getStackTrace();
                StringBuilder logMsg = new StringBuilder();
                for (int i = 0; i < trace.length; ++i) {
                    logMsg.append("\n\tat " + trace[i]);
                }
                LOG.info((Object)("Stack trace of the command-thread: \n" + logMsg.toString()));
                this.commandThread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            CommandTimerTask commandTimerTask = this;
            synchronized (commandTimerTask) {
                this.cancelled = true;
                return super.cancel();
            }
        }
    }
}

