/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMParams;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AttemptsPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.CountersPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.InfoPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobConfPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.SingleCounterPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TaskPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TasksPage;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.View;

public class AppController
extends Controller
implements AMParams {
    protected final App app;

    protected AppController(App app, Configuration conf, Controller.RequestContext ctx, String title) {
        super(ctx);
        this.app = app;
        this.set("app.id", app.context.getApplicationID().toString());
        this.set("rm.web", YarnConfiguration.getRMWebAppURL((Configuration)conf));
    }

    @Inject
    protected AppController(App app, Configuration conf, Controller.RequestContext ctx) {
        this(app, conf, ctx, "am");
    }

    public void index() {
        this.setTitle(StringHelper.join((Object[])new Object[]{"MapReduce Application ", this.$("app.id")}));
    }

    public void info() {
        this.info("Application Master Overview")._("Application ID:", (Object)this.$("app.id"))._("Application Name:", (Object)this.app.context.getApplicationName())._("User:", (Object)this.app.context.getUser())._("Started on:", (Object)Times.format((long)this.app.context.getStartTime()))._("Elasped: ", (Object)org.apache.hadoop.util.StringUtils.formatTime((long)Times.elapsed((long)this.app.context.getStartTime(), (long)0L)));
        this.render(InfoPage.class);
    }

    protected Class<? extends View> jobPage() {
        return JobPage.class;
    }

    public void job() {
        this.requireJob();
        this.render(this.jobPage());
    }

    protected Class<? extends View> countersPage() {
        return CountersPage.class;
    }

    public void jobCounters() {
        this.requireJob();
        if (this.app.getJob() != null) {
            this.setTitle(StringHelper.join((Object[])new Object[]{"Counters for ", this.$("job.id")}));
        }
        this.render(this.countersPage());
    }

    public void taskCounters() {
        this.requireTask();
        if (this.app.getTask() != null) {
            this.setTitle(StringHelper.join((Object[])new Object[]{"Counters for ", this.$("task.id")}));
        }
        this.render(this.countersPage());
    }

    protected Class<? extends View> singleCounterPage() {
        return SingleCounterPage.class;
    }

    public void singleJobCounter() throws IOException {
        this.requireJob();
        this.set("counter.group", URLDecoder.decode(this.$("counter.group"), "UTF-8"));
        this.set("counter.name", URLDecoder.decode(this.$("counter.name"), "UTF-8"));
        if (this.app.getJob() != null) {
            this.setTitle(StringHelper.join((Object[])new Object[]{this.$("counter.group"), " ", this.$("counter.name"), " for ", this.$("job.id")}));
        }
        this.render(this.singleCounterPage());
    }

    public void singleTaskCounter() throws IOException {
        this.requireTask();
        this.set("counter.group", URLDecoder.decode(this.$("counter.group"), "UTF-8"));
        this.set("counter.name", URLDecoder.decode(this.$("counter.name"), "UTF-8"));
        if (this.app.getTask() != null) {
            this.setTitle(StringHelper.join((Object[])new Object[]{this.$("counter.group"), " ", this.$("counter.name"), " for ", this.$("task.id")}));
        }
        this.render(this.singleCounterPage());
    }

    protected Class<? extends View> tasksPage() {
        return TasksPage.class;
    }

    public void tasks() {
        this.requireJob();
        if (this.app.getJob() != null) {
            try {
                String tt = this.$("task.type");
                tt = tt.isEmpty() ? "All" : StringUtils.capitalize((String)MRApps.taskType((String)tt).toString().toLowerCase(Locale.US));
                this.setTitle(StringHelper.join((Object[])new Object[]{tt, " Tasks for ", this.$("job.id")}));
            }
            catch (Exception e) {
                this.badRequest(e.getMessage());
            }
        }
        this.render(this.tasksPage());
    }

    protected Class<? extends View> taskPage() {
        return TaskPage.class;
    }

    public void task() {
        this.requireTask();
        if (this.app.getTask() != null) {
            this.setTitle(StringHelper.join((Object[])new Object[]{"Attempts for ", this.$("task.id")}));
        }
        this.render(this.taskPage());
    }

    protected Class<? extends View> attemptsPage() {
        return AttemptsPage.class;
    }

    public void attempts() {
        this.requireJob();
        if (this.app.getJob() != null) {
            try {
                String taskType = this.$("task.type");
                if (taskType.isEmpty()) {
                    throw new RuntimeException("missing task-type.");
                }
                String attemptState = this.$("attempt.state");
                if (attemptState.isEmpty()) {
                    throw new RuntimeException("missing attempt-state.");
                }
                this.setTitle(StringHelper.join((Object[])new Object[]{attemptState, " ", MRApps.taskType((String)taskType).toString(), " attempts in ", this.$("job.id")}));
                this.render(this.attemptsPage());
            }
            catch (Exception e) {
                this.badRequest(e.getMessage());
            }
        }
    }

    protected Class<? extends View> confPage() {
        return JobConfPage.class;
    }

    public void conf() {
        this.requireJob();
        this.render(this.confPage());
    }

    void badRequest(String s) {
        this.setStatus(400);
        this.setTitle(StringHelper.join((Object[])new Object[]{"Bad request: ", s}));
    }

    void notFound(String s) {
        this.setStatus(404);
        this.setTitle(StringHelper.join((Object[])new Object[]{"Not found: ", s}));
    }

    void accessDenied(String s) {
        this.setStatus(403);
        this.setTitle(StringHelper.join((Object[])new Object[]{"Access denied: ", s}));
        throw new RuntimeException("Access denied: " + s);
    }

    void checkAccess(Job job) {
        UserGroupInformation callerUgi = UserGroupInformation.createRemoteUser((String)this.request().getRemoteUser());
        if (!job.checkAccess(callerUgi, JobACL.VIEW_JOB)) {
            this.accessDenied("User " + this.request().getRemoteUser() + " does not have " + " permissions.");
        }
    }

    public void requireJob() {
        try {
            if (this.$("job.id").isEmpty()) {
                throw new RuntimeException("missing job ID");
            }
            JobId jobID = MRApps.toJobID((String)this.$("job.id"));
            this.app.setJob(this.app.context.getJob(jobID));
            if (this.app.getJob() == null) {
                this.notFound(this.$("job.id"));
            }
            Job job = this.app.context.getJob(jobID);
            this.checkAccess(job);
        }
        catch (Exception e) {
            this.badRequest(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
        }
    }

    public void requireTask() {
        try {
            if (this.$("task.id").isEmpty()) {
                throw new RuntimeException("missing task ID");
            }
            TaskId taskID = MRApps.toTaskID((String)this.$("task.id"));
            Job job = this.app.context.getJob(taskID.getJobId());
            this.app.setJob(job);
            if (this.app.getJob() == null) {
                this.notFound(MRApps.toString((JobId)taskID.getJobId()));
            } else {
                this.app.setTask(this.app.getJob().getTask(taskID));
                if (this.app.getTask() == null) {
                    this.notFound(this.$("task.id"));
                }
            }
            this.checkAccess(job);
        }
        catch (Exception e) {
            this.badRequest(e.getMessage());
        }
    }
}

