/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.util.Collection;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppView;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class TaskPage
extends AppView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:3}");
        this.set("ui.dataTables.id", "attempts");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"attempts"), this.attemptsTableInit());
        this.setTableStyles(html, "attempts", new String[0]);
    }

    @Override
    protected Class<? extends SubView> content() {
        return AttemptsBlock.class;
    }

    private String attemptsTableInit() {
        return JQueryUI.tableInit().append("}").toString();
    }

    static class AttemptsBlock
    extends HtmlBlock {
        final App app;

        @Inject
        AttemptsBlock(App ctx) {
            this.app = ctx;
        }

        protected void render(HtmlBlock.Block html) {
            if (!this.isValidRequest()) {
                html.h2(this.$("title"));
                return;
            }
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#attempts").thead().tr().th(".id", "Attempt").th(".progress", "Progress").th(".state", "State").th(".node", "node").th(".tsh", "Started").th(".tsh", "Finished").th(".tsh", "Elapsed").th(".note", "Note")._())._()).tbody();
            for (TaskAttempt ta : this.getTaskAttempts()) {
                String taid = MRApps.toString((TaskAttemptId)ta.getID());
                String progress = StringHelper.percent((double)ta.getProgress());
                ContainerId containerId = ta.getAssignedContainerID();
                String nodeHttpAddr = ta.getNodeHttpAddress();
                long startTime = ta.getLaunchTime();
                long finishTime = ta.getFinishTime();
                long elapsed = Times.elapsed((long)startTime, (long)finishTime);
                Hamlet.TD nodeTd = tbody.tr().td(".id", taid).td(".progress", progress).td(".state", ta.getState().toString()).td().a(".nodelink", this.url(new String[]{"http://", nodeHttpAddr}), nodeHttpAddr);
                if (containerId != null) {
                    String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
                    nodeTd._(new Object[]{" "}).a(".logslink", this.url(new String[]{"http://", nodeHttpAddr, "node", "containerlogs", containerIdStr, this.app.getJob().getUserName()}), "logs");
                }
                ((Hamlet.TR)nodeTd._()).td(".ts", Times.format((long)startTime)).td(".ts", Times.format((long)finishTime)).td(".dt", StringUtils.formatTime((long)elapsed)).td(".note", Joiner.on((char)'\n').join(ta.getDiagnostics()))._();
            }
            ((Hamlet.TABLE)tbody._())._();
        }

        protected boolean isValidRequest() {
            return this.app.getTask() != null;
        }

        protected Collection<TaskAttempt> getTaskAttempts() {
            return this.app.getTask().getAttempts().values();
        }
    }
}

