/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMasterTest;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventHandler;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.EventHandler;

class MRAppMasterTestLaunchTime
extends MRAppMasterTest {
    final AtomicLong jobLaunchTime = new AtomicLong(0L);

    public MRAppMasterTestLaunchTime(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String host, int port, int httpPort, long submitTime) {
        super(applicationAttemptId, containerId, host, port, httpPort, submitTime, false, false);
    }

    @Override
    protected EventHandler<CommitterEvent> createCommitterEventHandler(AppContext context, OutputCommitter committer) {
        return new CommitterEventHandler(context, committer, this.getRMHeartbeatHandler()){

            public void handle(CommitterEvent event) {
            }
        };
    }

    @Override
    protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
        return new JobHistoryEventHandler(context, this.getStartCount()){

            public void handle(JobHistoryEvent event) {
                if (event.getHistoryEvent().getEventType() == EventType.JOB_INITED) {
                    JobInitedEvent jie = (JobInitedEvent)event.getHistoryEvent();
                    MRAppMasterTestLaunchTime.this.jobLaunchTime.set(jie.getLaunchTime());
                }
                super.handle(event);
            }
        };
    }
}

