/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FileOutputCommitter
extends OutputCommitter {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.FileOutputCommitter");
    public static final String TEMP_DIR_NAME = "_temporary";
    public static final String SUCCEEDED_FILE_NAME = "_SUCCESS";
    static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";

    @Override
    public void setupJob(JobContext context) throws IOException {
        Path tmpDir;
        FileSystem fileSys;
        JobConf conf = context.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null && !(fileSys = (tmpDir = new Path(outputPath, FileOutputCommitter.getJobAttemptBaseDirName(context) + "/" + TEMP_DIR_NAME)).getFileSystem((Configuration)conf)).mkdirs(tmpDir)) {
            LOG.error((Object)("Mkdirs failed to create " + tmpDir.toString()));
        }
    }

    private boolean shouldMarkOutputDir(JobConf conf) {
        return conf.getBoolean(SUCCESSFUL_JOB_OUTPUT_DIR_MARKER, true);
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        JobConf conf = context.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null) {
            FileSystem outputFileSystem = outputPath.getFileSystem((Configuration)conf);
            Path tmpDir = new Path(outputPath, FileOutputCommitter.getJobAttemptBaseDirName(context) + "/" + TEMP_DIR_NAME);
            FileSystem fileSys = tmpDir.getFileSystem(context.getConfiguration());
            if (fileSys.exists(tmpDir)) {
                fileSys.delete(tmpDir, true);
            } else {
                LOG.warn((Object)("Task temp dir could not be deleted " + tmpDir));
            }
            Path jobOutputPath = new Path(outputPath, FileOutputCommitter.getJobAttemptBaseDirName(context));
            this.moveJobOutputs(outputFileSystem, jobOutputPath, outputPath, jobOutputPath);
            this.cleanupJob(context);
            if (this.shouldMarkOutputDir(context.getJobConf())) {
                this.markOutputDirSuccessful(context);
            }
        }
    }

    private void markOutputDirSuccessful(JobContext context) throws IOException {
        JobConf conf = context.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null) {
            FileSystem fileSys = outputPath.getFileSystem((Configuration)conf);
            Path filePath = new Path(outputPath, SUCCEEDED_FILE_NAME);
            fileSys.create(filePath).close();
        }
    }

    private void moveJobOutputs(FileSystem fs, Path origJobOutputPath, Path finalOutputDir, Path jobOutput) throws IOException {
        LOG.debug((Object)("Told to move job output from " + jobOutput + " to " + finalOutputDir + " and orig job output path is " + origJobOutputPath));
        if (fs.isFile(jobOutput)) {
            Path finalOutputPath = this.getFinalPath(fs, finalOutputDir, jobOutput, origJobOutputPath);
            if (!fs.rename(jobOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of job");
                }
                if (!fs.rename(jobOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of job");
                }
            }
            LOG.debug((Object)("Moved job output file from " + jobOutput + " to " + finalOutputPath));
        } else if (fs.getFileStatus(jobOutput).isDirectory()) {
            LOG.debug((Object)("Job output file " + jobOutput + " is a dir"));
            FileStatus[] paths = fs.listStatus(jobOutput);
            Path finalOutputPath = this.getFinalPath(fs, finalOutputDir, jobOutput, origJobOutputPath);
            fs.mkdirs(finalOutputPath);
            LOG.debug((Object)("Creating dirs along job output path " + finalOutputPath));
            if (paths != null) {
                for (FileStatus path : paths) {
                    this.moveJobOutputs(fs, origJobOutputPath, finalOutputDir, path.getPath());
                }
            }
        }
    }

    @Override
    @Deprecated
    public void cleanupJob(JobContext context) throws IOException {
        JobConf conf = context.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null) {
            Path tmpDir = new Path(outputPath, TEMP_DIR_NAME);
            FileSystem fileSys = tmpDir.getFileSystem((Configuration)conf);
            context.getProgressible().progress();
            if (fileSys.exists(tmpDir)) {
                fileSys.delete(tmpDir, true);
            } else {
                LOG.warn((Object)"Output Path is Null in cleanup");
            }
        }
    }

    @Override
    public void abortJob(JobContext context, int runState) throws IOException {
        this.cleanupJob(context);
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        Path taskOutputPath = this.getTempTaskOutputPath(context);
        TaskAttemptID attemptId = context.getTaskAttemptID();
        JobConf job = context.getJobConf();
        if (taskOutputPath != null) {
            FileSystem fs = taskOutputPath.getFileSystem((Configuration)job);
            context.getProgressible().progress();
            if (fs.exists(taskOutputPath)) {
                JobConf conf = context.getJobConf();
                Path outputPath = FileOutputFormat.getOutputPath(conf);
                FileSystem outputFileSystem = outputPath.getFileSystem((Configuration)conf);
                Path jobOutputPath = new Path(outputPath, FileOutputCommitter.getJobTempDirName(context));
                this.moveTaskOutputs(context, outputFileSystem, jobOutputPath, taskOutputPath);
                if (!fs.delete(taskOutputPath, true)) {
                    LOG.info((Object)("Failed to delete the temporary output directory of task: " + attemptId + " - " + taskOutputPath));
                }
                LOG.info((Object)("Saved output of task '" + attemptId + "' to " + jobOutputPath));
            }
        }
    }

    private void moveTaskOutputs(TaskAttemptContext context, FileSystem fs, Path jobOutputDir, Path taskOutput) throws IOException {
        TaskAttemptID attemptId = context.getTaskAttemptID();
        context.getProgressible().progress();
        LOG.debug((Object)("Told to move taskoutput from " + taskOutput + " to " + jobOutputDir));
        if (fs.isFile(taskOutput)) {
            Path finalOutputPath = this.getFinalPath(fs, jobOutputDir, taskOutput, this.getTempTaskOutputPath(context));
            if (!fs.rename(taskOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of task: " + attemptId);
                }
                if (!fs.rename(taskOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of task: " + attemptId);
                }
            }
            LOG.debug((Object)("Moved " + taskOutput + " to " + finalOutputPath));
        } else if (fs.getFileStatus(taskOutput).isDirectory()) {
            LOG.debug((Object)("Taskoutput " + taskOutput + " is a dir"));
            FileStatus[] paths = fs.listStatus(taskOutput);
            Path finalOutputPath = this.getFinalPath(fs, jobOutputDir, taskOutput, this.getTempTaskOutputPath(context));
            fs.mkdirs(finalOutputPath);
            LOG.debug((Object)("Creating dirs along path " + finalOutputPath));
            if (paths != null) {
                for (FileStatus path : paths) {
                    this.moveTaskOutputs(context, fs, jobOutputDir, path.getPath());
                }
            }
        }
    }

    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
        Path taskOutputPath = this.getTempTaskOutputPath(context);
        if (taskOutputPath != null) {
            FileSystem fs = taskOutputPath.getFileSystem((Configuration)context.getJobConf());
            context.getProgressible().progress();
            fs.delete(taskOutputPath, true);
        }
    }

    private Path getFinalPath(FileSystem fs, Path jobOutputDir, Path taskOutput, Path taskOutputPath) throws IOException {
        URI taskOutputPathUri;
        URI relativePath;
        URI taskOutputUri = taskOutput.makeQualified(fs).toUri();
        if (taskOutputUri == (relativePath = (taskOutputPathUri = taskOutputPath.makeQualified(fs).toUri()).relativize(taskOutputUri))) {
            throw new IOException("Can not get the relative path: base = " + taskOutputPathUri + " child = " + taskOutputUri);
        }
        if (relativePath.getPath().length() > 0) {
            return new Path(jobOutputDir, relativePath.getPath());
        }
        return jobOutputDir;
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        Path taskOutputPath = this.getTempTaskOutputPath(context);
        if (taskOutputPath != null) {
            context.getProgressible().progress();
            FileSystem fs = taskOutputPath.getFileSystem((Configuration)context.getJobConf());
            if (fs.exists(taskOutputPath)) {
                return true;
            }
        }
        return false;
    }

    Path getTempTaskOutputPath(TaskAttemptContext taskContext) throws IOException {
        JobConf conf = taskContext.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null) {
            Path p = new Path(outputPath, "_temporary/_" + taskContext.getTaskAttemptID().toString());
            FileSystem fs = p.getFileSystem((Configuration)conf);
            return p.makeQualified(fs);
        }
        return null;
    }

    Path getWorkPath(TaskAttemptContext taskContext, Path basePath) throws IOException {
        Path jobTmpDir = new Path(basePath, TEMP_DIR_NAME);
        FileSystem fs = jobTmpDir.getFileSystem((Configuration)taskContext.getJobConf());
        if (!fs.exists(jobTmpDir)) {
            throw new IOException("The temporary job-output directory " + jobTmpDir.toString() + " doesn't exist!");
        }
        String taskid = taskContext.getTaskAttemptID().toString();
        Path taskTmpDir = new Path(jobTmpDir, "_" + taskid);
        if (!fs.mkdirs(taskTmpDir)) {
            throw new IOException("Mkdirs failed to create " + taskTmpDir.toString());
        }
        return taskTmpDir;
    }

    @Override
    public boolean isRecoverySupported() {
        return true;
    }

    @Override
    public void recoverTask(TaskAttemptContext context) throws IOException {
        Path pathToRecover;
        Path outputPath = FileOutputFormat.getOutputPath(context.getJobConf());
        context.progress();
        Path jobOutputPath = new Path(outputPath, FileOutputCommitter.getJobTempDirName(context));
        int previousAttempt = context.getConfiguration().getInt("mapreduce.job.application.attempt.id", 0) - 1;
        if (previousAttempt < 0) {
            LOG.warn((Object)"Cannot recover task output for first attempt...");
            return;
        }
        FileSystem outputFileSystem = outputPath.getFileSystem((Configuration)context.getJobConf());
        if (outputFileSystem.exists(pathToRecover = new Path(outputPath, FileOutputCommitter.getJobAttemptBaseDirName(previousAttempt)))) {
            LOG.debug((Object)("Trying to recover task from " + pathToRecover + " into " + jobOutputPath));
            this.moveJobOutputs(outputFileSystem, pathToRecover, jobOutputPath, pathToRecover);
            LOG.info((Object)("Saved output of job to " + jobOutputPath));
        }
    }

    protected static String getJobAttemptBaseDirName(JobContext context) {
        int appAttemptId = context.getJobConf().getInt("mapreduce.job.application.attempt.id", 0);
        return FileOutputCommitter.getJobAttemptBaseDirName(appAttemptId);
    }

    protected static String getJobTempDirName(TaskAttemptContext context) {
        int appAttemptId = context.getJobConf().getInt("mapreduce.job.application.attempt.id", 0);
        return FileOutputCommitter.getJobAttemptBaseDirName(appAttemptId);
    }

    protected static String getJobAttemptBaseDirName(int appAttemptId) {
        return "_temporary/" + appAttemptId;
    }

    protected static String getTaskAttemptBaseDirName(TaskAttemptContext context) {
        return FileOutputCommitter.getJobTempDirName(context) + "/" + TEMP_DIR_NAME + "/" + "_" + context.getTaskAttemptID().toString();
    }
}

