/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

@InterfaceAudience.Private
public class JobACLsManager {
    Configuration conf;

    public JobACLsManager(Configuration conf) {
        this.conf = conf;
    }

    public boolean areACLsEnabled() {
        return this.conf.getBoolean("mapreduce.cluster.acls.enabled", false);
    }

    public Map<JobACL, AccessControlList> constructJobACLs(Configuration conf) {
        HashMap<JobACL, AccessControlList> acls = new HashMap<JobACL, AccessControlList>();
        if (!this.areACLsEnabled()) {
            return acls;
        }
        for (JobACL aclName : JobACL.values()) {
            String aclConfigName = aclName.getAclName();
            String aclConfigured = conf.get(aclConfigName);
            if (aclConfigured == null) {
                aclConfigured = " ";
            }
            acls.put(aclName, new AccessControlList(aclConfigured));
        }
        return acls;
    }

    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation, String jobOwner, AccessControlList jobACL) {
        String user = callerUGI.getShortUserName();
        if (!this.areACLsEnabled()) {
            return true;
        }
        return user.equals(jobOwner) || jobACL.isUserAllowed(callerUGI);
    }
}

