/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;

public class Master {
    public static String getMasterUserName(Configuration conf) {
        String framework = conf.get("mapreduce.framework.name", "yarn");
        if (framework.equals("classic")) {
            return conf.get("mapreduce.jobtracker.kerberos.principal");
        }
        return conf.get("yarn.resourcemanager.principal");
    }

    public static InetSocketAddress getMasterAddress(Configuration conf) {
        String framework = conf.get("mapreduce.framework.name", "yarn");
        if (framework.equals("classic")) {
            String masterAddress = conf.get("mapreduce.jobtracker.address", "localhost:8012");
            return NetUtils.createSocketAddr((String)masterAddress, (int)8012, (String)"mapreduce.jobtracker.address");
        }
        String masterAddress = conf.get("yarn.resourcemanager.address", "0.0.0.0:8040");
        return NetUtils.createSocketAddr((String)masterAddress, (int)8040, (String)"yarn.resourcemanager.address");
    }

    public static String getMasterPrincipal(Configuration conf) throws IOException {
        String masterHostname = Master.getMasterAddress(conf).getHostName();
        return SecurityUtil.getServerPrincipal((String)Master.getMasterUserName(conf), (String)masterHostname);
    }

    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

