/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

public abstract class PeriodicStatsAccumulator {
    protected final int count;
    protected final int[] values;
    StatsetState state = new StatsetState();

    PeriodicStatsAccumulator(int count) {
        this.count = count;
        this.values = new int[count];
        for (int i = 0; i < count; ++i) {
            this.values[i] = -1;
        }
    }

    protected int[] getValues() {
        return this.values;
    }

    protected abstract void extendInternal(double var1, int var3);

    protected void initializeInterval() {
        this.state.currentAccumulation = 0.0;
    }

    protected void extend(double newProgress, int newValue) {
        if (this.state == null || newProgress < this.state.oldProgress) {
            return;
        }
        int oldIndex = (int)(this.state.oldProgress * (double)this.count);
        int newIndex = (int)(newProgress * (double)this.count);
        int originalOldValue = this.state.oldValue;
        double fullValueDistance = (double)newValue - (double)this.state.oldValue;
        double fullProgressDistance = newProgress - this.state.oldProgress;
        double originalOldProgress = this.state.oldProgress;
        for (int closee = oldIndex; closee < newIndex; ++closee) {
            double interpolationProgress = (double)(closee + 1) / (double)this.count;
            interpolationProgress = Math.min(interpolationProgress, newProgress);
            double progressLength = interpolationProgress - originalOldProgress;
            double interpolationProportion = progressLength / fullProgressDistance;
            double interpolationValueDistance = fullValueDistance * interpolationProportion;
            int interpolationValue = (int)interpolationValueDistance + originalOldValue;
            this.extendInternal(interpolationProgress, interpolationValue);
            this.advanceState(interpolationProgress, interpolationValue);
            this.values[closee] = (int)this.state.currentAccumulation;
            this.initializeInterval();
        }
        this.extendInternal(newProgress, newValue);
        this.advanceState(newProgress, newValue);
        if (newIndex == this.count) {
            this.state = null;
        }
    }

    protected void advanceState(double newProgress, int newValue) {
        this.state.oldValue = newValue;
        this.state.oldProgress = newProgress;
    }

    int getCount() {
        return this.count;
    }

    int get(int index) {
        return this.values[index];
    }

    static class StatsetState {
        int oldValue = 0;
        double oldProgress = 0.0;
        double currentAccumulation = 0.0;

        StatsetState() {
        }
    }
}

