/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.counters;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.counters.LimitExceededException;
import org.apache.hadoop.mapreduce.counters.Limits;
import org.apache.hadoop.mapreduce.util.ResourceBundles;

@InterfaceAudience.Private
public abstract class AbstractCounterGroup<T extends Counter>
implements CounterGroupBase<T> {
    private final String name;
    private String displayName;
    private final Map<String, T> counters = Maps.newTreeMap();
    private final Limits limits;

    public AbstractCounterGroup(String name, String displayName, Limits limits) {
        this.name = name;
        this.displayName = displayName;
        this.limits = limits;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    @Override
    public synchronized String getDisplayName() {
        return this.displayName;
    }

    @Override
    public synchronized void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public synchronized void addCounter(T counter) {
        this.counters.put(counter.getName(), counter);
        this.limits.incrCounters();
    }

    @Override
    public synchronized T addCounter(String counterName, String displayName, long value) {
        String saveName = this.limits.filterCounterName(counterName);
        T counter = this.findCounterImpl(saveName, false);
        if (counter == null) {
            return this.addCounterImpl(saveName, displayName, value);
        }
        counter.setValue(value);
        return counter;
    }

    private T addCounterImpl(String name, String displayName, long value) {
        T counter = this.newCounter(name, displayName, value);
        this.addCounter(counter);
        return counter;
    }

    @Override
    public T findCounter(String counterName, String displayName) {
        String saveName = this.limits.filterCounterName(counterName);
        T counter = this.findCounterImpl(saveName, false);
        if (counter == null) {
            return this.addCounterImpl(saveName, displayName, 0L);
        }
        return counter;
    }

    @Override
    public synchronized T findCounter(String counterName, boolean create) {
        return this.findCounterImpl(this.limits.filterCounterName(counterName), create);
    }

    private T findCounterImpl(String counterName, boolean create) {
        Counter counter = (Counter)this.counters.get(counterName);
        if (counter == null && create) {
            String localized = ResourceBundles.getCounterName(this.getName(), counterName, counterName);
            return this.addCounterImpl(counterName, localized, 0L);
        }
        return (T)counter;
    }

    @Override
    public T findCounter(String counterName) {
        return this.findCounter(counterName, true);
    }

    protected abstract T newCounter(String var1, String var2, long var3);

    protected abstract T newCounter();

    @Override
    public synchronized Iterator<T> iterator() {
        return this.counters.values().iterator();
    }

    public synchronized void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.displayName);
        WritableUtils.writeVInt((DataOutput)out, (int)this.counters.size());
        for (Counter counter : this.counters.values()) {
            counter.write(out);
        }
    }

    public synchronized void readFields(DataInput in) throws IOException {
        this.displayName = Text.readString((DataInput)in);
        this.counters.clear();
        int size = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < size; ++i) {
            T counter = this.newCounter();
            counter.readFields(in);
            this.counters.put(counter.getName(), counter);
            this.limits.incrCounters();
        }
    }

    @Override
    public synchronized int size() {
        return this.counters.size();
    }

    public synchronized boolean equals(Object genericRight) {
        if (genericRight instanceof CounterGroupBase) {
            CounterGroupBase right = (CounterGroupBase)genericRight;
            return Iterators.elementsEqual(this.iterator(), (Iterator)right.iterator());
        }
        return false;
    }

    public synchronized int hashCode() {
        return ((Object)this.counters).hashCode();
    }

    @Override
    public void incrAllCounters(CounterGroupBase<T> rightGroup) {
        try {
            for (Counter right : rightGroup) {
                T left = this.findCounter(right.getName(), right.getDisplayName());
                left.increment(right.getValue());
            }
        }
        catch (LimitExceededException e) {
            this.counters.clear();
            throw e;
        }
    }
}

