/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.counters;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.counters.LimitExceededException;

@InterfaceAudience.Private
public class Limits {
    static final Configuration conf = new Configuration();
    public static final int GROUP_NAME_MAX = conf.getInt("mapreduce.job.counters.group.name.max", 128);
    public static final int COUNTER_NAME_MAX = conf.getInt("mapreduce.job.counters.counter.name.max", 64);
    public static final int GROUPS_MAX = conf.getInt("mapreduce.job.counters.groups.max", 50);
    public static final int COUNTERS_MAX = conf.getInt("mapreduce.job.counters.max", 120);
    private int totalCounters;
    private LimitExceededException firstViolation;

    public static String filterName(String name, int maxLen) {
        return name.length() > maxLen ? name.substring(0, maxLen - 1) : name;
    }

    public String filterCounterName(String name) {
        return Limits.filterName(name, COUNTER_NAME_MAX);
    }

    public String filterGroupName(String name) {
        return Limits.filterName(name, GROUP_NAME_MAX);
    }

    public synchronized void checkCounters(int size) {
        if (this.firstViolation != null) {
            throw new LimitExceededException(this.firstViolation);
        }
        if (size > COUNTERS_MAX) {
            this.firstViolation = new LimitExceededException("Too many counters: " + size + " max=" + COUNTERS_MAX);
            throw this.firstViolation;
        }
    }

    public synchronized void incrCounters() {
        this.checkCounters(this.totalCounters + 1);
        ++this.totalCounters;
    }

    public synchronized void checkGroups(int size) {
        if (this.firstViolation != null) {
            throw new LimitExceededException(this.firstViolation);
        }
        if (size > GROUPS_MAX) {
            this.firstViolation = new LimitExceededException("Too many counter groups: " + size + " max=" + GROUPS_MAX);
        }
    }

    public synchronized LimitExceededException violation() {
        return this.firstViolation;
    }
}

