/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FileOutputCommitter
extends OutputCommitter {
    private static final Log LOG = LogFactory.getLog(FileOutputCommitter.class);
    protected static final String TEMP_DIR_NAME = "_temporary";
    public static final String SUCCEEDED_FILE_NAME = "_SUCCESS";
    static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";
    private FileSystem outputFileSystem = null;
    private Path outputPath = null;
    private Path workPath = null;

    public FileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        if (outputPath != null) {
            this.outputPath = outputPath;
            this.outputFileSystem = outputPath.getFileSystem(context.getConfiguration());
            this.workPath = new Path(outputPath, FileOutputCommitter.getTaskAttemptBaseDirName(context)).makeQualified(this.outputFileSystem);
        }
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        Path tmpDir;
        FileSystem fileSys;
        if (this.outputPath != null && !(fileSys = (tmpDir = new Path(this.outputPath, FileOutputCommitter.getJobAttemptBaseDirName(context) + "/" + TEMP_DIR_NAME)).getFileSystem(context.getConfiguration())).mkdirs(tmpDir)) {
            LOG.error((Object)("Mkdirs failed to create " + tmpDir.toString()));
        }
    }

    private boolean shouldMarkOutputDir(Configuration conf) {
        return conf.getBoolean(SUCCESSFUL_JOB_OUTPUT_DIR_MARKER, true);
    }

    private void markOutputDirSuccessful(MRJobConfig context) throws IOException {
        if (this.outputPath != null) {
            Path filePath = new Path(this.outputPath, SUCCEEDED_FILE_NAME);
            this.outputFileSystem.create(filePath).close();
        }
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        if (this.outputPath != null) {
            Path tmpDir = new Path(this.outputPath, FileOutputCommitter.getJobAttemptBaseDirName(context) + "/" + TEMP_DIR_NAME);
            FileSystem fileSys = tmpDir.getFileSystem(context.getConfiguration());
            if (fileSys.exists(tmpDir)) {
                fileSys.delete(tmpDir, true);
            } else {
                LOG.warn((Object)("Task temp dir could not be deleted " + tmpDir));
            }
            Path jobOutputPath = new Path(this.outputPath, FileOutputCommitter.getJobAttemptBaseDirName(context));
            this.moveJobOutputs(this.outputFileSystem, jobOutputPath, this.outputPath, jobOutputPath);
            this.cleanupJob(context);
            if (this.shouldMarkOutputDir(context.getConfiguration())) {
                this.markOutputDirSuccessful(context);
            }
        }
    }

    private void moveJobOutputs(FileSystem fs, Path origJobOutputPath, Path finalOutputDir, Path jobOutput) throws IOException {
        LOG.debug((Object)("Told to move job output from " + jobOutput + " to " + finalOutputDir + " and orig job output path is " + origJobOutputPath));
        if (fs.isFile(jobOutput)) {
            Path finalOutputPath = this.getFinalPath(finalOutputDir, jobOutput, origJobOutputPath);
            if (!fs.rename(jobOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of job");
                }
                if (!fs.rename(jobOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of job");
                }
            }
            LOG.debug((Object)("Moved job output file from " + jobOutput + " to " + finalOutputPath));
        } else if (fs.getFileStatus(jobOutput).isDirectory()) {
            LOG.debug((Object)("Job output file " + jobOutput + " is a dir"));
            FileStatus[] paths = fs.listStatus(jobOutput);
            Path finalOutputPath = this.getFinalPath(finalOutputDir, jobOutput, origJobOutputPath);
            fs.mkdirs(finalOutputPath);
            LOG.debug((Object)("Creating dirs along job output path " + finalOutputPath));
            if (paths != null) {
                for (FileStatus path : paths) {
                    this.moveJobOutputs(fs, origJobOutputPath, finalOutputDir, path.getPath());
                }
            }
        }
    }

    @Override
    @Deprecated
    public void cleanupJob(JobContext context) throws IOException {
        if (this.outputPath != null) {
            Path tmpDir = new Path(this.outputPath, TEMP_DIR_NAME);
            FileSystem fileSys = tmpDir.getFileSystem(context.getConfiguration());
            if (fileSys.exists(tmpDir)) {
                fileSys.delete(tmpDir, true);
            }
        } else {
            LOG.warn((Object)"Output Path is null in cleanup");
        }
    }

    @Override
    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        this.cleanupJob(context);
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        TaskAttemptID attemptId = context.getTaskAttemptID();
        if (this.workPath != null) {
            context.progress();
            if (this.outputFileSystem.exists(this.workPath)) {
                Path jobOutputPath = new Path(this.outputPath, FileOutputCommitter.getJobAttemptBaseDirName(context));
                this.moveTaskOutputs(context, this.outputFileSystem, jobOutputPath, this.workPath);
                if (!this.outputFileSystem.delete(this.workPath, true)) {
                    LOG.warn((Object)("Failed to delete the temporary output directory of task: " + attemptId + " - " + this.workPath));
                }
                LOG.info((Object)("Saved output of task '" + attemptId + "' to " + this.outputPath));
            }
        }
    }

    private void moveTaskOutputs(TaskAttemptContext context, FileSystem fs, Path jobOutputDir, Path taskOutput) throws IOException {
        TaskAttemptID attemptId = context.getTaskAttemptID();
        context.progress();
        LOG.debug((Object)("Told to move taskoutput from " + taskOutput + " to " + jobOutputDir));
        if (fs.isFile(taskOutput)) {
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput, this.workPath);
            if (!fs.rename(taskOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of task: " + attemptId);
                }
                if (!fs.rename(taskOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of task: " + attemptId);
                }
            }
            LOG.debug((Object)("Moved " + taskOutput + " to " + finalOutputPath));
        } else if (fs.getFileStatus(taskOutput).isDirectory()) {
            LOG.debug((Object)("Taskoutput " + taskOutput + " is a dir"));
            FileStatus[] paths = fs.listStatus(taskOutput);
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput, this.workPath);
            fs.mkdirs(finalOutputPath);
            LOG.debug((Object)("Creating dirs along path " + finalOutputPath));
            if (paths != null) {
                for (FileStatus path : paths) {
                    this.moveTaskOutputs(context, fs, jobOutputDir, path.getPath());
                }
            }
        }
    }

    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
        if (this.workPath != null) {
            context.progress();
            this.outputFileSystem.delete(this.workPath, true);
        }
    }

    private Path getFinalPath(Path jobOutputDir, Path taskOutput, Path taskOutputPath) throws IOException {
        URI taskOutputPathUri;
        URI relativePath;
        URI taskOutputUri = taskOutput.makeQualified(this.outputFileSystem.getUri(), this.outputFileSystem.getWorkingDirectory()).toUri();
        if (taskOutputUri == (relativePath = (taskOutputPathUri = taskOutputPath.makeQualified(this.outputFileSystem.getUri(), this.outputFileSystem.getWorkingDirectory()).toUri()).relativize(taskOutputUri))) {
            throw new IOException("Can not get the relative path: base = " + taskOutputPathUri + " child = " + taskOutputUri);
        }
        if (relativePath.getPath().length() > 0) {
            return new Path(jobOutputDir, relativePath.getPath());
        }
        return jobOutputDir;
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return this.workPath != null && this.outputFileSystem.exists(this.workPath);
    }

    public Path getWorkPath() throws IOException {
        return this.workPath;
    }

    @Override
    public boolean isRecoverySupported() {
        return true;
    }

    @Override
    public void recoverTask(TaskAttemptContext context) throws IOException {
        context.progress();
        Path jobOutputPath = new Path(this.outputPath, FileOutputCommitter.getJobAttemptBaseDirName(context));
        int previousAttempt = context.getConfiguration().getInt("mapreduce.job.application.attempt.id", 0) - 1;
        if (previousAttempt < 0) {
            throw new IOException("Cannot recover task output for first attempt...");
        }
        Path pathToRecover = new Path(this.outputPath, FileOutputCommitter.getJobAttemptBaseDirName(previousAttempt));
        LOG.debug((Object)("Trying to recover task from " + pathToRecover + " into " + jobOutputPath));
        if (this.outputFileSystem.exists(pathToRecover)) {
            this.moveJobOutputs(this.outputFileSystem, pathToRecover, jobOutputPath, pathToRecover);
            LOG.info((Object)("Saved output of job to " + jobOutputPath));
        }
    }

    protected static String getJobAttemptBaseDirName(JobContext context) {
        int appAttemptId = context.getConfiguration().getInt("mapreduce.job.application.attempt.id", 0);
        return FileOutputCommitter.getJobAttemptBaseDirName(appAttemptId);
    }

    protected static String getJobAttemptBaseDirName(int appAttemptId) {
        return "_temporary/" + appAttemptId;
    }

    protected static String getTaskAttemptBaseDirName(TaskAttemptContext context) {
        return FileOutputCommitter.getJobAttemptBaseDirName(context) + "/" + TEMP_DIR_NAME + "/" + "_" + context.getTaskAttemptID().toString();
    }
}

