/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskType;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TaskID
extends org.apache.hadoop.mapred.ID {
    protected static final String TASK = "task";
    protected static final NumberFormat idFormat = NumberFormat.getInstance();
    private JobID jobId;
    private TaskType type;

    public TaskID(JobID jobId, TaskType type, int id) {
        super(id);
        if (jobId == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        this.jobId = jobId;
        this.type = type;
    }

    public TaskID(String jtIdentifier, int jobId, TaskType type, int id) {
        this(new JobID(jtIdentifier, jobId), type, id);
    }

    public TaskID() {
        this.jobId = new JobID();
    }

    public JobID getJobID() {
        return this.jobId;
    }

    @Deprecated
    public boolean isMap() {
        return this.type == TaskType.MAP;
    }

    public TaskType getTaskType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TaskID that = (TaskID)o;
        return this.type == that.type && this.jobId.equals(that.jobId);
    }

    @Override
    public int compareTo(ID o) {
        TaskID that = (TaskID)o;
        int jobComp = this.jobId.compareTo(that.jobId);
        if (jobComp == 0) {
            if (this.type == that.type) {
                return this.id - that.id;
            }
            return this.type.compareTo(that.type);
        }
        return jobComp;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(TASK)).toString();
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.jobId.appendTo(builder).append('_').append(CharTaskTypeMaps.getRepresentingCharacter(this.type)).append('_').append(idFormat.format(this.id));
    }

    @Override
    public int hashCode() {
        return this.jobId.hashCode() * 524287 + this.id;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.jobId.readFields(in);
        this.type = (TaskType)WritableUtils.readEnum((DataInput)in, TaskType.class);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.jobId.write(out);
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.type);
    }

    public static TaskID forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            String[] parts = str.split("_");
            if (parts.length == 5 && parts[0].equals(TASK)) {
                String type = parts[3];
                TaskType t = CharTaskTypeMaps.getTaskType(type.charAt(0));
                if (t != null) {
                    return new org.apache.hadoop.mapred.TaskID(parts[1], Integer.parseInt(parts[2]), t, Integer.parseInt(parts[4]));
                }
                throw new Exception();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("TaskId string : " + str + " is not properly formed");
    }

    public static char getRepresentingCharacter(TaskType type) {
        return CharTaskTypeMaps.getRepresentingCharacter(type);
    }

    public static TaskType getTaskType(char c) {
        return CharTaskTypeMaps.getTaskType(c);
    }

    public static String getAllTaskTypes() {
        return CharTaskTypeMaps.allTaskTypes;
    }

    static {
        idFormat.setGroupingUsed(false);
        idFormat.setMinimumIntegerDigits(6);
    }

    static class CharTaskTypeMaps {
        private static EnumMap<TaskType, Character> typeToCharMap = new EnumMap(TaskType.class);
        private static Map<Character, TaskType> charToTypeMap = new HashMap<Character, TaskType>();
        static String allTaskTypes = "(m|r|s|c|t)";

        CharTaskTypeMaps() {
        }

        private static void setupTaskTypeToCharMapping() {
            typeToCharMap.put(TaskType.MAP, Character.valueOf('m'));
            typeToCharMap.put(TaskType.REDUCE, Character.valueOf('r'));
            typeToCharMap.put(TaskType.JOB_SETUP, Character.valueOf('s'));
            typeToCharMap.put(TaskType.JOB_CLEANUP, Character.valueOf('c'));
            typeToCharMap.put(TaskType.TASK_CLEANUP, Character.valueOf('t'));
        }

        private static void setupCharToTaskTypeMapping() {
            charToTypeMap.put(Character.valueOf('m'), TaskType.MAP);
            charToTypeMap.put(Character.valueOf('r'), TaskType.REDUCE);
            charToTypeMap.put(Character.valueOf('s'), TaskType.JOB_SETUP);
            charToTypeMap.put(Character.valueOf('c'), TaskType.JOB_CLEANUP);
            charToTypeMap.put(Character.valueOf('t'), TaskType.TASK_CLEANUP);
        }

        static char getRepresentingCharacter(TaskType type) {
            return typeToCharMap.get((Object)type).charValue();
        }

        static TaskType getTaskType(char c) {
            return charToTypeMap.get(Character.valueOf(c));
        }

        static {
            CharTaskTypeMaps.setupTaskTypeToCharMapping();
            CharTaskTypeMaps.setupCharToTaskTypeMapping();
        }
    }
}

