/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class FileOutputFormat<K, V>
implements OutputFormat<K, V> {
    public static void setCompressOutput(JobConf conf, boolean compress) {
        conf.setBoolean("mapreduce.output.fileoutputformat.compress", compress);
    }

    public static boolean getCompressOutput(JobConf conf) {
        return conf.getBoolean("mapreduce.output.fileoutputformat.compress", false);
    }

    public static void setOutputCompressorClass(JobConf conf, Class<? extends CompressionCodec> codecClass) {
        FileOutputFormat.setCompressOutput(conf, true);
        conf.setClass("mapreduce.output.fileoutputformat.compress.codec", codecClass, CompressionCodec.class);
    }

    public static Class<? extends CompressionCodec> getOutputCompressorClass(JobConf conf, Class<? extends CompressionCodec> defaultValue) {
        Class<? extends CompressionCodec> codecClass = defaultValue;
        String name = conf.get("mapreduce.output.fileoutputformat.compress.codec");
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    @Override
    public abstract RecordWriter<K, V> getRecordWriter(FileSystem var1, JobConf var2, String var3, Progressable var4) throws IOException;

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws FileAlreadyExistsException, InvalidJobConfException, IOException {
        Path outDir = FileOutputFormat.getOutputPath(job);
        if (outDir == null && job.getNumReduceTasks() != 0) {
            throw new InvalidJobConfException("Output directory not set in JobConf.");
        }
        if (outDir != null) {
            FileSystem fs = outDir.getFileSystem((Configuration)job);
            outDir = fs.makeQualified(outDir);
            FileOutputFormat.setOutputPath(job, outDir);
            TokenCache.obtainTokensForNamenodes(job.getCredentials(), new Path[]{outDir}, job);
            if (fs.exists(outDir)) {
                throw new FileAlreadyExistsException("Output directory " + outDir + " already exists");
            }
        }
    }

    public static void setOutputPath(JobConf conf, Path outputDir) {
        outputDir = new Path(conf.getWorkingDirectory(), outputDir);
        conf.set("mapreduce.output.fileoutputformat.outputdir", outputDir.toString());
    }

    @InterfaceAudience.Private
    public static void setWorkOutputPath(JobConf conf, Path outputDir) {
        outputDir = new Path(conf.getWorkingDirectory(), outputDir);
        conf.set("mapreduce.task.output.dir", outputDir.toString());
    }

    public static Path getOutputPath(JobConf conf) {
        String name = conf.get("mapreduce.output.fileoutputformat.outputdir");
        return name == null ? null : new Path(name);
    }

    public static Path getWorkOutputPath(JobConf conf) {
        String name = conf.get("mapreduce.task.output.dir");
        return name == null ? null : new Path(name);
    }

    public static Path getTaskOutputPath(JobConf conf, String name) throws IOException {
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath == null) {
            throw new IOException("Undefined job output-path");
        }
        OutputCommitter committer = conf.getOutputCommitter();
        Path workPath = outputPath;
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, TaskAttemptID.forName(conf.get("mapreduce.task.attempt.id")));
        if (committer instanceof FileOutputCommitter) {
            workPath = ((FileOutputCommitter)committer).getWorkPath(context, outputPath);
        }
        return new Path(workPath, name);
    }

    public static String getUniqueName(JobConf conf, String name) {
        int partition = conf.getInt("mapreduce.task.partition", -1);
        if (partition == -1) {
            throw new IllegalArgumentException("This method can only be called from within a Job");
        }
        String taskType = conf.getBoolean("mapreduce.task.ismap", true) ? "m" : "r";
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(5);
        numberFormat.setGroupingUsed(false);
        return name + "-" + taskType + "-" + numberFormat.format(partition);
    }

    public static Path getPathForCustomFile(JobConf conf, String name) {
        return new Path(FileOutputFormat.getWorkOutputPath(conf), FileOutputFormat.getUniqueName(conf, name));
    }
}

