/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.CompletedTask;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class CompletedJob
implements Job {
    static final Log LOG = LogFactory.getLog(CompletedJob.class);
    private final org.apache.hadoop.mapreduce.v2.api.records.Counters counters;
    private final Configuration conf;
    private final JobId jobId;
    private final List<String> diagnostics = new ArrayList<String>();
    private final JobReport report;
    private final Map<TaskId, Task> tasks = new HashMap<TaskId, Task>();
    private final Map<TaskId, Task> mapTasks = new HashMap<TaskId, Task>();
    private final Map<TaskId, Task> reduceTasks = new HashMap<TaskId, Task>();
    private final String user;
    private final Path confFile;
    private JobACLsManager aclsMgr;
    private List<TaskAttemptCompletionEvent> completionEvents = null;
    private JobHistoryParser.JobInfo jobInfo;

    public CompletedJob(Configuration conf, JobId jobId, Path historyFile, boolean loadTasks, String userName, Path confFile, JobACLsManager aclsMgr) throws IOException {
        LOG.info((Object)("Loading job: " + jobId + " from file: " + historyFile));
        this.conf = conf;
        this.jobId = jobId;
        this.confFile = confFile;
        this.aclsMgr = aclsMgr;
        this.loadFullHistoryData(loadTasks, historyFile);
        this.user = userName;
        this.counters = TypeConverter.toYarn((Counters)this.jobInfo.getTotalCounters());
        this.diagnostics.add(this.jobInfo.getErrorInfo());
        this.report = (JobReport)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(JobReport.class);
        this.report.setJobId(jobId);
        this.report.setJobState(JobState.valueOf((String)this.jobInfo.getJobStatus()));
        this.report.setSubmitTime(this.jobInfo.getSubmitTime());
        this.report.setStartTime(this.jobInfo.getLaunchTime());
        this.report.setFinishTime(this.jobInfo.getFinishTime());
        this.report.setJobName(this.jobInfo.getJobname());
        this.report.setUser(this.jobInfo.getUsername());
        this.report.setMapProgress((float)this.getCompletedMaps() / (float)this.getTotalMaps());
        this.report.setReduceProgress((float)this.getCompletedReduces() / (float)this.getTotalReduces());
        this.report.setJobFile(confFile.toString());
        this.report.setTrackingUrl(JobHistoryUtils.getHistoryUrl((Configuration)conf, (ApplicationId)TypeConverter.toYarn((JobID)TypeConverter.fromYarn((JobId)jobId)).getAppId()));
        this.report.setAMInfos(this.getAMInfos());
    }

    public int getCompletedMaps() {
        return (int)this.jobInfo.getFinishedMaps();
    }

    public int getCompletedReduces() {
        return (int)this.jobInfo.getFinishedReduces();
    }

    public org.apache.hadoop.mapreduce.v2.api.records.Counters getCounters() {
        return this.counters;
    }

    public JobId getID() {
        return this.jobId;
    }

    public JobReport getReport() {
        return this.report;
    }

    public JobState getState() {
        return this.report.getJobState();
    }

    public Task getTask(TaskId taskId) {
        return this.tasks.get(taskId);
    }

    public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
        if (this.completionEvents == null) {
            this.constructTaskAttemptCompletionEvents();
        }
        TaskAttemptCompletionEvent[] events = new TaskAttemptCompletionEvent[]{};
        if (this.completionEvents.size() > fromEventId) {
            int actualMax = Math.min(maxEvents, this.completionEvents.size() - fromEventId);
            events = this.completionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
        }
        return events;
    }

    private void constructTaskAttemptCompletionEvents() {
        this.completionEvents = new LinkedList<TaskAttemptCompletionEvent>();
        LinkedList<TaskAttempt> allTaskAttempts = new LinkedList<TaskAttempt>();
        for (TaskId taskId : this.tasks.keySet()) {
            Task task = this.tasks.get(taskId);
            for (TaskAttemptId taskAttemptId : task.getAttempts().keySet()) {
                TaskAttempt taskAttempt = (TaskAttempt)task.getAttempts().get(taskAttemptId);
                allTaskAttempts.add(taskAttempt);
            }
        }
        Collections.sort(allTaskAttempts, new Comparator<TaskAttempt>(){

            @Override
            public int compare(TaskAttempt o1, TaskAttempt o2) {
                if (o1.getFinishTime() == 0L || o2.getFinishTime() == 0L) {
                    if (o1.getFinishTime() == 0L && o2.getFinishTime() == 0L) {
                        if (o1.getLaunchTime() == 0L || o2.getLaunchTime() == 0L) {
                            if (o1.getLaunchTime() == 0L && o2.getLaunchTime() == 0L) {
                                return 0;
                            }
                            long res = o1.getLaunchTime() - o2.getLaunchTime();
                            return res > 0L ? -1 : 1;
                        }
                        return (int)(o1.getLaunchTime() - o2.getLaunchTime());
                    }
                    long res = o1.getFinishTime() - o2.getFinishTime();
                    return res > 0L ? -1 : 1;
                }
                return (int)(o1.getFinishTime() - o2.getFinishTime());
            }
        });
        int eventId = 0;
        for (TaskAttempt taskAttempt : allTaskAttempts) {
            TaskAttemptCompletionEvent tace = (TaskAttemptCompletionEvent)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(TaskAttemptCompletionEvent.class);
            int attemptRunTime = -1;
            if (taskAttempt.getLaunchTime() != 0L && taskAttempt.getFinishTime() != 0L) {
                attemptRunTime = (int)(taskAttempt.getFinishTime() - taskAttempt.getLaunchTime());
            }
            TaskAttemptCompletionEventStatus taceStatus = TaskAttemptCompletionEventStatus.KILLED;
            String taStateString = taskAttempt.getState().toString();
            try {
                taceStatus = TaskAttemptCompletionEventStatus.valueOf((String)taStateString);
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot constuct TACEStatus from TaskAtemptState: [" + taStateString + "] for taskAttemptId: [" + taskAttempt.getID() + "]. Defaulting to KILLED"));
            }
            tace.setAttemptId(taskAttempt.getID());
            tace.setAttemptRunTime(attemptRunTime);
            tace.setEventId(eventId++);
            tace.setMapOutputServerAddress(taskAttempt.getAssignedContainerMgrAddress());
            tace.setStatus(taceStatus);
            this.completionEvents.add(tace);
        }
    }

    public Map<TaskId, Task> getTasks() {
        return this.tasks;
    }

    private synchronized void loadFullHistoryData(boolean loadTasks, Path historyFileAbsolute) throws IOException {
        LOG.info((Object)("Loading history file: [" + historyFileAbsolute + "]"));
        if (this.jobInfo != null) {
            return;
        }
        if (historyFileAbsolute != null) {
            try {
                JobHistoryParser parser = new JobHistoryParser(historyFileAbsolute.getFileSystem(this.conf), historyFileAbsolute);
                this.jobInfo = parser.parse();
            }
            catch (IOException e) {
                throw new YarnException("Could not load history file " + historyFileAbsolute, (Throwable)e);
            }
        } else {
            throw new IOException("History file not found");
        }
        if (loadTasks) {
            for (Map.Entry entry : this.jobInfo.getAllTasks().entrySet()) {
                TaskId yarnTaskID = TypeConverter.toYarn((TaskID)((TaskID)entry.getKey()));
                JobHistoryParser.TaskInfo taskInfo = (JobHistoryParser.TaskInfo)entry.getValue();
                CompletedTask task = new CompletedTask(yarnTaskID, taskInfo);
                this.tasks.put(yarnTaskID, task);
                if (task.getType() == TaskType.MAP) {
                    this.mapTasks.put(task.getID(), task);
                    continue;
                }
                if (task.getType() != TaskType.REDUCE) continue;
                this.reduceTasks.put(task.getID(), task);
            }
        }
        LOG.info((Object)"TaskInfo loaded");
    }

    public List<String> getDiagnostics() {
        return this.diagnostics;
    }

    public String getName() {
        return this.jobInfo.getJobname();
    }

    public String getQueueName() {
        return this.jobInfo.getJobQueueName();
    }

    public int getTotalMaps() {
        return (int)this.jobInfo.getTotalMaps();
    }

    public int getTotalReduces() {
        return (int)this.jobInfo.getTotalReduces();
    }

    public boolean isUber() {
        return this.jobInfo.getUberized();
    }

    public Map<TaskId, Task> getTasks(TaskType taskType) {
        if (TaskType.MAP.equals((Object)taskType)) {
            return this.mapTasks;
        }
        return this.reduceTasks;
    }

    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return true;
        }
        Map jobACLs = this.jobInfo.getJobACLs();
        AccessControlList jobACL = (AccessControlList)jobACLs.get(jobOperation);
        return this.aclsMgr.checkAccess(callerUGI, jobOperation, this.jobInfo.getUsername(), jobACL);
    }

    public Map<JobACL, AccessControlList> getJobACLs() {
        return this.jobInfo.getJobACLs();
    }

    public String getUserName() {
        return this.user;
    }

    public Path getConfFile() {
        return this.confFile;
    }

    public List<AMInfo> getAMInfos() {
        LinkedList<AMInfo> amInfos = new LinkedList<AMInfo>();
        for (JobHistoryParser.AMInfo jhAmInfo : this.jobInfo.getAMInfos()) {
            AMInfo amInfo = MRBuilderUtils.newAMInfo((ApplicationAttemptId)jhAmInfo.getAppAttemptId(), (long)jhAmInfo.getStartTime(), (ContainerId)jhAmInfo.getContainerId(), (String)jhAmInfo.getNodeManagerHost(), (int)jhAmInfo.getNodeManagerPort(), (int)jhAmInfo.getNodeManagerHttpPort());
            amInfos.add(amInfo);
        }
        return amInfos;
    }
}

