/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class CompletedTaskAttempt
implements TaskAttempt {
    private final JobHistoryParser.TaskAttemptInfo attemptInfo;
    private final TaskAttemptId attemptId;
    private org.apache.hadoop.mapreduce.v2.api.records.Counters counters;
    private final TaskAttemptState state;
    private final TaskAttemptReport report;
    private final List<String> diagnostics = new ArrayList<String>();
    private String localDiagMessage;

    CompletedTaskAttempt(TaskId taskId, JobHistoryParser.TaskAttemptInfo attemptInfo) {
        this.attemptInfo = attemptInfo;
        this.attemptId = TypeConverter.toYarn((TaskAttemptID)attemptInfo.getAttemptId());
        if (attemptInfo.getCounters() != null) {
            this.counters = TypeConverter.toYarn((Counters)attemptInfo.getCounters());
        }
        if (attemptInfo.getTaskStatus() != null) {
            this.state = TaskAttemptState.valueOf((String)attemptInfo.getTaskStatus());
        } else {
            this.state = TaskAttemptState.KILLED;
            this.localDiagMessage = "Attmpt state missing from History : marked as KILLED";
            this.diagnostics.add(this.localDiagMessage);
        }
        if (attemptInfo.getError() != null) {
            this.diagnostics.add(attemptInfo.getError());
        }
        this.report = (TaskAttemptReport)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(TaskAttemptReport.class);
        this.report.setCounters(this.counters);
        this.report.setTaskAttemptId(this.attemptId);
        this.report.setTaskAttemptState(this.state);
        this.report.setProgress(this.getProgress());
        this.report.setStartTime(attemptInfo.getStartTime());
        this.report.setFinishTime(attemptInfo.getFinishTime());
        this.report.setShuffleFinishTime(attemptInfo.getShuffleFinishTime());
        this.report.setSortFinishTime(attemptInfo.getSortFinishTime());
        if (this.localDiagMessage != null) {
            this.report.setDiagnosticInfo(attemptInfo.getError() + ", " + this.localDiagMessage);
        } else {
            this.report.setDiagnosticInfo(attemptInfo.getError());
        }
        this.report.setStateString(attemptInfo.getState());
        this.report.setCounters(this.getCounters());
        this.report.setContainerId(attemptInfo.getContainerId());
        String[] hostSplits = attemptInfo.getHostname().split(":");
        if (hostSplits.length != 2) {
            this.report.setNodeManagerHost("UNKNOWN");
        } else {
            this.report.setNodeManagerHost(hostSplits[0]);
            this.report.setNodeManagerPort(Integer.parseInt(hostSplits[1]));
        }
        this.report.setNodeManagerHttpPort(attemptInfo.getHttpPort());
    }

    public ContainerId getAssignedContainerID() {
        return this.attemptInfo.getContainerId();
    }

    public String getAssignedContainerMgrAddress() {
        return this.attemptInfo.getHostname();
    }

    public String getNodeHttpAddress() {
        return this.attemptInfo.getTrackerName() + ":" + this.attemptInfo.getHttpPort();
    }

    public String getNodeRackName() {
        return this.attemptInfo.getRackname();
    }

    public org.apache.hadoop.mapreduce.v2.api.records.Counters getCounters() {
        return this.counters;
    }

    public TaskAttemptId getID() {
        return this.attemptId;
    }

    public float getProgress() {
        return 1.0f;
    }

    public TaskAttemptReport getReport() {
        return this.report;
    }

    public TaskAttemptState getState() {
        return this.state;
    }

    public boolean isFinished() {
        return true;
    }

    public List<String> getDiagnostics() {
        return this.diagnostics;
    }

    public long getLaunchTime() {
        return this.report.getStartTime();
    }

    public long getFinishTime() {
        return this.report.getFinishTime();
    }

    public long getShuffleFinishTime() {
        return this.report.getShuffleFinishTime();
    }

    public long getSortFinishTime() {
        return this.report.getSortFinishTime();
    }

    public int getShufflePort() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

