/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskResponse;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.security.authorize.MRAMPolicyProvider;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebApp;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class HistoryClientService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(HistoryClientService.class);
    private MRClientProtocol protocolHandler;
    private Server server;
    private WebApp webApp;
    private InetSocketAddress bindAddress;
    private HistoryContext history;

    public HistoryClientService(HistoryContext history) {
        super("HistoryClientService");
        this.history = history;
        this.protocolHandler = new MRClientProtocolHandler();
    }

    public void start() {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.initializeWebApp(conf);
        String serviceAddr = conf.get("mapreduce.jobhistory.address", "0.0.0.0:10020");
        InetSocketAddress address = NetUtils.createSocketAddr((String)serviceAddr, (int)10020, (String)"0.0.0.0:10020");
        InetAddress hostNameResolved = null;
        try {
            hostNameResolved = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new YarnException((Throwable)e);
        }
        this.server = rpc.getServer(MRClientProtocol.class, (Object)this.protocolHandler, address, conf, null, conf.getInt("mapreduce.jobhistory.client.thread-count", 10));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(conf, (PolicyProvider)new MRAMPolicyProvider());
        }
        this.server.start();
        this.bindAddress = NetUtils.createSocketAddr((String)(hostNameResolved.getHostAddress() + ":" + this.server.getPort()));
        LOG.info((Object)("Instantiated MRClientService at " + this.bindAddress));
        super.start();
    }

    private void initializeWebApp(Configuration conf) {
        this.webApp = new HsWebApp(this.history);
        String bindAddress = conf.get("mapreduce.jobhistory.webapp.address", "0.0.0.0:19888");
        WebApps.$for((String)"jobhistory", (Object)((Object)this)).with(conf).at(bindAddress).start(this.webApp);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.webApp != null) {
            this.webApp.stop();
        }
        super.stop();
    }

    private class MRClientProtocolHandler
    implements MRClientProtocol {
        private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

        private MRClientProtocolHandler() {
        }

        private Job verifyAndGetJob(final JobId jobID) throws YarnRemoteException {
            UserGroupInformation loginUgi = null;
            Job job = null;
            try {
                loginUgi = UserGroupInformation.getLoginUser();
                job = (Job)loginUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Job>(){

                    @Override
                    public Job run() throws Exception {
                        Job job = HistoryClientService.this.history.getJob(jobID);
                        return job;
                    }
                });
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
            if (job == null) {
                throw RPCUtil.getRemoteException((String)("Unknown job " + jobID));
            }
            JobACL operation = JobACL.VIEW_JOB;
            this.checkAccess(job, operation);
            return job;
        }

        public GetCountersResponse getCounters(GetCountersRequest request) throws YarnRemoteException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId);
            GetCountersResponse response = (GetCountersResponse)this.recordFactory.newRecordInstance(GetCountersResponse.class);
            response.setCounters(job.getCounters());
            return response;
        }

        public GetJobReportResponse getJobReport(GetJobReportRequest request) throws YarnRemoteException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId);
            GetJobReportResponse response = (GetJobReportResponse)this.recordFactory.newRecordInstance(GetJobReportResponse.class);
            response.setJobReport(job.getReport());
            return response;
        }

        public GetTaskAttemptReportResponse getTaskAttemptReport(GetTaskAttemptReportRequest request) throws YarnRemoteException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            Job job = this.verifyAndGetJob(taskAttemptId.getTaskId().getJobId());
            GetTaskAttemptReportResponse response = (GetTaskAttemptReportResponse)this.recordFactory.newRecordInstance(GetTaskAttemptReportResponse.class);
            response.setTaskAttemptReport(job.getTask(taskAttemptId.getTaskId()).getAttempt(taskAttemptId).getReport());
            return response;
        }

        public GetTaskReportResponse getTaskReport(GetTaskReportRequest request) throws YarnRemoteException {
            TaskId taskId = request.getTaskId();
            Job job = this.verifyAndGetJob(taskId.getJobId());
            GetTaskReportResponse response = (GetTaskReportResponse)this.recordFactory.newRecordInstance(GetTaskReportResponse.class);
            response.setTaskReport(job.getTask(taskId).getReport());
            return response;
        }

        public GetTaskAttemptCompletionEventsResponse getTaskAttemptCompletionEvents(GetTaskAttemptCompletionEventsRequest request) throws YarnRemoteException {
            JobId jobId = request.getJobId();
            int fromEventId = request.getFromEventId();
            int maxEvents = request.getMaxEvents();
            Job job = this.verifyAndGetJob(jobId);
            GetTaskAttemptCompletionEventsResponse response = (GetTaskAttemptCompletionEventsResponse)this.recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsResponse.class);
            response.addAllCompletionEvents(Arrays.asList(job.getTaskAttemptCompletionEvents(fromEventId, maxEvents)));
            return response;
        }

        public KillJobResponse killJob(KillJobRequest request) throws YarnRemoteException {
            throw RPCUtil.getRemoteException((String)"Invalid operation on completed job");
        }

        public KillTaskResponse killTask(KillTaskRequest request) throws YarnRemoteException {
            throw RPCUtil.getRemoteException((String)"Invalid operation on completed job");
        }

        public KillTaskAttemptResponse killTaskAttempt(KillTaskAttemptRequest request) throws YarnRemoteException {
            throw RPCUtil.getRemoteException((String)"Invalid operation on completed job");
        }

        public GetDiagnosticsResponse getDiagnostics(GetDiagnosticsRequest request) throws YarnRemoteException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            Job job = this.verifyAndGetJob(taskAttemptId.getTaskId().getJobId());
            GetDiagnosticsResponse response = (GetDiagnosticsResponse)this.recordFactory.newRecordInstance(GetDiagnosticsResponse.class);
            response.addAllDiagnostics(job.getTask(taskAttemptId.getTaskId()).getAttempt(taskAttemptId).getDiagnostics());
            return response;
        }

        public FailTaskAttemptResponse failTaskAttempt(FailTaskAttemptRequest request) throws YarnRemoteException {
            throw RPCUtil.getRemoteException((String)"Invalid operation on completed job");
        }

        public GetTaskReportsResponse getTaskReports(GetTaskReportsRequest request) throws YarnRemoteException {
            JobId jobId = request.getJobId();
            TaskType taskType = request.getTaskType();
            GetTaskReportsResponse response = (GetTaskReportsResponse)this.recordFactory.newRecordInstance(GetTaskReportsResponse.class);
            Job job = this.verifyAndGetJob(jobId);
            Collection tasks = job.getTasks(taskType).values();
            for (Task task : tasks) {
                response.addTaskReport(task.getReport());
            }
            return response;
        }

        private void checkAccess(Job job, JobACL jobOperation) throws YarnRemoteException {
            UserGroupInformation callerUGI;
            if (!UserGroupInformation.isSecurityEnabled()) {
                return;
            }
            try {
                callerUGI = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
            if (!job.checkAccess(callerUGI, jobOperation)) {
                throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + jobOperation.name() + " on " + job.getID()));
            }
        }
    }
}

