/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class HsTasksBlock
extends HtmlBlock {
    final App app;

    @Inject
    HsTasksBlock(App app) {
        this.app = app;
    }

    protected void render(HtmlBlock.Block html) {
        if (this.app.getJob() == null) {
            html.h2(this.$("title"));
            return;
        }
        TaskType type = null;
        String symbol = this.$("task.type");
        if (!symbol.isEmpty()) {
            type = MRApps.taskType((String)symbol);
        }
        Hamlet.THEAD thead = html.table("#tasks").thead();
        int attemptColSpan = type == TaskType.REDUCE ? 8 : 3;
        ((Hamlet.TR)((Hamlet.TR)thead.tr().th().$colspan(5).$class("ui-state-default")._(new Object[]{"Task"})._()).th().$colspan(attemptColSpan).$class("ui-state-default")._(new Object[]{"Successful Attempt"})._())._();
        Hamlet.TR theadRow = thead.tr().th("Name").th("State").th("Start Time").th("Finish Time").th("Elapsed Time").th("Start Time");
        if (type == TaskType.REDUCE) {
            theadRow.th("Shuffle Finish Time");
            theadRow.th("Merge Finish Time");
        }
        theadRow.th("Finish Time");
        if (type == TaskType.REDUCE) {
            theadRow.th("Elapsed Time Shuffle");
            theadRow.th("Elapsed Time Merge");
            theadRow.th("Elapsed Time Reduce");
        }
        theadRow.th("Elapsed Time");
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)theadRow._())._()).tbody();
        for (Task task : this.app.getJob().getTasks().values()) {
            if (type != null && task.getType() != type) continue;
            String tid = MRApps.toString((TaskId)task.getID());
            TaskReport report = task.getReport();
            long startTime = report.getStartTime();
            long finishTime = report.getFinishTime();
            long elapsed = Times.elapsed((long)startTime, (long)finishTime, (boolean)false);
            long attemptStartTime = -1L;
            long shuffleFinishTime = -1L;
            long sortFinishTime = -1L;
            long attemptFinishTime = -1L;
            long elapsedShuffleTime = -1L;
            long elapsedSortTime = -1L;
            long elapsedReduceTime = -1L;
            long attemptElapsed = -1L;
            TaskAttempt successful = this.getSuccessfulAttempt(task);
            if (successful != null) {
                attemptStartTime = successful.getLaunchTime();
                attemptFinishTime = successful.getFinishTime();
                if (type == TaskType.REDUCE) {
                    shuffleFinishTime = successful.getShuffleFinishTime();
                    sortFinishTime = successful.getSortFinishTime();
                    elapsedShuffleTime = Times.elapsed((long)attemptStartTime, (long)shuffleFinishTime, (boolean)false);
                    elapsedSortTime = Times.elapsed((long)shuffleFinishTime, (long)sortFinishTime, (boolean)false);
                    elapsedReduceTime = Times.elapsed((long)sortFinishTime, (long)attemptFinishTime, (boolean)false);
                }
                attemptElapsed = Times.elapsed((long)attemptStartTime, (long)attemptFinishTime, (boolean)false);
            }
            Hamlet.TR row = tbody.tr();
            ((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)row.td().br().$title(String.valueOf(task.getID().getId()))._()).a(this.url(new String[]{"task", tid}), tid)._()).td(report.getTaskState().toString()).td().br().$title(String.valueOf(startTime))._())._(new Object[]{Times.format((long)startTime)})._()).td().br().$title(String.valueOf(finishTime))._())._(new Object[]{Times.format((long)finishTime)})._()).td().br().$title(String.valueOf(elapsed))._())._(new Object[]{this.formatTime(elapsed)})._()).td().br().$title(String.valueOf(attemptStartTime))._())._(new Object[]{Times.format((long)attemptStartTime)})._();
            if (type == TaskType.REDUCE) {
                ((Hamlet.TD)row.td().br().$title(String.valueOf(shuffleFinishTime))._())._(new Object[]{Times.format((long)shuffleFinishTime)})._();
                ((Hamlet.TD)row.td().br().$title(String.valueOf(sortFinishTime))._())._(new Object[]{Times.format((long)sortFinishTime)})._();
            }
            ((Hamlet.TD)row.td().br().$title(String.valueOf(attemptFinishTime))._())._(new Object[]{Times.format((long)attemptFinishTime)})._();
            if (type == TaskType.REDUCE) {
                ((Hamlet.TD)row.td().br().$title(String.valueOf(elapsedShuffleTime))._())._(new Object[]{this.formatTime(elapsedShuffleTime)})._();
                ((Hamlet.TD)row.td().br().$title(String.valueOf(elapsedSortTime))._())._(new Object[]{this.formatTime(elapsedSortTime)})._();
                ((Hamlet.TD)row.td().br().$title(String.valueOf(elapsedReduceTime))._())._(new Object[]{this.formatTime(elapsedReduceTime)})._();
            }
            ((Hamlet.TD)row.td().br().$title(String.valueOf(attemptElapsed))._())._(new Object[]{this.formatTime(attemptElapsed)})._();
            row._();
        }
        Hamlet.TR footRow = ((Hamlet.TABLE)tbody._()).tfoot().tr();
        ((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("task").$value("ID")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("state").$value("State")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Start Time")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("finish_time").$value("Finish Time")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_time").$value("Elapsed Time")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_start_time").$value("Start Time")._())._();
        if (type == TaskType.REDUCE) {
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("shuffle_time").$value("Shuffle Time")._())._();
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("merge_time").$value("Merge Time")._())._();
        }
        ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_finish").$value("Finish Time")._())._();
        if (type == TaskType.REDUCE) {
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_shuffle_time").$value("Elapsed Shuffle Time")._())._();
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_merge_time").$value("Elapsed Merge Time")._())._();
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_reduce_time").$value("Elapsed Reduce Time")._())._();
        }
        ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_elapsed").$value("Elapsed Time")._())._();
        ((Hamlet.TABLE)((Hamlet.TFOOT)footRow._())._())._();
    }

    private String formatTime(long elapsed) {
        return elapsed < 0L ? "N/A" : StringUtils.formatTime((long)elapsed);
    }

    private TaskAttempt getSuccessfulAttempt(Task task) {
        for (TaskAttempt attempt : task.getAttempts().values()) {
            if (attempt.getState() != TaskAttemptState.SUCCEEDED) continue;
            return attempt;
        }
        return null;
    }
}

