/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.v2.hs.HistoryClientService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.JHSDelegationTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;

public class JobHistoryServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    public static final long historyServerTimeStamp = System.currentTimeMillis();
    private static final Log LOG = LogFactory.getLog(JobHistoryServer.class);
    private HistoryContext historyContext;
    private HistoryClientService clientService;
    private JobHistory jobHistoryService;
    private JHSDelegationTokenSecretManager jhsDTSecretManager;
    private AggregatedLogDeletionService aggLogDelService;

    public JobHistoryServer() {
        super(JobHistoryServer.class.getName());
    }

    public synchronized void init(Configuration conf) {
        YarnConfiguration config = new YarnConfiguration(conf);
        config.setBoolean("yarn.dispatcher.exit-on-error", true);
        try {
            this.doSecureLogin(conf);
        }
        catch (IOException ie) {
            throw new YarnException("History Server Failed to login", (Throwable)ie);
        }
        this.jobHistoryService = new JobHistory();
        this.historyContext = this.jobHistoryService;
        this.jhsDTSecretManager = this.createJHSSecretManager(conf);
        this.clientService = new HistoryClientService(this.historyContext, this.jhsDTSecretManager);
        this.aggLogDelService = new AggregatedLogDeletionService();
        this.addService((Service)this.jobHistoryService);
        this.addService((Service)this.clientService);
        this.addService((Service)this.aggLogDelService);
        super.init((Configuration)config);
    }

    protected JHSDelegationTokenSecretManager createJHSSecretManager(Configuration conf) {
        long secretKeyInterval = conf.getLong("mapreduce.cluster.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("mapreduce.cluster.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("mapreduce.cluster.delegation.token.renew-interval", 86400000L);
        return new JHSDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L);
    }

    protected void doSecureLogin(Configuration conf) throws IOException {
        SecurityUtil.login((Configuration)conf, (String)"mapreduce.jobhistory.keytab", (String)"mapreduce.jobhistory.principal");
    }

    public void start() {
        DefaultMetricsSystem.initialize((String)"JobHistoryServer");
        JvmMetrics.initSingleton((String)"JobHistoryServer", null);
        try {
            this.jhsDTSecretManager.startThreads();
        }
        catch (IOException io) {
            LOG.error((Object)"Error while starting the Secret Manager threads", (Throwable)io);
            throw new RuntimeException(io);
        }
        super.start();
    }

    public void stop() {
        this.jhsDTSecretManager.stopThreads();
        DefaultMetricsSystem.shutdown();
        super.stop();
    }

    @InterfaceAudience.Private
    public HistoryClientService getClientService() {
        return this.clientService;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(JobHistoryServer.class, (String[])args, (Log)LOG);
        try {
            JobHistoryServer jobHistoryServer = new JobHistoryServer();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)jobHistoryServer), 30);
            YarnConfiguration conf = new YarnConfiguration((Configuration)new JobConf());
            jobHistoryServer.init((Configuration)conf);
            jobHistoryServer.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting JobHistoryServer", t);
            System.exit(-1);
        }
    }
}

